/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class BareBonesBrowserLaunch {
    private static final Logger logger = Logger.getLogger(BareBonesBrowserLaunch.class.toString());
    private static final String errMsg = "Error attempting to launch web browser";
    public static final String FILE_PREFIX = "file://";
    private static String os = System.getProperty("os.name").toLowerCase();

    public static void openURL(String url) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Opening URL: " + url);
            }
            if (BareBonesBrowserLaunch.isMac()) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (BareBonesBrowserLaunch.isWindows()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else if (BareBonesBrowserLaunch.isUnix()) {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            } else {
                JOptionPane.showMessageDialog(null, errMsg);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static void openFile(String filePath) {
        BareBonesBrowserLaunch.openURL(FILE_PREFIX + filePath);
    }

    public static boolean isWindows() {
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }
}

