/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.border.AbstractBorder;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.views.AnnotationComponent;

public class ResizableBorder
extends AbstractBorder {
    private static final Logger logger;
    private static Color selectColor;
    private static Color outlineColor;
    private static Color outlineResizeColor;
    public static final int INSETS = 5;
    private static final int[] locations;
    private static final int[] cursors;
    private static final Stroke dashedBorder;
    private static final Stroke solidBorder;
    protected int resizeWidgetDim;
    protected int originalResizeWidgetDim;
    protected int inset;

    public ResizableBorder(int resizeBoxSize) {
        this.originalResizeWidgetDim = resizeBoxSize;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    public void setZoom(float zoom) {
        this.resizeWidgetDim = (int)((float)this.originalResizeWidgetDim * zoom);
        this.inset = (int)((double)(5.0f * zoom) + 0.5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        boolean isSelected = false;
        boolean isBorderStyle = false;
        boolean isEditable = false;
        boolean isRollover = false;
        boolean isMovable = false;
        boolean isResizable = false;
        boolean isShowInvisibleBorder = false;
        if (component instanceof AnnotationComponent) {
            AnnotationComponent annot = (AnnotationComponent)((Object)component);
            isSelected = annot.isSelected();
            isBorderStyle = annot.isBorderStyle();
            isEditable = annot.isEditable();
            isRollover = annot.isRollover();
            isMovable = annot.isMovable();
            isResizable = annot.isResizable();
            isShowInvisibleBorder = annot.isShowInvisibleBorder();
        }
        if (!isEditable) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(dashedBorder);
        if (isSelected || component.hasFocus() || isRollover) {
            g2.setColor(selectColor);
        } else {
            g2.setColor(outlineColor);
        }
        if (isSelected || isRollover || isShowInvisibleBorder && !isBorderStyle) {
            g2.drawRect(x, y, w - 1, h - 1);
        }
        g2.setColor(outlineResizeColor);
        g2.setStroke(solidBorder);
        if ((isSelected || isRollover) && isResizable) {
            for (int location : locations) {
                Rectangle rect = this.getRectangle(x, y, w, h, location);
                g2.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        }
    }

    private Rectangle getRectangle(int x, int y, int w, int h, int location) {
        switch (location) {
            case 1: {
                return new Rectangle(x + w / 2 - this.resizeWidgetDim / 2, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 5: {
                return new Rectangle(x + w / 2 - this.resizeWidgetDim / 2, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 7: {
                return new Rectangle(x, y + h / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 3: {
                return new Rectangle(x + w - this.resizeWidgetDim, y + h / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 8: {
                return new Rectangle(x, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 2: {
                return new Rectangle(x + w - this.resizeWidgetDim, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 6: {
                return new Rectangle(x, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 4: {
                return new Rectangle(x + w - this.resizeWidgetDim, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
        }
        return null;
    }

    public int getCursor(MouseEvent me) {
        Component c = me.getComponent();
        boolean isEditable = false;
        boolean isMovable = false;
        boolean isResizable = false;
        if (c instanceof AnnotationComponent) {
            AnnotationComponent annot = (AnnotationComponent)((Object)c);
            isEditable = annot.isEditable();
            isResizable = annot.isResizable();
            isMovable = annot.isMovable();
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (isResizable) {
            for (int i = 0; i < locations.length; ++i) {
                Rectangle rect = this.getRectangle(0, 0, w, h, locations[i]);
                if (!rect.contains(me.getPoint())) continue;
                return cursors[i];
            }
        }
        if (isMovable) {
            return 13;
        }
        return 0;
    }

    static {
        block2: {
            logger = Logger.getLogger(ResizableBorder.class.toString());
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.select.color", "#999999");
                int colorValue = ColorUtil.convertColor(color);
                selectColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("999999", 16));
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.outline.color", "#cccccc");
                colorValue = ColorUtil.convertColor(color);
                outlineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("cccccc", 16));
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.outline.colorResize", "#666666");
                colorValue = ColorUtil.convertColor(color);
                outlineResizeColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("666666", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading page annotation outline colour");
            }
        }
        locations = new int[]{1, 5, 7, 3, 8, 2, 6, 4};
        cursors = new int[]{8, 9, 10, 11, 6, 7, 4, 5};
        dashedBorder = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 1.0f}, 0.0f);
        solidBorder = new BasicStroke(1.0f, 0, 2, 0.0f);
    }
}

