/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.tree.DefaultMutableTreeNode;
import org.icepdf.core.pobjects.NameNode;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;

public class NameTreeNode
extends DefaultMutableTreeNode {
    private NameNode item;
    private StringObject name;
    private Reference reference;
    private ResourceBundle messageBundle;
    private MessageFormat formatter;
    private boolean rootNode;
    private boolean intermidiatNode;
    private boolean leaf;
    private boolean loadedChildren;

    public NameTreeNode(NameNode item, ResourceBundle messageBundle) {
        this.item = item;
        this.messageBundle = messageBundle;
        if (!item.hasLimits()) {
            this.rootNode = true;
            this.setUserObject(messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.root.label"));
        } else {
            this.intermidiatNode = true;
            Object[] messageArguments = new Object[]{item.getLowerLimit(), item.getUpperLimit()};
            if (this.formatter == null) {
                this.formatter = new MessageFormat(messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.branch.label"));
            }
            this.setUserObject(this.formatter.format(messageArguments));
        }
    }

    public NameTreeNode(StringObject name, Reference ref) {
        this.leaf = true;
        this.name = name;
        this.reference = ref;
        this.setUserObject(name);
    }

    public void recursivelyClearOutlineItems() {
        this.item = null;
        if (this.loadedChildren) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                NameTreeNode node = (NameTreeNode)this.getChildAt(i);
                node.recursivelyClearOutlineItems();
            }
        }
    }

    public StringObject getName() {
        return this.name;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean isRootNode() {
        return this.rootNode;
    }

    public boolean isIntermidiatNode() {
        return this.intermidiatNode;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public void setRootNode(boolean rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenLoaded();
        return super.getChildCount();
    }

    private void ensureChildrenLoaded() {
        if (!this.loadedChildren && (this.intermidiatNode || this.rootNode)) {
            this.loadedChildren = true;
            if (this.item.getKidsReferences() != null) {
                int count = this.item.getKidsReferences().size();
                for (int i = 0; i < count; ++i) {
                    NameNode child = this.item.getNode(i);
                    NameTreeNode childTreeNode = new NameTreeNode(child, this.messageBundle);
                    this.add(childTreeNode);
                }
            }
            if (this.item.getNamesAndValues() != null) {
                List namesAndValues = this.item.getNamesAndValues();
                int max = namesAndValues.size();
                for (int i = 0; i < max; i += 2) {
                    StringObject name = (StringObject)namesAndValues.get(i);
                    Reference ref = (Reference)namesAndValues.get(i + 1);
                    this.add(new NameTreeNode(name, ref));
                }
            }
        }
    }
}

