/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.ri.common.tools.TextSelectionPageHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class HighLightAnnotationHandler
extends TextSelectionPageHandler {
    protected Name highLightType = Annotation.SUBTYPE_HIGHLIGHT;

    public HighLightAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ArrayList<Shape> highlightBounds = this.getSelectedTextBounds();
        super.mouseReleased(e);
        this.createTextMarkupAnnotation(highlightBounds);
    }

    public void createTextMarkupAnnotation(ArrayList<Shape> highlightBounds) {
        if (this.documentViewModel.isSelectAll()) {
            this.documentViewController.clearSelectedText();
        }
        if (highlightBounds == null) {
            highlightBounds = this.getSelectedTextBounds();
        }
        this.documentViewController.clearSelectedText();
        if (highlightBounds != null) {
            GeneralPath highlightPath = new GeneralPath();
            for (Shape bounds : highlightBounds) {
                highlightPath.append(bounds, false);
            }
            Rectangle bounds = highlightPath.getBounds();
            Rectangle tBbox = this.convertToPageSpace(highlightBounds, highlightPath);
            TextMarkupAnnotation annotation = (TextMarkupAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), this.highLightType, tBbox);
            annotation.setContents(this.highLightType.toString());
            annotation.setColor(annotation.getTextMarkupColor());
            annotation.setCreationDate(PDate.formatDateTime(new Date()));
            annotation.setTitleText(System.getProperty("user.name"));
            annotation.setMarkupBounds(highlightBounds);
            annotation.setMarkupPath(highlightPath);
            annotation.setBBox(tBbox);
            annotation.resetAppearanceStream(this.getPageTransform());
            AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
            comp.setBounds(bounds);
            comp.refreshAnnotationRect();
            if (this.documentViewController.getAnnotationCallback() != null) {
                AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
                annotationCallback.newAnnotation(this.pageViewComponent, comp);
            }
        }
        this.pageViewComponent.repaint();
    }

    @Override
    public void paintTool(Graphics g) {
        HighLightAnnotationHandler.paintSelectionBox(g, this.rectToDraw);
    }

    private ArrayList<Shape> getSelectedTextBounds() {
        PageText pageText;
        Page currentPage = this.pageViewComponent.getPage();
        ArrayList<Rectangle2D> highlightBounds = null;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            AffineTransform pageTransform = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            for (LineText lineText : pageText.getPageLines()) {
                for (WordText wordText : lineText.getWords()) {
                    GeneralPath textPath;
                    if (wordText.isSelected() || wordText.isHighlighted()) {
                        textPath = new GeneralPath(wordText.getBounds());
                        textPath.transform(pageTransform);
                        if (!wordText.isSelected()) continue;
                        if (highlightBounds == null) {
                            highlightBounds = new ArrayList<Rectangle2D>();
                        }
                        highlightBounds.add(textPath.getBounds2D());
                        continue;
                    }
                    for (GlyphText glyph : wordText.getGlyphs()) {
                        if (!glyph.isSelected()) continue;
                        textPath = new GeneralPath(glyph.getBounds());
                        textPath.transform(pageTransform);
                        if (highlightBounds == null) {
                            highlightBounds = new ArrayList();
                        }
                        highlightBounds.add(textPath.getBounds2D());
                    }
                }
            }
        }
        return highlightBounds;
    }

    protected Rectangle convertToPageSpace(ArrayList<Shape> bounds, GeneralPath path) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space.", e);
        }
        Rectangle tBbox = at.createTransformedShape(path).getBounds();
        for (int i = 0; i < bounds.size(); ++i) {
            Shape bound = bounds.get(i);
            bound = at.createTransformedShape(bound);
            bounds.set(i, bound);
        }
        path.transform(at);
        return tBbox;
    }
}

