/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.tools.DynamicZoomHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;

public class MouseWheelListenerPageChanger
implements MouseWheelListener {
    private SwingController controller;
    private JScrollPane scrollpane;
    private AbstractDocumentView documentView;
    private boolean changingPage;

    public static Object install(SwingController c, JScrollPane s, AbstractDocumentView documentView) {
        MouseWheelListenerPageChanger listener = null;
        if (c != null && s != null) {
            listener = new MouseWheelListenerPageChanger(c, s, documentView);
            s.addMouseWheelListener(listener);
        }
        return listener;
    }

    protected MouseWheelListenerPageChanger(SwingController c, JScrollPane s, AbstractDocumentView documentView) {
        this.controller = c;
        this.scrollpane = s;
        this.documentView = documentView;
        this.changingPage = false;
    }

    public static void uninstall(JScrollPane scrollpane, Object listener) {
        if (scrollpane != null && listener != null && listener instanceof MouseWheelListenerPageChanger) {
            scrollpane.removeMouseWheelListener((MouseWheelListenerPageChanger)listener);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar visibleVerticalScrollBar;
        if (this.changingPage) {
            return;
        }
        int deltaPage = 0;
        JScrollBar jScrollBar = visibleVerticalScrollBar = this.scrollpane.getVerticalScrollBar() != null && this.scrollpane.getVerticalScrollBar().isVisible() ? this.scrollpane.getVerticalScrollBar() : null;
        if ((e.getModifiers() & 2) != 2 && !(this.documentView.getCurrentToolHandler() instanceof DynamicZoomHandler)) {
            int amount = e.getScrollAmount();
            int rotation = e.getWheelRotation();
            if (amount > 0 && rotation > 0) {
                if (visibleVerticalScrollBar != null) {
                    int max;
                    int extent;
                    int value = visibleVerticalScrollBar.getModel().getValue();
                    if (value + (extent = visibleVerticalScrollBar.getModel().getExtent()) >= (max = visibleVerticalScrollBar.getModel().getMaximum())) {
                        deltaPage = this.documentView.getPreviousPageIncrement();
                    }
                } else {
                    deltaPage = this.documentView.getPreviousPageIncrement();
                }
            } else if (amount > 0 && rotation < 0) {
                if (visibleVerticalScrollBar != null) {
                    int value = visibleVerticalScrollBar.getModel().getValue();
                    if (value <= 0) {
                        deltaPage = -this.documentView.getPreviousPageIncrement();
                    }
                } else {
                    deltaPage = -this.documentView.getPreviousPageIncrement();
                }
            }
        }
        if (deltaPage == 0) {
            return;
        }
        int newPage = this.controller.getCurrentPageNumber() + deltaPage;
        if (this.controller.getDocument() == null) {
            return;
        }
        if (newPage < 0) {
            deltaPage = -this.controller.getCurrentPageNumber();
        }
        if (newPage >= this.controller.getDocument().getNumberOfPages()) {
            deltaPage = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (deltaPage == 0) {
            return;
        }
        this.changingPage = true;
        final int dp = deltaPage;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MouseWheelListenerPageChanger.this.changingPage = false;
                MouseWheelListenerPageChanger.this.controller.goToDeltaPage(dp);
            }
        });
    }
}

