/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class Indexed
extends PColorSpace {
    public static final Name INDEXED_KEY = new Name("Indexed");
    public static final Name I_KEY = new Name("I");
    PColorSpace colorSpace;
    int hival;
    byte[] colors = new byte[]{-1, -1, -1, 0, 0, 0};
    private boolean inited = false;
    private Color[] cols;

    Indexed(Library library, HashMap entries, List dictionary) {
        super(library, entries);
        this.colorSpace = Indexed.getColorSpace(library, dictionary.get(1));
        this.hival = ((Number)dictionary.get(2)).intValue();
        if (dictionary.get(3) instanceof StringObject) {
            StringObject tmpText = (StringObject)dictionary.get(3);
            String tmp = tmpText.getDecryptedLiteralString(library.securityManager);
            byte[] textBytes = new byte[this.colorSpace.getNumComponents() * (this.hival + 1)];
            for (int i = 0; i < textBytes.length; ++i) {
                textBytes[i] = (byte)tmp.charAt(i);
            }
            this.colors = textBytes;
        } else if (dictionary.get(3) instanceof Reference) {
            this.colors = new byte[this.colorSpace.getNumComponents() * (this.hival + 1)];
            Stream lookup = (Stream)library.getObject((Reference)dictionary.get(3));
            byte[] colorStream = lookup.getDecodedStreamBytes(0);
            int length = this.colors.length < colorStream.length ? this.colors.length : colorStream.length;
            System.arraycopy(colorStream, 0, this.colors, 0, length);
        }
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public String getDescription() {
        String desc = super.getDescription();
        if (this.colorSpace != null) {
            desc = desc + ":" + this.colorSpace.getDescription();
        }
        return desc;
    }

    @Override
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        int numCSComps = this.colorSpace.getNumComponents();
        int[] b1 = new int[numCSComps];
        float[] f1 = new float[numCSComps];
        this.cols = new Color[this.hival + 1];
        for (int j = 0; j <= this.hival; ++j) {
            for (int i = 0; i < numCSComps; ++i) {
                b1[numCSComps - 1 - i] = 0xFF & this.colors[j * numCSComps + i];
            }
            this.colorSpace.normaliseComponentsToFloats(b1, f1, 255.0f);
            this.cols[j] = this.colorSpace.getColor(f1);
        }
        this.inited = true;
    }

    @Override
    public Color getColor(float[] f, boolean fillAndStroke) {
        this.init();
        int index = (int)(f[0] * (float)(this.cols.length - 1));
        if (index < this.cols.length) {
            return this.cols[index];
        }
        return this.cols[(int)f[0]];
    }

    public Color[] accessColorTable() {
        return this.cols;
    }
}

