/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;
import org.icepdf.core.util.Library;

public class LZWDecode
extends ChunkingInputStream {
    public static final Name DECODEPARMS_KEY = new Name("DecodeParms");
    public static final Name EARLYCHANGE_KEY = new Name("EarlyChange");
    private BitStream inb;
    private int earlyChange;
    private int code;
    private int old_code;
    private boolean firstTime;
    private int code_len;
    private int last_code;
    private Code[] codes;

    public LZWDecode(BitStream inb, Library library, HashMap entries) {
        Number earlyChangeNumber;
        this.inb = inb;
        this.earlyChange = 1;
        HashMap decodeParmsDictionary = library.getDictionary(entries, DECODEPARMS_KEY);
        if (decodeParmsDictionary != null && (earlyChangeNumber = library.getNumber(decodeParmsDictionary, EARLYCHANGE_KEY)) != null) {
            this.earlyChange = earlyChangeNumber.intValue();
        }
        this.code = 0;
        this.old_code = 0;
        this.firstTime = true;
        this.initCodeTable();
        this.setBufferSize(4096);
    }

    @Override
    protected int fillInternalBuffer() throws IOException {
        int numRead = 0;
        if (this.firstTime) {
            this.firstTime = false;
            this.old_code = this.code = this.inb.getBits(this.code_len);
        } else if (this.inb.atEndOfFile()) {
            return -1;
        }
        do {
            if (this.code == 256) {
                this.initCodeTable();
            } else {
                byte first;
                Code c;
                Stack stack;
                if (this.code == 257) break;
                if (this.codes[this.code] != null) {
                    stack = new Stack();
                    this.codes[this.code].getString(stack);
                    c = (Code)stack.pop();
                    this.addToBuffer(c.c, numRead);
                    ++numRead;
                    first = c.c;
                    while (!stack.empty()) {
                        c = (Code)stack.pop();
                        this.addToBuffer(c.c, numRead);
                        ++numRead;
                    }
                    this.codes[this.last_code++] = new Code(this.codes[this.old_code], first);
                } else {
                    if (this.code != this.last_code) {
                        throw new RuntimeException("LZWDecode failure");
                    }
                    stack = new Stack();
                    this.codes[this.old_code].getString(stack);
                    c = (Code)stack.pop();
                    this.addToBuffer(c.c, numRead);
                    ++numRead;
                    first = c.c;
                    while (!stack.empty()) {
                        c = (Code)stack.pop();
                        this.addToBuffer(c.c, numRead);
                        ++numRead;
                    }
                    this.addToBuffer(first, numRead);
                    ++numRead;
                    this.codes[this.code] = new Code(this.codes[this.old_code], first);
                    ++this.last_code;
                }
            }
            if (this.code_len < 12 && this.last_code == (1 << this.code_len) - this.earlyChange) {
                ++this.code_len;
            }
            this.old_code = this.code;
            this.code = this.inb.getBits(this.code_len);
        } while (!this.inb.atEndOfFile() && numRead < this.buffer.length);
        return numRead;
    }

    private void initCodeTable() {
        this.code_len = 9;
        this.last_code = 257;
        this.codes = new Code[4096];
        for (int i = 0; i < 256; ++i) {
            this.codes[i] = new Code(null, (byte)i);
        }
    }

    private void addToBuffer(byte b, int offset) {
        if (offset >= this.buffer.length) {
            byte[] bufferNew = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, bufferNew, 0, this.buffer.length);
            this.buffer = bufferNew;
        }
        this.buffer[offset] = b;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.inb != null) {
            this.inb.close();
            this.inb = null;
        }
    }

    private static class Code {
        Code prefix;
        byte c;

        Code(Code p, byte cc) {
            this.prefix = p;
            this.c = cc;
        }

        void getString(Stack s) {
            s.push(this);
            if (this.prefix != null) {
                this.prefix.getString(s);
            }
        }
    }
}

