/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.datastructures;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GeometraDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    public static final String INTEGERS_ONLY = "0123456789";
    public static final String HEIGHT = "0123456789,.#";
    public static final String GEO_MATH = "0123456789,.-+*/()sintaco";
    public static final String NUMERIC = "0123456789,.";
    public static final String ZOOM = "0123456789%";
    private final String acceptedInput;

    public GeometraDocument(String acceptedInput) {
        this.acceptedInput = acceptedInput;
    }

    public GeometraDocument() {
        this(GEO_MATH);
    }

    @Override
    public void insertString(int offset, String inputStr, AttributeSet attr) throws BadLocationException {
        if (inputStr == null) {
            return;
        }
        if (this.acceptedInput.equals(GEO_MATH) || this.acceptedInput.equals(NUMERIC) || this.acceptedInput.equals(ZOOM) || this.acceptedInput.equals(HEIGHT) || this.acceptedInput.equals(INTEGERS_ONLY)) {
            for (int i = 0; i < inputStr.length(); ++i) {
                char c;
                if (this.acceptedInput.indexOf(String.valueOf(inputStr.charAt(i))) != -1 || (c = inputStr.charAt(i)) == '\u00a0') continue;
                return;
            }
            super.insertString(offset, inputStr, attr);
        }
    }
}

