/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.DropDownButton;
import se.sjobeck.images.IconLoader;

public class DotDrawingDropDownButton
extends DropDownButton
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final JMenuItem squareDotItem = new JRadioButtonMenuItem(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/square-dot.png"));
    private final JMenuItem crossDotItem = new JRadioButtonMenuItem(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/cross-dot.png"));
    private final JMenuItem triangleDotItem = new JRadioButtonMenuItem(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/triangle-dot.png"));
    private final JMenuItem rombDotItem = new JRadioButtonMenuItem(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/romb-dot.png"));
    private final JMenuItem hexagonDotItem = new JRadioButtonMenuItem(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/sext-dot.png"));
    private final ButtonPane buttonPane;

    public DotDrawingDropDownButton(AbstractButton mainButton, ButtonPane buttonPane) {
        super(mainButton);
        this.buttonPane = buttonPane;
        this.addMenuItem(this.squareDotItem);
        this.addMenuItem(this.crossDotItem);
        this.addMenuItem(this.triangleDotItem);
        this.addMenuItem(this.rombDotItem);
        this.addMenuItem(this.hexagonDotItem);
        ButtonGroup group = new ButtonGroup();
        group.add(this.squareDotItem);
        group.add(this.crossDotItem);
        group.add(this.triangleDotItem);
        group.add(this.rombDotItem);
        group.add(this.hexagonDotItem);
        this.squareDotItem.setSelected(true);
        this.squareDotItem.addActionListener(this);
        this.crossDotItem.addActionListener(this);
        this.triangleDotItem.addActionListener(this);
        this.rombDotItem.addActionListener(this);
        this.hexagonDotItem.addActionListener(this);
        this.init();
    }

    private void init() {
        this.dropDownButton.addMouseListener(this);
        this.dropDownButton.setBorderPainted(false);
        this.dropDownButton.setContentAreaFilled(false);
        this.dropDownButton.setRolloverEnabled(true);
        this.dropDownButton.setFocusPainted(false);
        this.dropDownButton.addMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.squareDotItem)) {
            this.mainButton.setIcon(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/square-dot.png"));
            PaintingStateMachine.getInstance().setDotState(DotDrawing.DotState.SQUARE);
        } else if (e.getSource().equals(this.crossDotItem)) {
            this.mainButton.setIcon(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/cross-dot.png"));
            PaintingStateMachine.getInstance().setDotState(DotDrawing.DotState.CROSS);
        } else if (e.getSource().equals(this.triangleDotItem)) {
            this.mainButton.setIcon(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/triangle-dot.png"));
            PaintingStateMachine.getInstance().setDotState(DotDrawing.DotState.TRIANGLE);
        } else if (e.getSource().equals(this.rombDotItem)) {
            this.mainButton.setIcon(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/romb-dot.png"));
            PaintingStateMachine.getInstance().setDotState(DotDrawing.DotState.ROMB);
        } else if (e.getSource().equals(this.hexagonDotItem)) {
            this.mainButton.setIcon(IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/icons/sext-dot.png"));
            PaintingStateMachine.getInstance().setDotState(DotDrawing.DotState.HEXAGON);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mainButton.setContentAreaFilled(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mainButton.isSelected()) {
            this.mainButton.setContentAreaFilled(true);
        } else {
            this.mainButton.setContentAreaFilled(false);
        }
    }
}

