/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.gui.panels.InfoPanel;

public class BlueprintTab
extends JTabbedPane
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private transient PDFController controller;
    private transient JScrollPane viewContainer;
    private final Map<JScrollPane, PDFController> map = new HashMap<JScrollPane, PDFController>();
    private final List<PDFController> list = new ArrayList<PDFController>();

    public BlueprintTab(InfoPanel infoPanel) {
        this.setTabLayoutPolicy(1);
        this.addChangeListener(this);
    }

    public BufferedImage getBufferedImageOfSelectedTab() {
        PDFController controller_ = this.list.get(this.getSelectedIndex());
        Dimension size = this.getSelectedComponent().getSize();
        BufferedImage bi = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = bi.getGraphics();
        controller_.getViewContainer().paint(graphics);
        return bi;
    }

    public void removeFromTab(int index) {
        if (index >= 0 && index <= this.getTabCount() - 1) {
            this.list.remove(index);
            this.removeTabAt(index);
        }
    }

    public void addToTab(PDFController controller) {
        this.viewContainer = (JScrollPane)controller.getViewContainer();
        this.viewContainer.setAutoscrolls(true);
        this.viewContainer.setOpaque(true);
        JScrollBar vBar = this.viewContainer.getVerticalScrollBar();
        vBar.setUnitIncrement(10);
        this.add(controller.getDescription(), this.viewContainer);
        this.map.put(this.viewContainer, controller);
        this.list.add(controller);
    }

    public Dimension getScreenSize() {
        return this.controller.getDimension();
    }

    public void setViewportView(Point2D p) {
        int changePosX = p.getX() < 0.0 ? 0 : (int)p.getX();
        int changePosY = p.getY() < 0.0 ? 0 : (int)p.getY();
        JViewport viewport = this.viewContainer.getViewport();
        viewport.setViewPosition(new Point(changePosX, changePosY));
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PDFController controller_;
        GeometraSubject sub = GeometraSubject.getInstance();
        if (this.list.size() > 0 && (controller_ = this.list.get(this.getSelectedIndex())) != null) {
            sub.pageSwitch(controller_.getBlueprint(), this);
        }
    }

    public void fullyUpdate() {
        this.viewContainer.invalidate();
        this.viewContainer.validate();
        this.viewContainer.revalidate();
        this.viewContainer.repaint();
    }

    public void updateName(String oldName, String newName) {
        int index = this.indexOfTab(oldName);
        this.setTitleAt(index, newName);
    }

    public int getActiveControllerIndex() {
        return this.getSelectedIndex();
    }
}

