/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.PDFFileFilter;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraPopupMenu;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.gui.login.TalkToServerThread;
import se.sjobeck.geometra.gui.main.GeometraMenu;
import se.sjobeck.geometra.gui.panels.BlueprintTab;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.ColorDialog;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.geometra.gui.panels.ToolbarDimensions2;
import se.sjobeck.geometra.gui.panels.TreeTab;
import se.sjobeck.gui.StartupScreen;
import se.sjobeck.images.IconLoader;
import se.sjobeck.network2.ApplicationType;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.ShutDownProgram;

public class Geometra
implements ShutDownProgram {
    public static NumberFormat standardFormat = null;
    private final TabManager manager = TabManager.getInstance();
    private final GeometraMenu geometraMenu;
    private static ColorDialog colorDialog;
    public static JFrame GEOMETRA_FRAME;
    public static final String GEOMETRA_NAME = "Geometra";
    public static final String GEOMETRA_VERSION = "1.9.91";
    private static JFileChooser jfcLoad;
    public static JFileChooser JFC_OPEN;
    public static JFileChooser JFC_SAVE;
    public static GeometraPopupMenu GEOMETRA_POPUP_MENU;
    public static final ImageIcon window_icon;
    private static JPanel buttonPane;
    private static JPanel contentPane;
    private static JPanel leftPane;
    private Font guiFont;
    private static BlueprintTab pdfTabs;
    private static JTreePDFPane treePane;
    private static ToolbarDimensions2 toolbarDimensions;
    private static TreeTab treeTab;
    private static ButtonPane buttonPaneNorth;
    private static JSplitPane splitPane;
    private static InfoPanel infoPane;
    private static JPopupMenu popup;
    private transient WindowAdapter wa = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent e) {
            System.exit(0);
        }
    };

    public static void updateSettings() {
        standardFormat = Geometra.createNumberFormat();
        jfcLoad = new JFileChooser(GeometraConfiguration.getOpenPath());
        JFC_SAVE = new JFileChooser(GeometraConfiguration.getSavePath());
        JFC_OPEN = new JFileChooser(GeometraConfiguration.getOpenPath());
        jfcLoad.setMultiSelectionEnabled(true);
        jfcLoad.setFileSelectionMode(0);
        jfcLoad.addChoosableFileFilter(new PDFFileFilter());
        jfcLoad.setAcceptAllFileFilterUsed(false);
        TreeTab.pathsMightHaveChanged(treeTab);
    }

    protected void createGUI() {
        infoPane = new InfoPanel();
        popup = new JPopupMenu();
        leftPane = Geometra.createLeftPane();
        contentPane = Geometra.createContentPane();
        buttonPane = Geometra.createButtonPane();
        pdfTabs = new BlueprintTab(infoPane);
        treePane = new JTreePDFPane(infoPane);
        toolbarDimensions = new ToolbarDimensions2();
        splitPane = new JSplitPane(1, leftPane, pdfTabs);
        Geometra.updateSettings();
        System.err.println("GEOMETRA VERSION: 1.9.91");
        System.err.println("pdfs: " + GeometraConfiguration.getSavePath());
        System.err.println("projects: " + GeometraConfiguration.getSavePath());
        GEOMETRA_FRAME.setTitle("Geometra V 1.9.91");
        BorderLayout bl = new BorderLayout();
        Dimension minimumSize = new Dimension(870, 700);
        GEOMETRA_FRAME.setPreferredSize(minimumSize);
        GEOMETRA_FRAME.setMinimumSize(minimumSize);
        GEOMETRA_FRAME.setLocationRelativeTo(null);
        JFrame.setDefaultLookAndFeelDecorated(true);
        GEOMETRA_FRAME.setLayout(bl);
        Geometra.installProperties();
        GEOMETRA_FRAME.setExtendedState(6);
        GEOMETRA_FRAME.addWindowListener(this.getWA());
    }

    public WindowAdapter getWA() {
        return this.wa;
    }

    private static void installProperties() {
        System.setProperty("com.icesoft.pdf.imagecache.enabled", "true");
        System.setProperty("com.icesoft.pdf.verbose", "false");
        System.setProperty("com.icesoft.pdf.scaleImages", "true");
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
    }

    public static File createSingleLoadDialog() {
        File file = null;
        jfcLoad.setMultiSelectionEnabled(false);
        jfcLoad.setVisible(true);
        int val = jfcLoad.showOpenDialog(GEOMETRA_FRAME);
        if (val == 0) {
            file = jfcLoad.getSelectedFile();
        }
        return file;
    }

    public static File[] createLoadDialog(String str) {
        int val;
        File[] files = null;
        jfcLoad.setMultiSelectionEnabled(true);
        jfcLoad.setVisible(true);
        if (str != null) {
            jfcLoad.setDialogTitle(str);
        }
        if ((val = jfcLoad.showOpenDialog(GEOMETRA_FRAME)) == 0) {
            files = jfcLoad.getSelectedFiles();
        }
        return files;
    }

    public static String showInputDialog(String input) {
        return (String)JOptionPane.showInputDialog(GEOMETRA_FRAME, input, "", 3, null, null, null);
    }

    public static int createQuery(String str, String regret) {
        Object[] options = new String[]{ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_YES"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_NO"), regret};
        int answer = JOptionPane.showOptionDialog(GEOMETRA_FRAME, str, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_WARNING"), -1, 2, null, options, options[0]);
        return answer;
    }

    public static int createQuery(String str) {
        Object[] options = new String[]{ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_YES"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_NO")};
        int answer = JOptionPane.showOptionDialog(GEOMETRA_FRAME, str, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_WARNING"), -1, 2, null, options, options[0]);
        return answer;
    }

    public static int createSaveAndLoadDialog(String str) {
        Object[] options = new String[]{ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_YES"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_NO"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_REGRET")};
        int answer = JOptionPane.showOptionDialog(GEOMETRA_FRAME, str, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_WARNING"), -1, 2, null, options, options[0]);
        return answer;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("file.encoding"));
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(Level.OFF);
        Logger.getLogger("se.sjobeck.rmi.encoded").addHandler(ch);
        Logger.getLogger("se.sjobeck.rmi.encoded").setLevel(Level.OFF);
        StartupScreen.init(null, ApplicationType.Geometra, window_icon.getImage());
        StartupScreen.setText("Geometra 1.9.91");
        StartupScreen.performLogin();
        StartupScreen.nullify();
        JFrame jf = new JFrame();
        Geometra geo = new Geometra(jf);
        jf.setExtendedState(6);
        jf.pack();
        jf.setVisible(true);
        TalkToServerThread ttst = new TalkToServerThread();
        ttst.start();
    }

    private static String getDateString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(new Date());
    }

    public static String showProjectDialog(String message, String title) {
        return (String)JOptionPane.showInputDialog(GEOMETRA_FRAME, message, title, -1, null, null, Geometra.getDateString());
    }

    public static String nameProject() {
        String inputStr = "";
        int nameLength = 0;
        while (nameLength <= 0) {
            inputStr = Geometra.showProjectDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_NAME_PROJECT"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_TITLE_NAME_PROJECT"));
            if (inputStr == null) {
                return null;
            }
            nameLength = (inputStr = inputStr.trim()).length();
            if (nameLength <= 0) {
                Geometra.showErrorDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_MUST_NAME_PROJECT"));
                continue;
            }
            if (GeometraUtilities.isLegalFilename(inputStr)) continue;
            Geometra.showErrorDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_ILLEGAL_CHARACTERS"));
            nameLength = -1;
        }
        return inputStr;
    }

    public static void repaintGUI() {
        GEOMETRA_FRAME.repaint();
    }

    public static void showColorChooser(GeometraCollection<GeometraDrawing> currentDrawings) {
        colorDialog = new ColorDialog(currentDrawings);
        colorDialog.setVisible(true);
    }

    public static Color choseProjectColor() {
        colorDialog.setVisible(true);
        return colorDialog.getDrawingColor();
    }

    @Deprecated
    public static Color setProjectColor() {
        colorDialog.setVisible(true);
        GeometraProperties.setProjectColor(colorDialog.getDrawingColor());
        return colorDialog.getDrawingColor();
    }

    public static void showColorChooser(GeometraDrawing currentDrawing) {
        colorDialog = new ColorDialog(currentDrawing);
        colorDialog.setVisible(true);
    }

    public static String showScaleDialog(double currentDistance) {
        String inputStr = (String)JOptionPane.showInputDialog(GEOMETRA_FRAME, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_SCALE_LENGTH"), "", 3, null, null, currentDistance);
        if (inputStr == null) {
            inputStr = "" + currentDistance;
        }
        return inputStr;
    }

    public Geometra(JFrame frame) {
        this(frame, null);
    }

    public Geometra(JFrame frame, List<ExportListener> exportListeners) {
        boolean lyckas_g\u00f6ra_katalog;
        GEOMETRA_FRAME = frame;
        File f = new File(GeometraConfiguration.getSavePath());
        if (!f.exists() && !(lyckas_g\u00f6ra_katalog = f.mkdirs())) {
            JOptionPane.showMessageDialog(frame, "you have no savepath, there is a high probability that you cant save projects, please call support", "Error while Init savepath", 0);
        }
        this.createGUI();
        this.geometraMenu = new GeometraMenu(infoPane, exportListeners, pdfTabs);
        treeTab = new TreeTab(treePane, toolbarDimensions, this.geometraMenu);
        toolbarDimensions.setJTreePDFPane(treePane);
        toolbarDimensions.setOptionDialog2(this.geometraMenu.getOptionDialog2());
        buttonPaneNorth = new ButtonPane(infoPane, treePane, pdfTabs, treeTab, this.geometraMenu);
        treeTab.setButtonPane(buttonPaneNorth);
        treeTab.setInfoPane(infoPane);
        InputMap map = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        InputMap treeMap = (InputMap)UIManager.get("Tree.ancestorInputMap");
        InputMap scrollMap = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        LookAndFeel.makeInputMap(null);
        KeyStroke keyStrokeF6 = KeyStroke.getKeyStroke(117, 0);
        KeyStroke keyStrokeF8 = KeyStroke.getKeyStroke(119, 0);
        map.remove(keyStrokeF6);
        map.remove(keyStrokeF8);
        frame.setIconImage(window_icon.getImage());
        this.manager.setTab(pdfTabs);
        contentPane.add(buttonPane);
        GeometraManager.getInstance().setTree(treePane);
        GEOMETRA_POPUP_MENU = new GeometraPopupMenu(popup, treePane);
        this.geometraMenu.setToolbarDimensions(toolbarDimensions);
        this.geometraMenu.setTreeTab(treeTab);
        leftPane.add(treeTab);
        this.geometraMenu.setButtonPane(buttonPaneNorth);
        buttonPane.add(buttonPaneNorth);
        buttonPaneNorth.setOpaque(true);
        buttonPaneNorth.setBackground(Color.BLACK);
        frame.setJMenuBar(this.geometraMenu);
        frame.add((Component)contentPane, "North");
        frame.add((Component)splitPane, "Center");
        frame.add((Component)infoPane, "South");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Geometra.shutDownGeometra();
            }
        });
        colorDialog = new ColorDialog();
        ClientThread.program = this;
    }

    public void closeProject() {
        this.geometraMenu.closeProject2();
    }

    @Override
    public void safeShutDown() {
        Geometra.shutDownGeometra();
    }

    protected static void shutDownGeometra() {
        int ans;
        if (!TabManager.getInstance().isLastProject()) {
            Geometra.innerShutDownGeometra();
            return;
        }
        int answer = Geometra.createQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_SHUT_DOWN"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_REGRET"));
        if (answer == 1 && (ans = Geometra.createQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_DO_YOU_WANT_TO_SAVE_PROJECT"))) == 0) {
            answer = 0;
        }
        if (answer == 0) {
            String definedName = TabManager.getInstance().getProjectName();
            if (definedName != null) {
                TabManager.getInstance().startSaving(buttonPaneNorth, infoPane);
            } else {
                String projectName = Geometra.nameProject();
                try {
                    TabManager.getInstance().startSavingAs(projectName, buttonPaneNorth, infoPane);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            Geometra.innerShutDownGeometra();
        } else if (answer == 1) {
            Geometra.innerShutDownGeometra();
        } else assert (answer == 2);
    }

    private static void innerShutDownGeometra() {
        GEOMETRA_FRAME.setVisible(false);
        GeometraSubject.getInstance().disposeAll(GEOMETRA_FRAME);
        GEOMETRA_FRAME.dispose();
    }

    private static JPanel createButtonPane() {
        GridLayout gl = new GridLayout();
        JPanel buttonPanel = new JPanel(gl);
        return buttonPanel;
    }

    private static JPanel createContentPane() {
        JPanel jp = new JPanel(new GridLayout(1, 0));
        return jp;
    }

    private static JPanel createLeftPane() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        return leftPanel;
    }

    public Font getFont() {
        return this.guiFont;
    }

    public void writeToConfig() {
    }

    public static int removeDrawingsDialog(GeometraCollection<GeometraDrawing> col) {
        if (col.size() == 1) {
            return Geometra.createRemoveQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_REMOVE_DRAWING"));
        }
        return Geometra.createRemoveQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_REMOVE_MARKED_DRAWINGS"));
    }

    private static int createRemoveQuery(String str) {
        Object[] options = new String[]{ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_YES"), ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_NO")};
        int answer = JOptionPane.showOptionDialog(GEOMETRA_FRAME, str, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_WARNING"), -1, 2, null, options, options[0]);
        return answer;
    }

    public static void showErrorDialog(String errorMessage) {
        JOptionPane.showMessageDialog(GEOMETRA_FRAME, errorMessage, "Error", 0);
    }

    public static void createInfoDialog(String errorMessage) {
        Geometra.createInfoDialog(errorMessage, "Information");
    }

    public static void createInfoDialog(String errorMessage, String title) {
        JOptionPane.showMessageDialog(GEOMETRA_FRAME, errorMessage, title, 1);
    }

    private static NumberFormat createNumberFormat() {
        int nDecimals = GeometraConfiguration.getNDecimals();
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(nDecimals);
        format.setMaximumFractionDigits(nDecimals);
        return format;
    }

    static {
        window_icon = IconLoader.getIcon("/se/sjobeck/images/green_16x16.png");
    }
}

