/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;

public class TextDrawing
extends GeometraDrawingImpl {
    private double textSize;
    private int rotation = 0;

    public TextDrawing() {
    }

    public TextDrawing(BlueprintPage page) {
        this.setParent(page);
        this.textSize = 12.0;
        this.init();
    }

    @Override
    public void paintVertices(Graphics2D g, BlueprintPage base) {
        g.setColor(this.getColor());
        for (Point2D vertexOnBlueprint : this.points) {
            Point2D vertexOnScreen = base.getAffineTransform().transform(vertexOnBlueprint, null);
            g.drawRect((int)Math.round(vertexOnScreen.getX()) - 6, (int)Math.round(vertexOnScreen.getY()) - 6, 12, 12);
        }
    }

    public double getTextSize() {
        return this.textSize;
    }

    @Override
    public void init() {
        this.path = new GeneralPath();
        this.altPath = new GeneralPath();
        this.buildPath();
    }

    @Override
    public void setClosed(boolean b) {
        this.isClosed = b;
    }

    @Override
    public void setFilled(boolean b) {
        this.isFilled = b;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getDistance() {
        return 0.0;
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public void addPoint(Point2D point) {
        this.points.add(this.componentToBlueprint(point));
        this.buildPath();
    }

    @Override
    public void buildPath() {
        if (this.points.size() > 0) {
            this.path.moveTo(((Point2D)this.points.get(0)).getX() - 6.0, ((Point2D)this.points.get(0)).getY() - 6.0);
            this.path.lineTo(((Point2D)this.points.get(0)).getX() + 12.0 - 6.0, ((Point2D)this.points.get(0)).getY() - 6.0);
            this.path.lineTo(((Point2D)this.points.get(0)).getX() + 12.0 - 6.0, ((Point2D)this.points.get(0)).getY() + 12.0 - 6.0);
            this.path.lineTo(((Point2D)this.points.get(0)).getX() - 6.0, ((Point2D)this.points.get(0)).getY() + 12.0 - 6.0);
            this.path.closePath();
            Point p = new Point((int)Math.floor(0.5 + ((Point2D)this.points.get(0)).getX()), (int)Math.floor(0.5 + ((Point2D)this.points.get(0)).getY()));
            this.setCenterPoint(p);
        }
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        Font font = g.getFont();
        this.drawingFont = new Font(font.getName(), 1, (int)(this.getTextSize() + this.getScaleFactor(base.getAffineTransform()) * 1.0));
        g.setFont(this.drawingFont);
        g.setColor(this.getColor());
        Point2D.Double center = new Point2D.Double(((Point2D)this.points.get(0)).getX(), ((Point2D)this.points.get(0)).getY());
        double rot = (double)base.getRotation() * Math.PI / 180.0 + (double)this.rotation * Math.PI / 180.0;
        base.getAffineTransform().transform(center, center);
        g.rotate(-rot, ((Point2D)center).getX(), ((Point2D)center).getY());
        g.drawString(super.getDescription(), (float)((Point2D)center).getX(), (float)((Point2D)center).getY());
        g.rotate(rot, ((Point2D)center).getX(), ((Point2D)center).getY());
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
    }

    @Override
    public Line2D getLine(Point2D coord) {
        return null;
    }

    public void setTextSize(double textSize) {
        this.textSize = textSize;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }
}

