/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraLine;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.gui.main.Geometra;

public class LineDrawing
extends GeometraDrawingImpl {
    private static final long serialVersionUID = 1L;
    private GeometraLine line;
    private static int counter = 0;
    private Point centerPoint;
    private final double distanceDifference = 5.0;
    private transient Stroke dottedStroke = this.getStroke();
    private float lineWidth = 2.0f;

    private final Object readResolve() {
        this.dottedStroke = this.getStroke();
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    private Stroke getStroke() {
        BasicStroke stroke = new BasicStroke(this.lineWidth, 1, 1, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
        return stroke;
    }

    @Override
    public void init() {
        if (this.dottedStroke == null) {
            this.dottedStroke = this.getStroke();
        }
        this.path = new GeneralPath();
        this.altPath = new GeneralPath();
        this.buildPath();
    }

    public LineDrawing() {
    }

    public LineDrawing(BlueprintPage page) {
        this.setParent(page);
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_LINE_SHORT") + ++counter);
        this.setVisible(true);
    }

    public LineDrawing(LineDrawing ld, BlueprintPage page) {
        this.setParent(page);
        this.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_LINE_SHORT") + ++counter);
        this.setVisible(true);
    }

    @Override
    public Rectangle getRectangle() {
        return this.line.getBounds();
    }

    @Override
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    @Override
    public void addPoint(Point2D point) {
        if (!this.isClosed) {
            this.points.add(this.componentToBlueprint(point));
            this.buildPath();
        }
    }

    @Override
    public void buildPath() {
        this.path.reset();
        if (this.points.size() > 0) {
            this.path.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
            for (Point2D point : this.points) {
                this.path.lineTo((float)point.getX(), (float)point.getY());
            }
            this.centerPoint = this.createCenterPoint();
        }
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getColor());
        this.paintTheDrawing(g, base, clip);
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getSmartDrawingColor());
        this.paintTheDrawing(g, base, clip);
    }

    public void paintTheDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        g.setStroke(this.dottedStroke);
        if (this.path == null) {
            this.path = new GeneralPath(1);
            this.buildPath();
        }
        GeneralPath p = (GeneralPath)this.path.clone();
        p.transform(base.getAffineTransform());
        if (this.isFilled) {
            g.fill(p);
        } else {
            g.draw(p);
        }
        Stroke oldStroke = g.getStroke();
        p = (GeneralPath)this.altPath.clone();
        p.transform(base.getAffineTransform());
        g.draw(p);
        g.setStroke(oldStroke);
    }

    @Override
    public void setClosed(boolean close) {
        this.isClosed = close;
    }

    public Line2D getLine(Point2D coord, BlueprintPage blueprintPage) {
        GeometraLine line_ = new GeometraLine();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D p1 = (Point2D)this.points.get(i);
            Point2D p2 = (Point2D)this.points.get(i + 1);
            ((Line2D)line_).setLine(p1, p2);
            if (!(line_.ptSegDist(coord) < 5.0)) continue;
            ((Line2D)line_).setLine((Point2D)this.points.get(i), (Point2D)this.points.get(i + 1));
            return line_;
        }
        if (this.points.size() != 0) {
            ((Line2D)line_).setLine((Point2D)this.points.get(this.points.size() - 1), (Point2D)this.points.get(0));
            if (line_.ptSegDist(coord) < 5.0) {
                return line_;
            }
        }
        return null;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFilled(boolean b) {
    }

    @Override
    public double getDistance() {
        double distanceSum = 0.0;
        if (!this.points.isEmpty()) {
            for (int i = 0; i < this.points.size() - 1; ++i) {
                Point2D start = (Point2D)this.points.get(i);
                Point2D end = (Point2D)this.points.get(i + 1);
                distanceSum += this.getParent().scaleToReal(start.distance(end));
            }
        }
        return distanceSum;
    }

    private Point createCenterPoint() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        double xDistance = maxX - minX;
        double yDistance = maxY - minY;
        Double xCor = new Double(minX + xDistance / 2.0);
        Double yCor = new Double(minY + yDistance / 2.0);
        return new Point(xCor.intValue(), yCor.intValue());
    }

    @Override
    public void paintDistances(Graphics2D g, BlueprintPage base, BlueprintPage.ViewingState state) {
        int originalSize = GeometraConfiguration.getFontSize();
        g.setRenderingHints(GEOMETRA_RENDER_HINTS);
        if (!this.points.isEmpty()) {
            Font font = g.getFont();
            g.setColor(Color.BLACK);
            this.drawingFont = new Font(font.getName(), 1, (int)((double)originalSize + this.getScaleFactor(base.getAffineTransform()) * 1.0));
            g.setFont(this.drawingFont);
            for (int i = 0; i < this.points.size() - 1; ++i) {
                Point2D start = (Point2D)this.points.get(i);
                Point2D end = (Point2D)this.points.get(i + 1);
                double distance = base.scaleToReal(start.distance(end));
                double wall = distance * this.getHeight();
                String dimensionString = state.equals((Object)BlueprintPage.ViewingState.SHOW_2D) ? Geometra.standardFormat.format(distance) : (state.equals((Object)BlueprintPage.ViewingState.SHOW_3D) ? "(" + Geometra.standardFormat.format(wall) + ")" : (state.equals((Object)BlueprintPage.ViewingState.SHOW_ALL) ? Geometra.standardFormat.format(distance) + " (" + Geometra.standardFormat.format(wall) + ")" : state.toString()));
                Point2D.Double center = new Point2D.Double(start.getX() + (end.getX() - start.getX()) / 2.0, start.getY() + (end.getY() - start.getY()) / 2.0);
                base.getAffineTransform().transform(center, center);
                g.drawString(dimensionString, (float)((Point2D)center).getX(), (float)((Point2D)center).getY());
            }
        }
    }

    @Override
    public void setStrokeWidth(float width) {
        this.lineWidth = width;
        this.dottedStroke = this.getStroke();
    }

    @Override
    public Line2D getLine(Point2D coord) {
        GeometraLine line_ = new GeometraLine();
        BlueprintPage page = this.getParent();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D p1 = page.blueprintToComponent((Point2D)this.points.get(i));
            Point2D p2 = page.blueprintToComponent((Point2D)this.points.get(i + 1));
            ((Line2D)line_).setLine(p1, p2);
            if (!(line_.ptSegDist(coord) < 5.0)) continue;
            ((Line2D)line_).setLine((Point2D)this.points.get(i), (Point2D)this.points.get(i + 1));
            return line_;
        }
        if (!this.points.isEmpty()) {
            ((Line2D)line_).setLine((Point2D)this.points.get(this.points.size() - 1), (Point2D)this.points.get(0));
            if (line_.ptSegDist(coord) < 5.0) {
                return line_;
            }
        }
        return null;
    }
}

