/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;

public class ClickSelectListener
extends GeometraMouseAdapter {
    private static final Logger clickLogger = Logger.getLogger(ClickSelectListener.class.getName());
    private final Blueprint blueprint;
    private GeometraDrawing currentDrawing;
    private Point2D offset;
    private boolean shouldExpand = false;
    private boolean shouldMove = false;
    private Point2D vertexPoint;
    private Line2D clickedLine;
    private GeometraCollection<GeometraDrawing> localActiveDrawings;

    public ClickSelectListener(Blueprint bp) {
        this.blueprint = bp;
        this.localActiveDrawings = ((IcePDFBlueprint)this.blueprint).getActivePage().getActiveDrawings();
    }

    private void expandDrawing(MouseEvent event) {
        Point2D clicked = this.geoManager.componentToBlueprint(this.blueprint, event.getPoint());
        this.vertexPoint.setLocation(clicked);
        this.currentDrawing.buildPath();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.currentDrawing != null && !this.currentDrawing.isClosed()) {
            if (this.shouldExpand) {
                this.expandDrawing(event);
            } else if (this.shouldMove) {
                this.moveDrawing(event);
            }
            this.geoSubject.update(this.currentDrawing, (Object)this);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.geoManager.setDrawingState(this.blueprint, BlueprintPage.DrawingState.NORMAL);
        if (e.getButton() == 1) {
            GeometraDrawing tempDrawing = this.geoManager.getDrawing(e.getPoint());
            if (tempDrawing == null && !e.isControlDown()) {
                this.geoSubject.select(null, this);
                return;
            }
            if (tempDrawing == null && e.isControlDown()) {
                return;
            }
            this.offset = this.geoManager.componentToBlueprint(this.blueprint, e.getPoint());
            this.currentDrawing = tempDrawing;
            if (!e.isControlDown()) {
                this.localActiveDrawings.clear();
            }
            if (this.localActiveDrawings.contains(this.currentDrawing)) {
                this.localActiveDrawings.remove(this.currentDrawing);
            } else {
                this.localActiveDrawings.add(this.currentDrawing);
            }
            this.geoSubject.select(this.localActiveDrawings, this);
            this.vertexPoint = this.currentDrawing.getVertex(e.getPoint());
            this.clickedLine = this.currentDrawing.getLine(this.geoManager.componentToBlueprint(this.blueprint, e.getPoint()));
            if (this.vertexPoint != null) {
                this.shouldExpand = true;
                this.shouldMove = false;
                this.clickedLine = null;
            } else if (this.clickedLine != null) {
                this.shouldMove = true;
                this.shouldExpand = false;
                this.vertexPoint = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.shouldExpand = false;
        this.shouldMove = false;
        this.vertexPoint = null;
        this.clickedLine = null;
        this.currentDrawing = null;
        this.offset = null;
    }

    private void moveDrawing(MouseEvent event) {
        Line2D activeLine;
        if (this.currentDrawing == null) {
            clickLogger.info("Drawing == null");
            return;
        }
        Point2D tempPoint = this.geoManager.componentToBlueprint(this.blueprint, event.getPoint());
        Point2D tempOffset = this.offset;
        if (tempOffset == null) {
            tempOffset = this.geoManager.componentToBlueprint(this.blueprint, event.getPoint());
        }
        if ((activeLine = this.currentDrawing.getLine(tempOffset)) == null) {
            clickLogger.info("drawing getLine == null");
            return;
        }
        Point2D p1 = activeLine.getP1();
        Point2D p2 = activeLine.getP2();
        p1.setLocation(p1.getX() + tempPoint.getX() - tempOffset.getX(), p1.getY() + tempPoint.getY() - tempOffset.getY());
        p2.setLocation(p2.getX() + tempPoint.getX() - tempOffset.getX(), p2.getY() + tempPoint.getY() - tempOffset.getY());
        this.offset = this.geoManager.componentToBlueprint(this.blueprint, event.getPoint());
        this.currentDrawing.buildPath();
    }
}

