/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.blueprint.GeometraPaintCommand;
import se.sjobeck.geometra.datastructures.blueprint.UndoRedoManager;
import se.sjobeck.geometra.datastructures.blueprint.ViewProperties;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.core.BlueprintPageImpl;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraScale;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.ZoomDrawing;

public class IcePDFPage
extends BlueprintPageImpl {
    private volatile transient ViewProperties properties = new ViewProperties(this);
    private transient UndoRedoManager manager = new UndoRedoManager();
    private final transient GeometraSubject geoSubject = GeometraSubject.getInstance();

    public ViewProperties getViewProperties() {
        if (this.properties == null) {
            this.properties = new ViewProperties(this);
        }
        return this.properties;
    }

    public IcePDFPage() {
    }

    public IcePDFPage(String description) {
        this.scaleDrawing = new GeometraScale(this);
        this.addDrawing(this.scaleDrawing);
        this.setDescription(description);
    }

    public void undo() {
        this.manager.undo();
    }

    @Override
    public void setScaleDrawing(ScaleDrawing sd) {
        super.setScaleDrawing(sd);
    }

    public void redo() {
        this.manager.redo();
    }

    public void add(int index, GeometraDrawing gd) {
        GeometraCollection<GeometraDrawing> col = super.getDrawings();
        col.add(index, gd);
    }

    @Override
    protected void setLeftRotation() {
        super.setLeftRotation();
    }

    @Override
    protected void setRightRotation() {
        super.setRightRotation();
    }

    protected void addCommand(GeometraDrawing gd, BlueprintSubject.Action action) {
        if (!(gd instanceof ZoomDrawing)) {
            GeometraPaintCommand command = new GeometraPaintCommand(gd, action);
            this.manager.execute(command);
        }
    }

    @Override
    public void addDrawing(Object object) {
        if (object instanceof SmartDrawing) {
            SmartDrawing sd = (SmartDrawing)object;
            super.addSmartDrawing(sd);
        }
        if (object instanceof GeometraDrawing && !(object instanceof HoleDrawing)) {
            GeometraDrawing gd = (GeometraDrawing)object;
            super.addDrawing((Object)gd);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection geoVector = (GeometraCollection)object;
            super.addDrawing((Object)geoVector);
        }
    }

    @Override
    public void removeDrawing(Object object) {
        if (object instanceof SmartDrawing) {
            SmartDrawing sd = (SmartDrawing)object;
            this.drawings.remove(sd);
        } else if (object instanceof DotDrawing) {
            this.removeDotDrawing((DotDrawing)object);
        } else if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.removeDrawing(gd);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection temp = (GeometraCollection)object;
            GeometraCollection<GeometraDrawing> geoVector = new GeometraCollection<GeometraDrawing>();
            for (Object obj : temp) {
                geoVector.add((GeometraDrawing)obj);
            }
            this.removeDrawing(geoVector);
        }
    }

    private void removeDrawing(GeometraCollection<GeometraDrawing> col) {
        for (GeometraDrawing gd : col) {
            if (gd instanceof DotDrawing) {
                this.removeDotDrawing((DotDrawing)gd);
                continue;
            }
            this.removeDrawing(gd);
        }
    }

    private void removeDotDrawing(DotDrawing gd) {
        DotDrawingContainer ddc = gd.getOwner();
        ddc.removeChild(gd);
        this.activeDrawings.remove(gd);
    }

    public void removeDrawingTemporary(GeometraDrawing gd) {
        this.drawings.remove(gd);
        this.activeDrawings.remove(gd);
    }

    private void removeDrawing(GeometraDrawing gd) {
        if (gd instanceof HoleDrawing) {
            HoleDrawing hd = (HoleDrawing)gd;
            SquareDrawing sd = hd.getOwner();
            sd.removeChild(hd);
            this.drawings.remove(hd);
            this.activeDrawings.remove(hd);
        } else {
            this.drawings.remove(gd);
            this.activeDrawings.remove(gd);
            GeometraCollection<SmartDrawing> toBeRemoved = new GeometraCollection<SmartDrawing>();
            for (GeometraDrawing sd : this.drawings) {
                SmartDrawing smart;
                if (!(sd instanceof SmartDrawing) || !(smart = (SmartDrawing)sd).contains(gd)) continue;
                smart.removeDrawing(gd);
                if (smart.getChildCount() != 0) continue;
                toBeRemoved.add(smart);
            }
        }
    }

    @Override
    public GeometraCollection<GeometraDrawing> getDrawings() {
        return super.getDrawings();
    }

    @Override
    public ScaleDrawing getScaleDrawing() {
        return super.getScaleDrawing();
    }

    @Override
    protected void init() {
        this.manager = new UndoRedoManager();
        super.init();
    }

    @Override
    protected void setParent(Blueprint bp) {
        super.setParent(bp);
    }

    @Override
    public void setDescription(String desc) {
        super.setDescription(desc);
    }

    @Override
    public GeometraDrawing getDrawing(Point2D screenCoord) {
        Point2D coord = screenCoord;
        GeometraDrawing minDrawing = null;
        double minArea = Double.MAX_VALUE;
        ArrayList<GeometraDrawing> geoVec = new ArrayList<GeometraDrawing>();
        for (GeometraDrawing d : this.getDrawings()) {
            if (d instanceof LineDrawing) {
                LineDrawing ld = (LineDrawing)d;
                if (ld.getLine(screenCoord) == null) continue;
                geoVec.add(ld);
                continue;
            }
            if (!(d instanceof DotDrawingContainer) && d.contains(coord) && d.isClosed()) {
                geoVec.add(d);
                continue;
            }
            if (d instanceof DotDrawingContainer || d.isClosed() || !d.boundsContains(coord) && !d.isCloseTo(this.componentToBlueprint(coord))) continue;
            geoVec.add(d);
        }
        ScaleDrawing scaleDrawing_ = this.getScaleDrawing();
        if (scaleDrawing_.getLine(screenCoord) != null) {
            return scaleDrawing_;
        }
        if (geoVec.isEmpty()) {
            return null;
        }
        for (int i = 0; i < geoVec.size(); ++i) {
            GeometraDrawing gd = (GeometraDrawing)geoVec.get(i);
            if (!gd.isClosed()) {
                minDrawing = gd;
                break;
            }
            if (gd instanceof LineDrawing) {
                minDrawing = gd;
                break;
            }
            if (!(gd.getArea() < minArea)) continue;
            minArea = gd.getArea();
            minDrawing = gd;
        }
        if (minDrawing != null) {
            return minDrawing;
        }
        for (GeometraDrawing d : this.getDrawings()) {
            if (d.getLine(screenCoord) == null) continue;
            return d;
        }
        return null;
    }

    @Override
    public void setActiveDrawing(Object ob) {
        if (ob instanceof SmartDrawing) {
            this.setDrawingState(BlueprintPage.DrawingState.SMART);
        } else {
            this.setDrawingState(BlueprintPage.DrawingState.NORMAL);
        }
        super.setActiveDrawing(ob);
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public GeometraDrawing getDrawing(int index) {
        return super.getDrawing(index);
    }

    public void moveScaleDrawing(Point2D point) {
        for (GeometraDrawing gd : this.getDrawings()) {
            if (!(gd instanceof ScaleDrawing)) continue;
            ScaleDrawing sd = (ScaleDrawing)gd;
            sd.moveScaleDrawing(this.componentToBlueprint(point));
            this.geoSubject.update((GeometraDrawing)null, (Object)this);
            return;
        }
    }

    public void setPageDimension(PDimension pageDimension) {
        Dimension d = pageDimension.toDimension();
        super.setPageDimension(d);
    }

    @Override
    public Dimension getPageDimension() {
        Dimension d = super.getPageDimension();
        if (d == null) {
            System.err.println("DIMENSION IS NULL!");
        }
        return d;
    }
}

