/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.nfont.b.d;
import org.icepdf.core.pobjects.fonts.nfont.b.f;
import org.icepdf.core.pobjects.fonts.nfont.c.a;
import org.icepdf.core.pobjects.fonts.nfont.c.e;
import org.icepdf.core.pobjects.fonts.nfont.k;
import org.icepdf.core.pobjects.fonts.nfont.m;

public abstract class j
extends k {
    private static final Logger logger = Logger.getLogger(j.class.toString());
    public static final int TAG_TTCF = e.a("ttcf");
    public static final String FORMAT = "sfnt";
    private static final byte[] TABLE_EMPTY = new byte[0];
    d ra_;
    int version_;
    long raoff_;
    private m[] tabledir_;
    byte[] data_;
    private ThreadLocal offset_ = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public j(URL uRL) {
        super(uRL);
        try {
            this.getRA();
            this.ra_.seek(0L);
            this.parseFile();
            this.parse();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.releaseRA();
        }
    }

    public j(byte[] byArray) {
        super(null);
        this.ra_ = new f(byArray, "r");
        this.parseFile();
        this.parse();
    }

    protected void parseFile() {
        this.data_ = this.readRaw(this.raoff_, 12);
        this.offset_.set(0);
        this.version_ = this.readUint32();
    }

    protected void parse() {
        this.data_ = this.readRaw(this.raoff_, 12);
        this.offset_.set(4);
        int n2 = this.readUint16();
        if (n2 < 1) {
            throw new IllegalStateException(n2 + "");
        }
        this.data_ = this.readRaw(this.raoff_ + 12L, n2 * 4 * 4);
        this.offset_.set(0);
        this.tabledir_ = new m[n2];
        if (n2 < 0 && n2 >= 1000) {
            throw new IllegalStateException(n2 + "");
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.readUint32();
            int n5 = this.readUint32();
            int n6 = this.readUint32();
            int n7 = this.readUint32();
            if (n7 <= 0) continue;
            this.tabledir_[n3++] = new m(n4, n5, n6, n7);
        }
        this.tabledir_ = (m[])a.a((Object[])this.tabledir_, n3);
    }

    void getRA() {
        if (this.ra_ == null) {
            if (this.getSource() == null) {
                throw new IllegalStateException();
            }
            this.ra_ = j.getMultiplex().a(this, this.getSource());
        }
    }

    void releaseRA() {
        if (this.ra_ != null && !(this.ra_ instanceof f)) {
            j.getMultiplex().a(this.ra_);
            this.ra_ = null;
        }
    }

    public m[] getTables() {
        return (m[])this.tabledir_.clone();
    }

    public m getTableDirectory(String string) {
        return this.getTableDirectory(e.a(string));
    }

    public m getTableDirectory(int n2) {
        int n3 = this.tabledir_.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != this.tabledir_[i2].a) continue;
            return this.tabledir_[i2];
        }
        return null;
    }

    public byte[] getTable(int n2) {
        return this.getTable(n2, 0, Integer.MAX_VALUE);
    }

    public byte[] getTable(String string) {
        return this.getTable(e.a(string));
    }

    public byte[] getTable(int n2, int n3, int n4) {
        return this.getTable(this.getTableDirectory(n2), n3, n4);
    }

    public byte[] getTable(String string, int n2, int n3) {
        return this.getTable(e.a(string), n2, n3);
    }

    public byte[] getTable(m m2, int n2, int n3) {
        byte[] byArray = TABLE_EMPTY;
        if (m2 != null) {
            if (m2.a != null) {
                byArray = m2.a;
            } else {
                try {
                    boolean bl2 = this.ra_ == null;
                    this.getRA();
                    byArray = this.readRaw((TAG_TTCF == this.version_ ? 0L : this.raoff_) + (long)m2.c + (long)n2, Math.min(m2.d, n3));
                    if (bl2) {
                        this.releaseRA();
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.data_ = byArray;
        this.offset_.set(0);
        return this.data_;
    }

    byte[] readRaw(long l2, int n2) {
        if (this.ra_ == null) {
            throw new IllegalStateException();
        }
        if (n2 <= 0) {
            return TABLE_EMPTY;
        }
        byte[] byArray = new byte[n2];
        this.ra_.seek(l2);
        this.ra_.readFully(byArray);
        return byArray;
    }

    public int getTableSize(int n2) {
        m m2 = this.getTableDirectory(n2);
        return m2 != null ? m2.d : -1;
    }

    public int getTableSize(String string) {
        return this.getTableSize(e.a(string));
    }

    public void setTable(int n2, byte[] byArray) {
        m m2 = this.getTableDirectory(n2);
        if (m2 == null) {
            this.tabledir_ = (m[])a.a((Object[])this.tabledir_, this.tabledir_.length + 1);
            this.tabledir_[this.tabledir_.length - 1] = new m(n2, byArray);
        } else {
            m2.a(byArray);
        }
    }

    public void deleteTable(int n2) {
        m m2 = this.getTableDirectory(n2);
        if (m2 != null) {
            m m3 = this.tabledir_[this.tabledir_.length - 1];
            if (m2 != m3) {
                this.tabledir_[a.a((Object[])this.tabledir_, (Object)m2)] = m3;
            }
            this.tabledir_ = (m[])a.a((Object[])this.tabledir_, this.tabledir_.length - 1);
        }
    }

    public static int checksum(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = byArray.length;
        while (n4 + 4 < n5) {
            n2 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
            n3 += n2;
            n4 += 4;
        }
        if (n4 < n5) {
            n2 = 0;
            int n6 = 0;
            while (n4 < n5) {
                n6 = n6 << 8 | byArray[n4] & 0xFF;
                ++n4;
                ++n2;
            }
            while (n2 < 4) {
                n6 <<= 8;
                ++n2;
            }
            n3 += n6;
        }
        return n3;
    }

    public int readUint8() {
        int n2 = this.data_[(Integer)this.offset_.get()] & 0xFF;
        this.skip(1);
        return n2;
    }

    public int readInt8() {
        byte by2 = this.data_[(Integer)this.offset_.get()];
        this.skip(1);
        return by2;
    }

    public int readUint16() {
        int n2 = (this.data_[(Integer)this.offset_.get()] & 0xFF) << 8 | this.data_[(Integer)this.offset_.get() + 1] & 0xFF;
        this.skip(2);
        return n2;
    }

    public int readInt16() {
        int n2 = this.data_[(Integer)this.offset_.get()] << 8 | this.data_[(Integer)this.offset_.get() + 1] & 0xFF;
        this.skip(2);
        return n2;
    }

    public int readUint32() {
        int n2 = (this.data_[(Integer)this.offset_.get()] & 0xFF) << 24 | (this.data_[(Integer)this.offset_.get() + 1] & 0xFF) << 16 | (this.data_[(Integer)this.offset_.get() + 2] & 0xFF) << 8 | this.data_[(Integer)this.offset_.get() + 3] & 0xFF;
        this.skip(4);
        return n2;
    }

    public int readInt32() {
        int n2 = this.data_[(Integer)this.offset_.get()] << 24 | (this.data_[(Integer)this.offset_.get() + 1] & 0xFF) << 16 | (this.data_[(Integer)this.offset_.get() + 2] & 0xFF) << 8 | this.data_[(Integer)this.offset_.get() + 3] & 0xFF;
        this.skip(4);
        return n2;
    }

    public float readFixed() {
        int n2 = this.readInt16();
        float f2 = (float)this.readUint16() / 65536.0f;
        return (float)n2 + (n2 >= 0 ? f2 : -f2);
    }

    public float readF2Dot14() {
        int n2 = this.readInt16();
        return (float)(n2 >> 14) + (float)(n2 & 0x3FFF) / 16384.0f;
    }

    public long readDateTime() {
        long l2 = this.readUint32() << 32 | this.readUint32();
        return l2;
    }

    public String readStringPascal() {
        if ((Integer)this.offset_.get() < this.data_.length) {
            int n2 = this.readUint8();
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = this.data_.length - 1;
            for (int i2 = 0; i2 < n2 && (Integer)this.offset_.get() < n3; ++i2) {
                stringBuilder.append((char)(this.data_[(Integer)this.offset_.get()] & 0xFF));
                this.skip(1);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    String readString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 + n3 > this.data_.length) {
            n3 = this.data_.length - n2;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append((char)(this.data_[i2 + n2] & 0xFF));
        }
        return stringBuilder.toString();
    }

    String readString16(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3 / 2);
        for (int i2 = 0; i2 < n3; i2 += 2) {
            stringBuilder.append((char)((this.data_[i2 + n2] & 0xFF) << 8 | this.data_[i2 + n2 + 1] & 0xFF));
        }
        return stringBuilder.toString();
    }

    public int getOffset() {
        return (Integer)this.offset_.get();
    }

    public void setOffset(int n2) {
        this.offset_.set(n2);
    }

    public void skip(int n2) {
        this.offset_.set((Integer)this.offset_.get() + n2);
    }
}

