/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;
import se.sjobeck.util.StaticHelpers;

public class StatistikPanel
extends JPanel {
    private StatistikTabell statistikModell;
    private JTable statistikTabell;

    public StatistikPanel(ProjectManager manager) {
        this.initComponents();
        this.add((Component)this.statistikTabell.getTableHeader(), "North");
        this.statistikModell = new StatistikTabell(manager);
        this.statistikTabell.setModel(this.statistikModell);
        TextAreaRenderer rend = new TextAreaRenderer(1);
        this.statistikTabell.getColumnModel().getColumn(0).setCellRenderer(rend);
        this.statistikTabell.getColumnModel().getColumn(1).setCellRenderer(rend);
        this.statistikTabell.getColumnModel().getColumn(2).setCellRenderer(rend);
    }

    public void updateStatistics() {
        this.statistikModell.updateStatistics();
    }

    public void setCurrentNode(KalkylNod nod) {
        this.statistikModell.setCurrentNode(nod);
    }

    private void initComponents() {
        this.statistikTabell = new JTable();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Nyckeltal"));
        this.statistikTabell.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.statistikTabell.setIntercellSpacing(new Dimension(0, 1));
        this.add((Component)this.statistikTabell, "Center");
    }

    private class StatistikTabell
    extends AbstractTableModel {
        double totalKost;
        double totaltid;
        double fordelning;
        KalkylNod currentNode;
        ProjectManager projectManager;

        StatistikTabell(ProjectManager manager) {
            this.projectManager = manager;
        }

        public void setCurrentNode(KalkylNod nod) {
            this.currentNode = nod;
            this.updateStatistics();
        }

        public void updateStatistics() {
            if (this.currentNode == null) {
                return;
            }
            try {
                this.fordelning = this.currentNode.golvYta();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fordelning = 1.0;
            }
            this.totaltid = 0.0;
            this.totalKost = 0.0;
            for (RadStruct b : this.currentNode.getRader()) {
                this.totalKost += this.projectManager.getCurrentProject().getRadHanterare().getPrisPerEnh(b) * b.getAntalEnh();
                this.totaltid += this.projectManager.getCurrentProject().getRadHanterare().getTidPerEnh(b) * b.getAntalEnh();
            }
            super.fireTableRowsUpdated(0, 3);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "F\u00f6rdelningsfaktor:";
                }
                case 1: {
                    return "Belopp";
                }
                case 2: {
                    return "Tid";
                }
            }
            return "Error";
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return StaticHelpers.format2Dec(this.fordelning) + " m\u00b2";
                }
                case 1: {
                    return StaticHelpers.format2Dec(this.totalKost / this.fordelning);
                }
                case 2: {
                    return StaticHelpers.tidFormat(this.totaltid / this.fordelning);
                }
            }
            return "Error";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            throw new IllegalArgumentException("You should not edit this");
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return 1;
        }
    }
}

