/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Remark;
import se.sjobeck.gui.KalkylGUI;

public class RemarksTable
extends JPanel {
    private List<Remark> remarkList = Collections.EMPTY_LIST;
    private final AbstractTableModel remarkTableModel = new AbstractTableModel(){

        @Override
        public int getRowCount() {
            return RemarksTable.this.remarkList.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Anm\u00e4rkning";
                }
                case 1: {
                    return "Plats";
                }
                case 2: {
                    return "\u00c5tg\u00e4rd";
                }
            }
            return "<Fel>";
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Remark r = (Remark)RemarksTable.this.remarkList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return r.getRemark();
                }
                case 1: {
                    return r.getLocation();
                }
            }
            return "<inte implementerat \u00e4n>";
        }
    };
    private KalkylGUI gui;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public RemarksTable(KalkylGUI gui) {
        assert (gui != null);
        this.initComponents();
        this.jTable1.setModel(this.remarkTableModel);
        this.gui = gui;
    }

    public void setRemarks(List<Remark> newRemarkList) {
        this.remarkList = newRemarkList;
        this.remarkTableModel.fireTableDataChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RemarksTable.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            KalkylNod jumpTo = this.remarkList.get(this.jTable1.getSelectedRow()).getLocation();
            this.gui.getCurrentNodeTree().setSelectionPath(new TreePath(jumpTo.getPath()));
        }
    }
}

