/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.drawings;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.datastructures.drawings.EkalkylSquareDrawing;
import se.sjobeck.datastructures.drawings.PDFViewContainerTracker;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.PDFLoader;
import se.sjobeck.geometra.datastructures.core.BlueprintImpl;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.gui.DrawingPanel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.pdf.file_network_tracking.EkalkylPDFConfiguration;
import se.sjobeck.util.pdf.file_network_tracking.PDFTracker;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListener;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListenerEvent;

public class FromGeometraDrawing
extends Drawing
implements PDFTrackerListener {
    private final Drawing myDrawing;
    private final GeometraDrawingImpl gdi;
    private String projectName;
    private String pdfName;
    private int page_number;
    private transient Container viewContainer = null;
    private transient PDFController pDFController = null;
    private transient DrawingPanel dp = null;
    private float my_zoom = 1600.0f / jsliderfactor;
    private static transient float jsliderfactor = 1600.0f;
    final Object protectDIP = new Object();
    transient boolean downloadingInProgress = false;
    private transient boolean filedownloaded = false;
    private final Object ftnsfos = new Object();
    private transient boolean firstTimeNoSushFileOnServer = true;

    String getProjectName() {
        return this.projectName;
    }

    String getPdfName() {
        return this.pdfName;
    }

    private FromGeometraDrawing(FromGeometraDrawing fgd) throws CloneNotSupportedException {
        this.myDrawing = fgd.myDrawing.copy();
        this.gdi = (EkalkylSquareDrawing)fgd.gdi.clone();
        this.my_zoom = new Float(fgd.my_zoom).floatValue();
        this.page_number = new Integer(fgd.page_number);
        this.pdfName = new String(fgd.pdfName);
        this.projectName = new String(fgd.projectName);
    }

    public FromGeometraDrawing() {
        this.myDrawing = null;
        this.gdi = null;
    }

    public FromGeometraDrawing(Drawing drawing, SquareDrawing sqd, String projectName) {
        this.myDrawing = drawing.copy();
        BlueprintImpl bpi = (BlueprintImpl)sqd.getParent().getParent();
        this.importPDFfileToProject(bpi.getFilePath(), projectName);
        this.projectName = projectName;
        this.page_number = sqd.getParent().getParent().indexOf(sqd.getParent());
        this.gdi = new EkalkylSquareDrawing(sqd);
        this.gdi.setThreeDimensionsVisible(false);
        this.gdi.setTwoDimensionsVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Container getViewContainer_old(Dimension dim) {
        if (this.viewContainer != null) {
            this.pDFController.setZoom(this.my_zoom);
            this.pDFController.centerViewport(this.gdi);
            return this.viewContainer;
        }
        if (this.viewContainer == null) {
            String filepath = this.getPDFFilePath();
            File pdfFile = new File(filepath);
            Object object = this.protectDIP;
            synchronized (object) {
                if (pdfFile.exists() && !this.downloadingInProgress) {
                    IcePDFBlueprint loadPDF = PDFLoader.loadPDF(pdfFile);
                    this.pDFController = loadPDF.getPDFController();
                    this.pDFController.removeAllListeners();
                    this.viewContainer = this.pDFController.getViewContainer();
                    this.gdi.init();
                    loadPDF.getPage(this.page_number).addDrawing(this.gdi);
                    this.gdi.setParent(loadPDF.getPage(this.page_number));
                    this.viewContainer.setSize(dim);
                    this.pDFController.setZoom(this.my_zoom);
                    this.pDFController.centerViewport(this.gdi);
                    return this.viewContainer;
                }
                PDFTracker pdftracker = PDFTracker.getPDFTracker();
                this.setDIP_if_DIP_not_true(true);
                pdftracker.tryDownloadPDF(this.pdfName, this.projectName, this);
            }
        }
        if (this.dp != null) {
            this.dp.setSize(dim);
            return this.dp;
        }
        this.dp = new DrawingPanel();
        this.dp.setDrawing(this);
        this.dp.setSize(dim);
        return this.dp;
    }

    public synchronized Container getViewContainer(Dimension dim) {
        PDFViewContainerTracker vcti = PDFViewContainerTracker.getPDFViewContainerTrackerInstance();
        IcePDFBlueprint lipb = vcti.loadIcePdfblueprint(this);
        if (lipb != null) {
            if (this.pDFController != null) {
                this.pDFController = null;
            }
            this.pDFController = lipb.getPDFController();
            this.viewContainer = this.pDFController.getViewContainer();
            this.gdi.init();
            this.gdi.setVisible(true);
            GeometraCollection<GeometraDrawing> drawings = lipb.getPage(0).getDrawings();
            for (int i = 0; i < drawings.size(); ++i) {
                lipb.getPage(0).removeDrawing((Object)drawings.get(i));
            }
            lipb.getPage(0).addDrawing(this.gdi);
            this.gdi.setParent(lipb.getPage(0));
            this.pDFController.setPageNumber(this.page_number);
            this.pDFController.removeAllListeners();
            this.viewContainer.setSize(dim);
            this.pDFController.setZoom(this.my_zoom);
            this.pDFController.centerViewport(this.gdi);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FromGeometraDrawing.this.viewContainer.repaint();
                }
            });
            return this.viewContainer;
        }
        if (this.dp != null) {
            this.dp.setSize(dim);
            return this.dp;
        }
        this.dp = new DrawingPanel();
        this.dp.setDrawing(this);
        this.dp.setSize(dim);
        return this.dp;
    }

    private void importPDFfileToProject(String filePath, String projectName) {
        PDFTracker pdftracker = PDFTracker.getPDFTracker();
        File importPDFToProject = pdftracker.importPDFToProject(filePath, projectName);
        this.pdfName = importPDFToProject.getName();
    }

    public void useZoom(int value) {
        float zoom = jsliderfactor / ((float)value * 1.0f);
        if (this.pDFController != null) {
            this.pDFController.setZoom(zoom);
        }
    }

    public void setZoom(int zoom) {
        this.my_zoom = jsliderfactor / ((float)zoom * 1.0f);
        if (this.pDFController != null) {
            this.pDFController.setZoom(this.my_zoom);
        }
    }

    public void centerViewport() {
        if (this.pDFController != null) {
            this.pDFController.centerViewport(this.gdi);
        }
    }

    public int getZoom() {
        return (int)(jsliderfactor / this.my_zoom);
    }

    @Override
    public Vector<Function> getVariables() {
        return this.myDrawing.getVariables();
    }

    @Override
    public Drawing copy() {
        if (this.gdi instanceof EkalkylSquareDrawing) {
            try {
                return new FromGeometraDrawing(this);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(FromGeometraDrawing.class.getName()).log(Level.SEVERE, null, ex);
                System.out.println(ex);
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void paintDrawing(Graphics2D g2d, Rectangle constraints) {
        this.myDrawing.paintDrawing(g2d, constraints);
    }

    @Override
    public String getDescription() {
        return this.myDrawing.getDescription();
    }

    @Override
    public DrawingLine getLine(Point2D p) {
        return this.myDrawing.getLine(p);
    }

    String getPDFFilePath() {
        return EkalkylPDFConfiguration.getSavePath() + File.separator + this.projectName + File.separator + this.pdfName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileDownloaded(PDFTrackerListenerEvent event) {
        Object object = this.protectDIP;
        synchronized (object) {
            this.setDIP_if_DIP_not_true(false);
            this.filedownloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDIP_if_DIP_not_true(boolean value) {
        Object object = this.protectDIP;
        synchronized (object) {
            this.downloadingInProgress = this.filedownloaded ? false : value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noSuchFileOnServer(PDFTrackerListenerEvent event) {
        Object object = this.ftnsfos;
        synchronized (object) {
            if (this.firstTimeNoSushFileOnServer) {
                Vector<String> fudo = new Vector<String>();
                fudo.add("PDF-filter");
                fudo.add("pdf");
                File showFileChooser = DialogCreator.showFileChooser("V\u00e4lj pdf till m\u00e4tning", fudo);
                if (showFileChooser != null) {
                    try {
                        this.importPDFfileToProject(showFileChooser.getCanonicalPath(), this.projectName);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FromGeometraDrawing.class.getName()).log(Level.SEVERE, null, ex);
                        DialogCreator.showError("Det blev fel n\u00e4r du f\u00f6rs\u00f6kte v\u00e4lja en pdf", "Error");
                    }
                }
                this.firstTimeNoSushFileOnServer = false;
            }
        }
    }

    @Override
    public void wEEEEESomethingHappenedWithTheFileImInterestedIn(PDFTrackerListenerEvent event) {
        if (event.getState() == PDFTrackerListenerEvent.State.NO_SUCH_FILE_ON_SERVER) {
            this.noSuchFileOnServer(event);
        }
        if (event.getState() == PDFTrackerListenerEvent.State.FILE_DOWNLOADED) {
            this.fileDownloaded(event);
        }
    }

    public void dispose() {
        if (this.pDFController != null) {
            this.pDFController.dispose();
            this.pDFController = null;
        }
        if (this.viewContainer != null) {
            this.viewContainer = null;
        }
    }
}

