/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.parser2.Function;

public class GrenNod
extends KalkylNod {
    public static final long serialVersionUID = 3268206324152599913L;
    private String statistikFormel;
    private transient boolean structureValid;
    private transient Vector<RadStruct> cachedRows;

    private Object readResolve() {
        this.cachedRows = new Vector();
        this.structureValid = false;
        return this;
    }

    public GrenNod() {
        this.beskrivning = "Ny gren";
        this.antalFormel = "1";
        this.allowsChildren = true;
        this.statistikFormel = "1";
        this.readResolve();
    }

    public GrenNod(GrenNod old) {
        this.beskrivning = old.beskrivning;
        this.antalFormel = old.antalFormel;
        Enumeration<TreeNode> e = old.children();
        while (e.hasMoreElements()) {
            this.add(((KalkylNod)e.nextElement()).copy());
        }
        this.statistikFormel = old.statistikFormel;
        this.readResolve();
    }

    public String getStatistikFormel() {
        return this.statistikFormel;
    }

    public void setStatistikFormel(String s) {
        this.statistikFormel = s;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean deletable() {
        return true;
    }

    public Vector<RadStruct> getRader() {
        if (!this.structureValid) {
            this.cachedRows.clear();
            for (int i = 0; i < this.getChildCount(); ++i) {
                KalkylNod n = (KalkylNod)this.getChildAt(i);
                for (RadStruct original : n.getRader()) {
                    try {
                        int index = -1;
                        index = this.cachedRows.indexOf(original);
                        if (index >= 0) {
                            this.cachedRows.get(index).setAntalEnh(this.cachedRows.get(index).getAntalEnh() + original.getAntalEnh() * n.getAntal());
                            continue;
                        }
                        RadStruct b = (RadStruct)original.clone();
                        b.setAntalEnh(b.getAntalEnh() * n.getAntal());
                        this.cachedRows.add(b);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.structureValid = true;
        }
        return this.cachedRows;
    }

    @Override
    public List<RadStruct> getPrintableRader() {
        Vector<RadStruct> lrs = new Vector<RadStruct>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            KalkylNod n = (KalkylNod)this.getChildAt(i);
            if (!n.okToPrint) continue;
            for (RadStruct rs : n.getPrintableRader()) {
                try {
                    int index = -1;
                    index = lrs.indexOf(rs);
                    if (index >= 0) {
                        ((RadStruct)lrs.get(index)).setAntalEnh(((RadStruct)lrs.get(index)).getAntalEnh() + rs.getAntalEnh() * n.getAntal());
                        continue;
                    }
                    RadStruct b = (RadStruct)rs.clone();
                    b.setAntalEnh(b.getAntalEnh() * n.getAntal());
                    lrs.add(b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return lrs;
    }

    @Override
    public void update(KalkylNod nod) {
        this.invalidate();
        super.update(nod);
    }

    public void invalidate() {
        if (this.structureValid) {
            this.structureValid = false;
            if (this.parent != null) {
                ((GrenNod)this.parent).invalidate();
            }
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public double golvYta() {
        double ret = 0.0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            KalkylNod n = (KalkylNod)this.getChildAt(i);
            ret += n.golvYta() * n.getAntal();
        }
        return ret;
    }

    @Override
    public double getAntal() {
        return Function.getValue(this.antalFormel, this.getKonstanter());
    }

    @Override
    public KalkylNod copy() {
        return new GrenNod(this);
    }
}

