/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.versiontracker;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sjobeck.versiontracker.VersionTracker;

public class VersionTrackerFactory {
    private static transient Map<String, VersionTracker> map = new HashMap<String, VersionTracker>();
    public static final transient String VERSIONTRACKER_FILENAME = ".versiontracker";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveVersionTracker(String project_path, VersionTracker vt) {
        if (vt == null) {
            vt = new VersionTracker();
        }
        map.put(project_path, vt);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            File f = new File(project_path + File.separator + VERSIONTRACKER_FILENAME);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(vt);
        }
        catch (IOException ex) {
            Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static VersionTracker loadVersionTracker(String project_path) {
        VersionTracker vt = map.get(project_path);
        if (vt == null) {
            vt = VersionTrackerFactory.loadvt(project_path);
        } else if (vt.needReload()) {
            vt = VersionTrackerFactory.loadvt(project_path);
        }
        return vt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized VersionTracker loadvt(String path) {
        String project_path = path + File.separator + VERSIONTRACKER_FILENAME;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        VersionTracker vt = null;
        try {
            Object readObject;
            File versiontracker = new File(project_path);
            if (versiontracker.exists() && (readObject = (ois = new ObjectInputStream(fis = new FileInputStream(versiontracker))).readObject()) instanceof VersionTracker) {
                vt = (VersionTracker)readObject;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (EOFException ex) {
            Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(VersionTracker.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (vt == null) {
                vt = new VersionTracker();
            }
        }
        map.put(path, vt);
        return vt;
    }
}

