/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.parser2;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import se.sjobeck.parser2.OperationFactory;

public class Function
implements Serializable {
    public static final long serialVersionUID = 0L;
    protected static final List<Function> noVariables = Collections.emptyList();
    private String identifier;
    private String value;
    private String description;
    private transient boolean visited;
    private boolean preDefined;

    public Function() {
        this(null, null, null);
    }

    public Function(String id, String val, String desc) {
        this(id, val, desc, false);
    }

    public Function(String id, String val, String desc, boolean preDef) {
        this.identifier = id;
        this.value = val;
        this.visited = false;
        this.description = desc;
        this.preDefined = preDef;
    }

    public boolean isPredefined() {
        return this.preDefined;
    }

    public void setPredefined(boolean newValue) {
        this.preDefined = newValue;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getValueStr() {
        return this.value;
    }

    public void setValueStr(String s) {
        this.value = s;
    }

    public String getDescription() {
        return this.description;
    }

    public double getValue(List<Function> ... variables) throws IllegalArgumentException {
        if (this.visited) {
            this.visited = false;
            throw new IllegalArgumentException("Variable '" + this.identifier + "' refers to self!");
        }
        this.visited = true;
        double d = Function.getValue(this.value, variables);
        this.visited = false;
        return d;
    }

    public static double getValue(String s) {
        return Function.getValue(s, noVariables);
    }

    public static double getValue(String s, List<Function> ... vars) {
        try {
            s = s.replaceAll("\\s", "");
            s = s.replace(',', '.');
            s = s.replaceAll("%", "/100");
            if (s.equals("")) {
                return Double.NaN;
            }
            return OperationFactory.parse(s, vars).valueOf();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

