/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.dndtree;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.sjobeck.gui.dndtree.DNDTree;
import se.sjobeck.gui.dndtree.TransferableNode;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DNDTree tree;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static DefaultMutableTreeNode draggedNode;
    private DefaultMutableTreeNode draggedNodeParent;
    private static JLabel draggedLabel;
    private static JLayeredPane dragPane;
    private boolean drawImage;

    protected AbstractTreeTransferHandler(DNDTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
        this.dropTarget = new DropTarget(tree, action, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (this.drawImage) {
            dragPane.remove(draggedLabel);
            dragPane.repaint(draggedLabel.getBounds());
        }
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeParent);
            this.tree.expandPath(new TreePath(this.draggedNodeParent.getPath()));
            this.tree.expandPath(new TreePath(draggedNode.getPath()));
        }
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            draggedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Vector<Boolean> expandedStates = new Vector<Boolean>();
            Enumeration<TreeNode> enumeration = draggedNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode element = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath treePath = new TreePath(element.getPath());
                expandedStates.add(new Boolean(this.tree.isExpanded(treePath)));
            }
            this.draggedNodeParent = (DefaultMutableTreeNode)draggedNode.getParent();
            BufferedImage image = null;
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
                draggedLabel = new JLabel(new ImageIcon(image));
                draggedLabel.setOpaque(false);
                draggedLabel.setBounds(pathBounds);
                Container container = this.tree.getTopLevelAncestor();
                if (container == null) {
                    this.drawImage = false;
                } else if (container instanceof JWindow) {
                    dragPane = ((JWindow)this.tree.getTopLevelAncestor()).getLayeredPane();
                    dragPane.add((Component)draggedLabel, JLayeredPane.DRAG_LAYER);
                } else if (container instanceof JFrame) {
                    dragPane = ((JFrame)this.tree.getTopLevelAncestor()).getLayeredPane();
                    dragPane.add((Component)draggedLabel, JLayeredPane.DRAG_LAYER);
                } else if (container instanceof JApplet) {
                    dragPane = ((JApplet)this.tree.getTopLevelAncestor()).getLayeredPane();
                    dragPane.add((Component)draggedLabel, JLayeredPane.DRAG_LAYER);
                } else {
                    this.drawImage = false;
                }
            }
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableNode(draggedNode, expandedStates), this);
        }
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt, ((DropTarget)dtde.getSource()).getComponent());
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dragExit(DropTargetEvent dte) {
    }

    @Override
    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.tree.autoscroll(pt);
        if (this.drawImage) {
            this.paintImage(pt, ((DropTarget)dtde.getSource()).getComponent());
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt, ((DropTarget)dtde.getSource()).getComponent());
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void drop(DropTargetDropEvent dtde) {
        try {
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            Point pt = dtde.getLocation();
            if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
                TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                DefaultMutableTreeNode newParentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
                Vector expandedStates = (Vector)transferable.getTransferData(TransferableNode.EXPANDED_STATE_FLAVOR);
                int index = -1;
                if (newParentNode.isLeaf() && !newParentNode.getAllowsChildren()) {
                    System.out.println("Should I be here?");
                    System.out.println(newParentNode);
                    DefaultMutableTreeNode tempNode = newParentNode;
                    newParentNode = (DefaultMutableTreeNode)tempNode.getParent();
                    index = newParentNode.getIndex(tempNode);
                    if (index == -1) {
                        dtde.rejectDrop();
                        return;
                    }
                } else {
                    index = newParentNode.getChildCount();
                }
                if (this.executeDrop(this.tree, node, newParentNode, index, expandedStates, action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
            }
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
    }

    private final synchronized void paintImage(Point pt, Component source) {
        pt = SwingUtilities.convertPoint(source, pt, dragPane);
        draggedLabel.setLocation(pt);
    }

    public abstract boolean canPerformAction(DNDTree var1, DefaultMutableTreeNode var2, int var3, Point var4);

    public abstract boolean executeDrop(DNDTree var1, DefaultMutableTreeNode var2, DefaultMutableTreeNode var3, int var4, Vector var5, int var6);
}

