/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;

public class GenericListModel<T>
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    protected List<T> data;

    public GenericListModel() {
        this(new ArrayList());
    }

    public GenericListModel(List<T> v) {
        this.data = v;
    }

    public List<T> getList() {
        return this.data;
    }

    @Override
    public T getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    public void addElement(T newElement) {
        this.data.add(newElement);
        super.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
    }

    public void addAll(Collection<T> extension) {
        this.data.addAll(extension);
        super.fireIntervalAdded(this, Math.min(this.data.size() - extension.size() - 1, 0), Math.min(this.data.size() - 1, 0));
    }

    public void setListData(Collection<T> newElements) {
        this.data.clear();
        this.data.addAll(newElements);
        super.fireContentsChanged(this, 0, this.data.size());
    }

    public void clear() {
        this.data.clear();
        super.fireContentsChanged(this, 0, 0);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int indexOf(T obj) {
        return this.data.indexOf(obj);
    }

    public boolean remove(T obj) {
        return this.remove(this.data.indexOf(obj));
    }

    public boolean remove(int index) {
        if (index != -1) {
            this.data.remove(index);
            super.fireIntervalRemoved(this, index, index);
            return true;
        }
        return false;
    }
}

