/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CheckBoxCellRenderer
implements TableCellRenderer,
TableCellEditor {
    private Color lightGray = new Color(250, 245, 245);
    private DefaultCellEditor editor;
    private JCheckBox checkbox = new JCheckBox();

    public CheckBoxCellRenderer() {
        this.checkbox.setHorizontalAlignment(0);
        this.checkbox.setVerticalAlignment(1);
        this.editor = new DefaultCellEditor(this.checkbox);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.checkbox.setForeground(table.getSelectionForeground());
            this.checkbox.setBackground(table.getSelectionBackground());
        } else {
            this.checkbox.setForeground(table.getForeground());
            if (row % 2 == 0) {
                this.checkbox.setBackground(table.getBackground());
            } else {
                this.checkbox.setBackground(this.lightGray);
            }
        }
        this.checkbox.setSelected((Boolean)value);
        return this.checkbox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component box = this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (!isSelected) {
            if (row % 2 == 0) {
                box.setBackground(table.getBackground());
            } else {
                box.setBackground(this.lightGray);
            }
        }
        ((AbstractButton)box).setHorizontalAlignment(0);
        ((AbstractButton)box).setVerticalAlignment(1);
        return box;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.editor.removeCellEditorListener(listener);
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.editor.addCellEditorListener(listener);
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public boolean shouldSelectCell(EventObject o) {
        return this.editor.shouldSelectCell(o);
    }

    @Override
    public boolean isCellEditable(EventObject o) {
        return this.editor.isCellEditable(o);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }
}

