/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import se.sjobeck.digitizer.DigitizerDriver;
import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.DigitizerEventListener;

public class TestDigitizer
extends JFrame
implements DigitizerEventListener {
    public static final long serialVersionUID = 0L;
    private Robot robot;
    private Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
    private double screenTop = -1.0;
    private double screenRight = -1.0;
    private double screenBottom = -1.0;
    private double screenLeft = -1.0;
    private int oldX = -1;
    private int oldY = -1;
    private boolean BUTTON_2_PRESSED;
    private boolean BUTTON_3_PRESSED;
    NumberFormat f = new DecimalFormat("###,##0.00");
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public TestDigitizer() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.setVisible(true);
        System.setOut(new PrintStream(new TextAreaOutputStream()));
    }

    @Override
    public void handleEvent(DigitizerEvent ev) {
        this.jCheckBox1.setSelected(ev.buttonIsSet(1));
        this.jCheckBox2.setSelected(ev.buttonIsSet(2));
        this.jCheckBox3.setSelected(ev.buttonIsSet(4));
        this.jCheckBox4.setSelected(ev.buttonIsSet(8));
        this.jCheckBox5.setSelected(ev.buttonIsSet(16));
        this.jLabel6.setText(this.f.format(ev.getPointInMillimeters().getX()));
        this.jLabel7.setText(this.f.format(ev.getPointInInches().getX()));
        this.jLabel8.setText(this.f.format(ev.getPointInMillimeters().getY()));
        this.jLabel9.setText(this.f.format(ev.getPointInInches().getY()));
        if (this.screenTop == -2.0) {
            this.screenTop = ev.getPointInMillimeters().getY();
            this.screenRight = ev.getPointInMillimeters().getX();
            System.out.println("screenTop: " + this.screenTop);
            System.out.println("screenRight: " + this.screenRight);
        }
        if (this.screenBottom == -2.0) {
            this.screenBottom = ev.getPointInMillimeters().getY();
            this.screenLeft = ev.getPointInMillimeters().getX();
            System.out.println("screenBottom: " + this.screenBottom);
            System.out.println("screenLeft: " + this.screenLeft);
        }
        if (ev.getPointInMillimeters().getX() >= this.screenLeft && ev.getPointInMillimeters().getX() <= this.screenRight && ev.getPointInMillimeters().getY() >= this.screenBottom && ev.getPointInMillimeters().getY() <= this.screenTop) {
            if (ev.buttonIsSet(1)) {
                int screenY = (int)(10.0 * (ev.getPointInMillimeters().getY() - this.screenBottom));
                int screenX = (int)(10.0 * (ev.getPointInMillimeters().getX() - this.screenLeft));
                if (this.oldX > -1 && this.oldY > -1) {
                    int dx = screenX - this.oldX;
                    int dy = screenY - this.oldY;
                    Point current = MouseInfo.getPointerInfo().getLocation();
                    this.robot.mouseMove(current.x + dx, current.y - dy);
                }
                this.oldX = screenX;
                this.oldY = screenY;
            } else {
                this.oldY = -1;
                this.oldX = -1;
            }
            if (ev.buttonIsSet(2) && !this.BUTTON_2_PRESSED) {
                this.robot.mousePress(16);
                this.BUTTON_2_PRESSED = true;
            } else if (!ev.buttonIsSet(2) && this.BUTTON_2_PRESSED) {
                this.robot.mouseRelease(16);
                this.BUTTON_2_PRESSED = false;
            }
            if (ev.buttonIsSet(4) && !this.BUTTON_3_PRESSED) {
                this.robot.mousePress(8);
                this.BUTTON_3_PRESSED = true;
            } else if (!ev.buttonIsSet(4) && this.BUTTON_3_PRESSED) {
                this.robot.mouseRelease(8);
                this.BUTTON_3_PRESSED = false;
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new GridLayout(4, 4));
        this.jPanel1.setBorder(new TitledBorder("Mark\u00f6rer"));
        this.jCheckBox1.setText("Knapp 1");
        this.jPanel1.add(this.jCheckBox1);
        this.jCheckBox2.setText("Knapp 2");
        this.jPanel1.add(this.jCheckBox2);
        this.jCheckBox3.setText("Knapp 3");
        this.jPanel1.add(this.jCheckBox3);
        this.jCheckBox4.setText("Knapp 4");
        this.jPanel1.add(this.jCheckBox4);
        this.jCheckBox5.setText("Knapp 5");
        this.jPanel1.add(this.jCheckBox5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(3, 3));
        this.jPanel2.setBorder(new TitledBorder("Koordinater"));
        this.jLabel5.setText(" ");
        this.jPanel2.add(this.jLabel5);
        this.jLabel3.setText("millimeter");
        this.jPanel2.add(this.jLabel3);
        this.jLabel4.setText("tum");
        this.jPanel2.add(this.jLabel4);
        this.jLabel1.setText("X:");
        this.jPanel2.add(this.jLabel1);
        this.jLabel6.setText(" ");
        this.jPanel2.add(this.jLabel6);
        this.jLabel7.setText(" ");
        this.jPanel2.add(this.jLabel7);
        this.jLabel2.setText("Y:");
        this.jPanel2.add(this.jLabel2);
        this.jLabel8.setText(" ");
        this.jPanel2.add(this.jLabel8);
        this.jLabel9.setText(" ");
        this.jPanel2.add(this.jLabel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane1.setBorder(new TitledBorder("Utdata"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jTextArea1.setPreferredSize(new Dimension(200, 300));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("\u00d6vre h\u00f6gra h\u00f6rn");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestDigitizer.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setText("Nedre v\u00e4nstra h\u00f6rn");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestDigitizer.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.screenBottom = -2.0;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.screenTop = -2.0;
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestDigitizer td = new TestDigitizer();
                td.setVisible(true);
                DigitizerDriver.addDigitizerEventListener(td);
            }
        });
    }

    private class TextAreaOutputStream
    extends OutputStream {
        private TextAreaOutputStream() {
        }

        @Override
        public void write(int b) {
            TestDigitizer.this.jTextArea1.append(Character.toString((char)b));
        }
    }
}

