/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.io.Serializable;
import java.util.Vector;
import se.sjobeck.datastructures.PopupValue;

public class TlgStruct
implements PopupValue,
Serializable {
    public static final long serialVersionUID = -610593994877231904L;
    private String ackpunkt;
    private String desc;
    private String avtalsText;
    private String kommentar;
    private double pris;
    private Vector<String> sieve;
    private boolean procent;
    private boolean utomhus;
    private boolean inomhus;

    public TlgStruct(String ackpunkt, String desc, String kommentar, String avtalsText, double pris, Vector<String> sieve, boolean procent, boolean inomhus, boolean utomhus) {
        this.ackpunkt = ackpunkt;
        this.desc = desc;
        this.pris = pris;
        this.sieve = sieve;
        this.procent = procent;
        this.inomhus = inomhus;
        this.utomhus = utomhus;
        this.kommentar = kommentar == null || kommentar.equals("") ? "Kommentar saknas." : kommentar;
        this.avtalsText = avtalsText == null || avtalsText.equals("") ? "Avtalstext saknas." : avtalsText;
    }

    public String toString() {
        return this.getAckpunkt() + " - " + this.getDesc();
    }

    public boolean equals(Object ob) {
        return ob instanceof TlgStruct && ((TlgStruct)ob).getAckpunkt().equals(this.getAckpunkt());
    }

    @Override
    public String getText() {
        return "Avtalstext:\n" + this.getAvtalsText() + "\n\nKommentar:\n" + this.getKommentar();
    }

    @Override
    public String getTitle() {
        return this.getAckpunkt();
    }

    public TlgStruct copy() {
        String _ackpunkt = null;
        if (this.getAckpunkt() != null) {
            _ackpunkt = new String(this.getAckpunkt());
        }
        String _avtalsText = null;
        if (this.getAvtalsText() != null) {
            _avtalsText = new String(this.getAvtalsText());
        }
        String _desc = null;
        if (this.getDesc() != null) {
            _desc = new String(this.getDesc());
        }
        boolean _inomhus = new Boolean(this.isInomhus());
        String _kommentar = null;
        if (this.getKommentar() != null) {
            _kommentar = new String(this.getKommentar());
        }
        double _pris = new Double(this.getPris());
        boolean _procent = new Boolean(this.isProcent());
        Vector<String> vs = new Vector<String>();
        for (String s : this.getSieve()) {
            String t = new String(s);
            vs.add(t);
        }
        boolean _utomhus = new Boolean(this.isUtomhus());
        TlgStruct ts = new TlgStruct(_ackpunkt, _desc, _kommentar, _avtalsText, _pris, vs, _procent, _inomhus, _utomhus);
        return ts;
    }

    public String getAckpunkt() {
        return this.ackpunkt;
    }

    public void setAckpunkt(String ackpunkt) {
        this.ackpunkt = ackpunkt;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAvtalsText() {
        return this.avtalsText;
    }

    public void setAvtalsText(String avtalsText) {
        this.avtalsText = avtalsText;
    }

    public String getKommentar() {
        return this.kommentar;
    }

    public void setKommentar(String kommentar) {
        this.kommentar = kommentar;
    }

    public double getPris() {
        return this.pris;
    }

    public void setPris(double pris) {
        this.pris = pris;
    }

    public Vector<String> getSieve() {
        return this.sieve;
    }

    public void setSieve(Vector<String> sieve) {
        this.sieve = sieve;
    }

    public boolean isProcent() {
        return this.procent;
    }

    public void setProcent(boolean procent) {
        this.procent = procent;
    }

    public boolean isUtomhus() {
        return this.utomhus;
    }

    public void setUtomhus(boolean utomhus) {
        this.utomhus = utomhus;
    }

    public boolean isInomhus() {
        return this.inomhus;
    }

    public void setInomhus(boolean inomhus) {
        this.inomhus = inomhus;
    }
}

