/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLAccess {
    public String urlLocation;
    public URL url;
    public InputStream inputStream;
    public String errorMessage;

    public static URLAccess doURLAccess(String urlLocation) {
        URLAccess res = new URLAccess();
        res.urlLocation = urlLocation;
        try {
            res.url = new URL(urlLocation);
            PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(res.url.openStream()), 1);
            int b = in.read();
            in.unread(b);
            res.inputStream = in;
        }
        catch (MalformedURLException e) {
            res.errorMessage = "Malformed URL";
        }
        catch (FileNotFoundException e) {
            res.errorMessage = "File Not Found";
        }
        catch (UnknownHostException e) {
            res.errorMessage = "Unknown Host";
        }
        catch (ConnectException e) {
            res.errorMessage = "Connection Timed Out";
        }
        catch (IOException e) {
            res.errorMessage = "IO exception";
        }
        return res;
    }

    private URLAccess() {
    }

    public void dispose() {
        this.urlLocation = null;
        this.url = null;
        this.errorMessage = null;
        this.closeConnection();
    }

    public void closeConnection() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inputStream = null;
        }
    }
}

