/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TextSpriteDrawCmd;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.FreeTextArea;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;

public class FreeTextAnnotationComponent
extends MarkupAnnotationComponent
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(FreeTextAnnotation.class.toString());
    private FreeTextArea freeTextPane;
    private boolean contentTextChange;
    private FreeTextAnnotation freeTextAnnotation;
    protected Font fontFile;

    public FreeTextAnnotationComponent(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, final DocumentViewModel documentViewModel) {
        super(annotation, documentViewController, pageViewComponent, documentViewModel);
        this.isRollover = false;
        this.isShowInvisibleBorder = false;
        this.freeTextAnnotation = (FreeTextAnnotation)annotation;
        if (annotation.getShapes() != null) {
            ArrayList<DrawCmd> shapes = annotation.getShapes().getShapes();
            for (int i = 0; i < shapes.size(); ++i) {
                DrawCmd cmd = shapes.get(i);
                if (!(cmd instanceof TextSpriteDrawCmd)) continue;
                TextSprite tmp = ((TextSpriteDrawCmd)cmd).getTextSprite();
                FontFile font = tmp.getFont();
                this.freeTextAnnotation.setFontSize((int)font.getSize());
                this.freeTextAnnotation.setFontColor(tmp.getStrokeColor());
                shapes.remove(i);
            }
            ((FreeTextAnnotation)annotation).clearShapes();
        }
        this.freeTextPane = new FreeTextArea(new FreeTextArea.ZoomProvider(){
            private DocumentViewModel model;
            {
                this.model = documentViewModel;
            }

            @Override
            public float getZoom() {
                return this.model.getViewZoom();
            }
        });
        this.freeTextPane.setLineWrap(false);
        this.freeTextPane.setBackground(new Color(0, 0, 0, 0));
        this.freeTextPane.setMargin(new Insets(0, 0, 0, 0));
        this.freeTextPane.setEditable(false);
        String contents = this.freeTextAnnotation.getContents();
        if (contents != null) {
            contents = contents.replace('\r', '\n');
            this.freeTextPane.setText(contents);
        }
        this.freeTextPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FreeTextAnnotationComponent.this.contentTextChange = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FreeTextAnnotationComponent.this.contentTextChange = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FreeTextAnnotationComponent.this.contentTextChange = true;
            }
        });
        GridLayout grid = new GridLayout(1, 1, 0, 0);
        this.setLayout(grid);
        this.add(this.freeTextPane);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(this);
        if (annotation.getBbox() != null) {
            this.setBounds(annotation.getBbox().getBounds());
        }
        this.resetAppearanceShapes();
        this.revalidate();
    }

    public void setAppearanceStream() {
        if (this.fontFile == null || this.freeTextAnnotation.isFontPropertyChanged()) {
            this.fontFile = FontManager.getInstance().getType1AWTFont(this.freeTextAnnotation.getFontName(), this.freeTextAnnotation.getFontSize());
        }
        this.freeTextPane.setFont(this.fontFile);
        this.freeTextPane.setForeground(this.freeTextAnnotation.getFontColor());
        if (this.freeTextAnnotation.isFillType()) {
            this.freeTextPane.setOpaque(true);
            this.freeTextPane.setBackground(this.freeTextAnnotation.getFillColor());
        } else {
            this.freeTextPane.setOpaque(false);
        }
        if (this.freeTextAnnotation.isStrokeType()) {
            if (this.freeTextAnnotation.getBorderStyle().isStyleSolid()) {
                this.freeTextPane.setBorder(BorderFactory.createLineBorder(this.freeTextAnnotation.getColor(), (int)this.freeTextAnnotation.getBorderStyle().getStrokeWidth()));
            } else if (this.freeTextAnnotation.getBorderStyle().isStyleDashed()) {
                this.freeTextPane.setBorder(new DashedBorder(this.freeTextAnnotation.getBorderStyle(), this.freeTextAnnotation.getColor()));
            }
        } else {
            this.freeTextPane.setBorder(BorderFactory.createEmptyBorder());
        }
        String content = null;
        try {
            content = this.freeTextPane.getDocument().getText(0, this.freeTextPane.getDocument().getLength());
        }
        catch (BadLocationException e) {
            logger.warning("Error getting rich text.");
        }
        Rectangle tBbox = this.convertToPageSpace(this.getBounds());
        this.freeTextAnnotation.setBBox(tBbox);
        this.freeTextAnnotation.setContents(content);
        this.freeTextAnnotation.setRichText(this.freeTextPane.getText());
        this.freeTextPane.revalidate();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        super.mouseDragged(me);
        this.resetAppearanceShapes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTextArea freeText;
        String prop = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if ("focusOwner".equals(prop) && oldValue instanceof JTextArea) {
            JTextArea freeText2 = (JTextArea)oldValue;
            if (freeText2.equals(this.freeTextPane)) {
                freeText2.setEditable(false);
                if (this.contentTextChange) {
                    this.contentTextChange = false;
                    this.resetAppearanceShapes();
                }
                if (freeText2 instanceof FreeTextArea) {
                    ((FreeTextArea)freeText2).setActive(false);
                }
            }
        } else if ("focusOwner".equals(prop) && newValue instanceof JTextArea && (freeText = (JTextArea)newValue).equals(this.freeTextPane) && !this.annotation.getFlagReadOnly()) {
            freeText.setEditable(true);
            if (freeText instanceof FreeTextArea) {
                ((FreeTextArea)freeText).setActive(true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.isShowInvisibleBorder = (this.documentViewModel.getViewToolMode() == 6 || this.documentViewModel.getViewToolMode() == 17) && !this.annotation.getFlagReadOnly() && !this.annotation.getFlagLocked() && !this.annotation.getFlagInvisible() && !this.annotation.getFlagHidden();
    }

    @Override
    public void dispose() {
        super.dispose();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this);
    }

    @Override
    public void resetAppearanceShapes() {
        this.setAppearanceStream();
        this.annotation.resetAppearanceStream(this.getPageTransform());
    }

    public boolean isActive() {
        return this.freeTextPane.isActive();
    }

    public String clearXMLHeader(String strXML) {
        String regExp = "[<][?]\\s*[xml].*[?][>]";
        strXML = strXML.replaceFirst(regExp, "");
        return strXML;
    }

    private class DashedBorder
    extends AbstractBorder {
        private BasicStroke stroke;
        private Color color;

        public DashedBorder(BorderStyle borderStyle, Color color) {
            int thickness = (int)borderStyle.getStrokeWidth();
            this.stroke = new BasicStroke(thickness, 2, 0, (float)thickness * 2.0f, FreeTextAnnotationComponent.this.freeTextAnnotation.getBorderStyle().getDashArray(), 0.0f);
            this.color = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            float size = this.stroke.getLineWidth();
            if (size > 0.0f) {
                if ((g = g.create()) instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setStroke(this.stroke);
                    g2d.setPaint((Paint)(this.color != null ? this.color : (c == null ? null : c.getForeground())));
                    g2d.draw(new Rectangle2D.Float((float)x + size / 2.0f, (float)y + size / 2.0f, (float)width - size, (float)height - size));
                }
                g.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = insets.bottom = (int)this.stroke.getLineWidth();
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
    }

    public class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        StringBuffer s;

        public void parse(Reader in) throws IOException {
            this.s = new StringBuffer();
            ParserDelegator delegator = new ParserDelegator();
            delegator.parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.s.append(text);
            this.s.append("\n");
        }

        public String getText() {
            return this.s.toString();
        }
    }
}

