/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.OneColumnPageView;
import org.icepdf.ri.common.views.OnePageView;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.TwoColumnPageView;
import org.icepdf.ri.common.views.TwoPageView;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.images.Images;

public class DocumentViewControllerImpl
implements DocumentViewController,
ComponentListener {
    private static final Logger logger;
    public static final int ONE_PAGE_VIEW = 1;
    public static final int ONE_COLUMN_VIEW = 2;
    public static final int TWO_PAGE_LEFT_VIEW = 3;
    public static final int TWO_COLUMN_LEFT_VIEW = 4;
    public static final int TWO_PAGE_RIGHT_VIEW = 5;
    public static final int TWO_COLUMN_RIGHT_VIEW = 6;
    public static final float ZOOM_FACTOR = 1.2f;
    public static final float ROTATION_FACTOR = 90.0f;
    public static Color backgroundColor;
    private float[] zoomLevels;
    private Document document;
    private DocumentViewModelImpl documentViewModel;
    private AbstractDocumentView documentView;
    private JScrollPane documentViewScrollPane;
    protected int viewportWidth;
    protected int oldViewportWidth;
    protected int viewportHeight;
    protected int oldViewportHeight;
    protected int viewType;
    protected int oldViewType;
    protected int viewportFitMode;
    protected int oldViewportFitMode;
    protected SwingController viewerController;
    protected AnnotationCallback annotationCallback;
    protected SecurityCallback securityCallback;
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public DocumentViewControllerImpl(final SwingController viewerController) {
        this.viewerController = viewerController;
        this.documentViewScrollPane = new JScrollPane();
        this.documentViewScrollPane.getViewport().setBackground(backgroundColor);
        this.documentViewScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.documentViewScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        AbstractAction deleteAnnotation = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentViewControllerImpl.this.documentViewModel != null) {
                    DocumentViewControllerImpl.this.deleteCurrentAnnotation();
                    viewerController.reflectUndoCommands();
                }
            }
        };
        InputMap inputMap = this.documentViewScrollPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "removeSelecteAnnotation");
        this.documentViewScrollPane.getActionMap().put("removeSelecteAnnotation", deleteAnnotation);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document newDocument) {
        if (this.document != null) {
            this.document.dispose();
            this.document = null;
        }
        this.document = newDocument;
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
        this.documentViewModel = new DocumentViewModelImpl(this.document, this.documentViewScrollPane);
        this.setViewType();
        this.documentViewScrollPane.addComponentListener(this);
        this.documentViewScrollPane.validate();
    }

    @Override
    public void closeDocument() {
        this.documentViewScrollPane.removeComponentListener(this);
        if (this.documentView != null) {
            this.documentViewScrollPane.remove(this.documentView);
            this.documentView.dispose();
            this.documentView = null;
        }
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
        this.setCurrentPageIndex(0);
        this.setZoom(1.0f);
        this.setRotation(0.0f);
        this.setViewCursor(8);
    }

    @Override
    public Adjustable getHorizontalScrollBar() {
        return this.documentViewScrollPane.getHorizontalScrollBar();
    }

    @Override
    public Adjustable getVerticalScrollBar() {
        return this.documentViewScrollPane.getVerticalScrollBar();
    }

    @Override
    public JViewport getViewPort() {
        return this.documentViewScrollPane.getViewport();
    }

    @Override
    public void setAnnotationCallback(AnnotationCallback annotationCallback) {
        this.annotationCallback = annotationCallback;
    }

    @Override
    public void setSecurityCallback(SecurityCallback securityCallback) {
        this.securityCallback = securityCallback;
    }

    @Override
    public void clearSelectedAnnotations() {
        if (this.documentViewModel.getCurrentAnnotation() != null) {
            this.documentViewModel.getCurrentAnnotation().setSelected(false);
            this.firePropertyChange("annotationDeselected", this.documentViewModel.getCurrentAnnotation(), null);
            this.documentViewModel.setCurrentAnnotation(null);
        }
    }

    @Override
    public void assignSelectedAnnotation(AnnotationComponent annotationComponent) {
        this.firePropertyChange("annotationSelected", this.documentViewModel.getCurrentAnnotation(), annotationComponent);
        this.documentViewModel.setCurrentAnnotation(annotationComponent);
    }

    @Override
    public void clearSelectedText() {
        ArrayList<WeakReference<AbstractPageViewComponent>> selectedPages = this.documentViewModel.getSelectedPageText();
        this.documentViewModel.setSelectAll(false);
        if (selectedPages != null && selectedPages.size() > 0) {
            for (WeakReference<AbstractPageViewComponent> page : selectedPages) {
                PageViewComponent pageComp = (PageViewComponent)page.get();
                if (pageComp == null) continue;
                pageComp.clearSelectedText();
            }
            selectedPages.clear();
            this.documentView.repaint();
        }
        this.firePropertyChange("textDeselected", null, null);
    }

    @Override
    public void clearHighlightedText() {
        DocumentSearchController searchController = this.viewerController.getDocumentSearchController();
        searchController.clearAllSearchHighlight();
        this.documentView.repaint();
    }

    @Override
    public void selectAllText() {
        this.documentViewModel.setSelectAll(true);
        this.documentView.repaint();
        this.firePropertyChange("textSelectAll", null, null);
    }

    @Override
    public String getSelectedText() {
        StringBuilder selectedText = new StringBuilder();
        try {
            if (!this.documentViewModel.isSelectAll()) {
                ArrayList<WeakReference<AbstractPageViewComponent>> selectedPages = this.documentViewModel.getSelectedPageText();
                if (selectedPages != null && selectedPages.size() > 0) {
                    for (WeakReference<AbstractPageViewComponent> page : selectedPages) {
                        AbstractPageViewComponent pageComp = (AbstractPageViewComponent)page.get();
                        if (pageComp == null) continue;
                        int pageIndex = pageComp.getPageIndex();
                        selectedText.append((CharSequence)this.document.getPageText(pageIndex).getSelected());
                    }
                }
            } else {
                Document document = this.documentViewModel.getDocument();
                for (int i = 0; i < document.getNumberOfPages(); ++i) {
                    selectedText.append(this.viewerController.getDocument().getPageText(i));
                }
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Page text extraction thread interrupted.", e);
        }
        return selectedText.toString();
    }

    @Override
    public AnnotationCallback getAnnotationCallback() {
        return this.annotationCallback;
    }

    @Override
    public SecurityCallback getSecurityCallback() {
        return this.securityCallback;
    }

    public DocumentView getDocumentView() {
        return this.documentView;
    }

    @Override
    public synchronized void setViewKeyListener(KeyListener l) {
        if (this.documentView != null) {
            this.documentView.addKeyListener(l);
        }
    }

    @Override
    public void setDestinationTarget(Destination destination) {
        JViewport documentViewport;
        if (this.documentView == null || this.documentViewModel == null) {
            return;
        }
        if (destination == null) {
            return;
        }
        int pageNumber = this.getPageTree().getPageNumber(destination.getPageReference());
        if (pageNumber < 0) {
            return;
        }
        JViewport jViewport = documentViewport = this.documentViewScrollPane != null ? this.documentViewScrollPane.getViewport() : null;
        if (documentViewport != null) {
            Rectangle pageBounds = this.documentViewModel.getPageBounds(pageNumber);
            if (this.documentViewModel.getViewRotation() == 0.0f && pageBounds != null) {
                this.setCurrentPageIndex(pageNumber);
                if (destination.getZoom() != null && destination.getZoom().floatValue() > 0.0f) {
                    this.setZoomCentered(destination.getZoom().floatValue(), null, false);
                }
                Point newViewPosition = new Point(pageBounds.getLocation());
                float zoom = this.getZoom();
                Rectangle viewportBounds = this.documentView.getBounds();
                Rectangle viewportRect = documentViewport.getViewRect();
                if (destination.getTop() != null && destination.getTop().floatValue() != 0.0f) {
                    newViewPosition.y = pageBounds.y + pageBounds.height - (int)(destination.getTop().floatValue() * zoom);
                }
                if (newViewPosition.y + viewportRect.height > viewportBounds.height) {
                    newViewPosition.y = viewportBounds.height - viewportRect.height;
                }
                if (destination.getLeft() != null && destination.getLeft().floatValue() != 0.0f) {
                    newViewPosition.x = pageBounds.x + (int)(destination.getLeft().floatValue() * zoom);
                }
                if (newViewPosition.x + viewportRect.width > viewportBounds.width) {
                    newViewPosition.x = viewportBounds.width - viewportRect.width;
                }
                if (newViewPosition.x < 0) {
                    newViewPosition.x = 0;
                }
                if (newViewPosition.y < 0) {
                    newViewPosition.y = 0;
                }
                documentViewport.setViewPosition(newViewPosition);
                int oldPageIndex = this.documentViewModel.getViewCurrentPageIndex();
                this.documentViewModel.setViewCurrentPageIndex(pageNumber);
                this.firePropertyChange("documentCurrentPage", oldPageIndex, pageNumber);
            } else {
                this.setCurrentPageIndex(pageNumber);
            }
            this.viewerController.updateDocumentView();
        }
    }

    @Override
    public void dispose() {
        if (this.documentView != null) {
            this.documentView.dispose();
            this.documentView = null;
        }
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
    }

    @Override
    public Container getViewContainer() {
        return this.documentViewScrollPane;
    }

    @Override
    public Controller getParentController() {
        return this.viewerController;
    }

    @Override
    public int getViewMode() {
        return this.viewType;
    }

    @Override
    public void setViewType(int documentViewType) {
        this.oldViewType = this.viewType;
        this.viewType = documentViewType;
        if (this.documentView != null) {
            this.documentView.uninstallCurrentTool();
        }
        this.setViewType();
    }

    private void setViewType() {
        if (this.documentView != null) {
            this.documentViewScrollPane.remove(this.documentView);
            this.documentViewScrollPane.validate();
            this.documentView.dispose();
        }
        if (this.documentViewModel == null) {
            return;
        }
        this.documentView = this.viewType == 2 ? new OneColumnPageView((DocumentViewController)this, this.documentViewScrollPane, this.documentViewModel) : (this.viewType == 1 ? new OnePageView((DocumentViewController)this, this.documentViewScrollPane, this.documentViewModel) : (this.viewType == 4 ? new TwoColumnPageView(this, this.documentViewScrollPane, this.documentViewModel, 0) : (this.viewType == 3 ? new TwoPageView(this, this.documentViewScrollPane, this.documentViewModel, 0) : (this.viewType == 6 ? new TwoColumnPageView(this, this.documentViewScrollPane, this.documentViewModel, 1) : (this.viewType == 5 ? new TwoPageView(this, this.documentViewScrollPane, this.documentViewModel, 1) : new OneColumnPageView((DocumentViewController)this, this.documentViewScrollPane, this.documentViewModel))))));
        this.documentView.setToolMode(this.documentViewModel.getViewToolMode());
        this.documentViewScrollPane.setViewportView(this.documentView);
        this.documentViewScrollPane.validate();
        this.viewerController.setPageFitMode(this.viewportFitMode, true);
        this.setCurrentPageIndex(this.documentViewModel.getViewCurrentPageIndex());
    }

    @Override
    public boolean setFitMode(int fitMode) {
        if (this.documentViewModel == null) {
            return false;
        }
        boolean changed = fitMode != this.viewportFitMode;
        this.viewportFitMode = fitMode;
        if (this.document != null) {
            float newZoom = this.documentViewModel.getViewZoom();
            if (this.viewportFitMode == 2) {
                newZoom = 1.0f;
            } else if (this.viewportFitMode == 3) {
                if (this.documentView != null && this.documentViewScrollPane != null) {
                    float viewportHeight = this.documentViewScrollPane.getViewport().getViewRect().height;
                    float pageViewHeight = this.documentView.getDocumentSize().height;
                    newZoom = viewportHeight > 0.0f ? viewportHeight / (pageViewHeight += (float)(AbstractDocumentView.layoutInserts * 2)) : 1.0f;
                }
            } else if (this.viewportFitMode == 4 && this.documentView != null && this.documentViewScrollPane != null) {
                float viewportWidth = this.documentViewScrollPane.getViewport().getViewRect().width;
                float pageViewWidth = this.documentView.getDocumentSize().width;
                if (!this.documentViewScrollPane.getVerticalScrollBar().isVisible()) {
                    viewportWidth -= (float)this.documentViewScrollPane.getVerticalScrollBar().getWidth();
                }
                newZoom = viewportWidth > 0.0f ? viewportWidth / (pageViewWidth += (float)(AbstractDocumentView.layoutInserts * 2)) : 1.0f;
            }
            if (this.getVerticalScrollBar().getValue() == 0) {
                this.setZoomCentered(newZoom, new Point(0, 0), true);
            } else {
                this.setZoomCentered(newZoom, null, true);
            }
        }
        return changed;
    }

    @Override
    public int getFitMode() {
        return this.viewportFitMode;
    }

    @Override
    public void setDocumentViewType(int documentView, int fitMode) {
        this.setViewType(documentView);
        this.setFitMode(fitMode);
    }

    @Override
    public boolean setCurrentPageIndex(int pageIndex) {
        Rectangle perferedPageOffset;
        if (this.documentViewModel == null) {
            return false;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex > this.document.getNumberOfPages() - 1) {
            pageIndex = this.document.getNumberOfPages() - 1;
        }
        int oldPageIndex = this.documentViewModel.getViewCurrentPageIndex();
        boolean changed = this.documentViewModel.setViewCurrentPageIndex(pageIndex);
        if (this.documentView != null) {
            this.documentView.updateDocumentView();
        }
        if ((perferedPageOffset = this.documentViewModel.getPageBounds(this.getCurrentPageIndex())) != null) {
            Rectangle currentViewSize = this.documentView.getBounds();
            if (perferedPageOffset.x + perferedPageOffset.width > currentViewSize.width) {
                perferedPageOffset.x = currentViewSize.width - perferedPageOffset.width;
            }
            if (perferedPageOffset.y + perferedPageOffset.height > currentViewSize.height) {
                perferedPageOffset.y = currentViewSize.height - perferedPageOffset.height;
            }
            this.documentViewScrollPane.getViewport().setViewPosition(perferedPageOffset.getLocation());
            this.documentViewScrollPane.revalidate();
        }
        this.firePropertyChange("documentCurrentPage", oldPageIndex, pageIndex);
        return changed;
    }

    @Override
    public int setCurrentPageNext() {
        int increment = 0;
        if (this.documentViewModel != null) {
            increment = this.documentView.getNextPageIncrement();
            int current = this.documentViewModel.getViewCurrentPageIndex();
            if (current + increment < this.document.getNumberOfPages()) {
                this.documentViewModel.setViewCurrentPageIndex(current + increment);
            } else {
                this.documentViewModel.setViewCurrentPageIndex(this.document.getNumberOfPages() - 1);
            }
        }
        return increment;
    }

    @Override
    public int setCurrentPagePrevious() {
        int decrement = 0;
        if (this.documentViewModel != null) {
            decrement = this.documentView.getPreviousPageIncrement();
            int current = this.documentViewModel.getViewCurrentPageIndex();
            if (current - decrement >= 0) {
                this.documentViewModel.setViewCurrentPageIndex(current - decrement);
            } else {
                this.documentViewModel.setViewCurrentPageIndex(0);
            }
        }
        return decrement;
    }

    @Override
    public int getCurrentPageIndex() {
        if (this.documentViewModel == null) {
            return -1;
        }
        return this.documentViewModel.getViewCurrentPageIndex();
    }

    @Override
    public int getCurrentPageDisplayValue() {
        if (this.documentViewModel == null) {
            return -1;
        }
        return this.documentViewModel.getViewCurrentPageIndex() + 1;
    }

    @Override
    public float[] getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    public void setZoomLevels(float[] zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    @Override
    public boolean setZoom(float viewZoom) {
        return this.setZoomCentered(viewZoom, null, false);
    }

    @Override
    public boolean setZoomIn() {
        return this.setZoomIn(null);
    }

    @Override
    public boolean setZoomOut() {
        return this.setZoomOut(null);
    }

    @Override
    public float getZoom() {
        if (this.documentViewModel != null) {
            return this.documentViewModel.getViewZoom();
        }
        return 0.0f;
    }

    @Override
    public float getRotation() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        return this.documentViewModel.getViewRotation();
    }

    @Override
    public float setRotateRight() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        float viewRotation = this.documentViewModel.getViewRotation();
        if ((viewRotation -= 90.0f) < 0.0f) {
            viewRotation += 360.0f;
        }
        this.documentViewModel.setViewRotation(viewRotation);
        this.documentViewScrollPane.revalidate();
        return viewRotation;
    }

    @Override
    public float setRotateLeft() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        float viewRotation = this.documentViewModel.getViewRotation();
        viewRotation += 90.0f;
        this.documentViewModel.setViewRotation(viewRotation %= 360.0f);
        this.documentViewScrollPane.revalidate();
        return viewRotation;
    }

    @Override
    public boolean setRotation(float viewRotation) {
        if (this.documentViewModel == null) {
            return false;
        }
        boolean changed = this.documentViewModel.setViewRotation(viewRotation);
        this.documentViewModel.setViewRotation(viewRotation);
        this.documentViewScrollPane.revalidate();
        return changed;
    }

    @Override
    public boolean setToolMode(int viewToolMode) {
        if (this.documentViewModel != null) {
            boolean changed = this.documentViewModel.setViewToolMode(viewToolMode);
            if (changed) {
                this.documentView.setToolMode(viewToolMode);
                List<AbstractPageViewComponent> pageComponents = this.documentViewModel.getPageComponents();
                for (AbstractPageViewComponent page : pageComponents) {
                    page.setToolMode(viewToolMode);
                }
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean isToolModeSelected(int viewToolMode) {
        return this.getToolMode() == viewToolMode;
    }

    @Override
    public int getToolMode() {
        if (this.documentViewModel == null) {
            return 50;
        }
        return this.documentViewModel.getViewToolMode();
    }

    @Override
    public void setViewCursor(int currsorType) {
        Cursor cursor = this.getViewCursor(currsorType);
        if (this.documentViewScrollPane != null && this.documentViewScrollPane.getViewport() != null) {
            this.documentViewScrollPane.getViewport().setCursor(cursor);
        }
    }

    @Override
    public Cursor getViewCursor(int currsorType) {
        Cursor c;
        String imageName;
        if (currsorType == 8) {
            return Cursor.getPredefinedCursor(0);
        }
        if (currsorType == 6) {
            return Cursor.getPredefinedCursor(3);
        }
        if (currsorType == 7) {
            return Cursor.getPredefinedCursor(0);
        }
        if (currsorType == 1) {
            imageName = "hand_open.gif";
        } else if (currsorType == 2) {
            imageName = "hand_closed.gif";
        } else if (currsorType == 3) {
            imageName = "zoom_in.gif";
        } else if (currsorType == 4) {
            imageName = "zoom_out.gif";
        } else if (currsorType == 12) {
            imageName = "zoom.gif";
        } else {
            if (currsorType == 9) {
                return Cursor.getPredefinedCursor(12);
            }
            if (currsorType == 10) {
                return Cursor.getPredefinedCursor(2);
            }
            if (currsorType == 11) {
                return Cursor.getPredefinedCursor(1);
            }
            return Cursor.getPredefinedCursor(0);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension bestsize = tk.getBestCursorSize(24, 24);
        if (bestsize.width != 0) {
            Point cursorHotSpot = new Point(12, 12);
            try {
                ImageIcon cursorImage = new ImageIcon(Images.get(imageName));
                c = tk.createCustomCursor(cursorImage.getImage(), cursorHotSpot, imageName);
            }
            catch (RuntimeException ex) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Trying to load image: " + imageName, ex);
                }
                throw ex;
            }
        } else {
            c = Cursor.getDefaultCursor();
            logger.warning("System does not support custom cursors");
        }
        return c;
    }

    @Override
    public void requestViewFocusInWindow() {
        if (this.documentViewScrollPane != null) {
            this.documentViewScrollPane.requestFocus();
        }
    }

    @Override
    public boolean setZoomIn(Point p) {
        float zoom = this.getZoom() * 1.2f;
        return this.setZoomCentered(zoom, p, false);
    }

    @Override
    public boolean setZoomOut(Point p) {
        float zoom = this.getZoom() / 1.2f;
        return this.setZoomCentered(zoom, p, false);
    }

    private void zoomCenter(Point centeringPoint) {
        if (centeringPoint == null) {
            centeringPoint = this.getCenteringPoint();
        }
        if (centeringPoint == null || this.documentViewScrollPane == null) {
            return;
        }
        int viewPortWidth = this.documentViewScrollPane.getViewport().getWidth();
        int viewPortHeight = this.documentViewScrollPane.getViewport().getHeight();
        int scrollPaneX = this.documentViewScrollPane.getViewport().getViewPosition().x;
        int scrollPaneY = this.documentViewScrollPane.getViewport().getViewPosition().y;
        Dimension pageViewSize = this.documentView.getPreferredSize();
        int pageViewWidth = pageViewSize.width;
        int pageViewHeight = pageViewSize.height;
        centeringPoint.setLocation(centeringPoint.x - viewPortWidth / 2, centeringPoint.y - viewPortHeight / 2);
        if (pageViewWidth < viewPortWidth || pageViewHeight < viewPortHeight) {
            if (centeringPoint.x >= pageViewWidth - viewPortWidth || centeringPoint.x < 0) {
                centeringPoint.x = scrollPaneX;
            }
            if (centeringPoint.y >= pageViewHeight - viewPortHeight || centeringPoint.y < 0) {
                centeringPoint.y = scrollPaneY;
            }
        } else {
            if (centeringPoint.x + viewPortWidth > pageViewWidth) {
                centeringPoint.x = pageViewWidth - viewPortWidth;
            } else if (centeringPoint.x < 0) {
                centeringPoint.x = 0;
            }
            if (centeringPoint.y + viewPortHeight > pageViewHeight) {
                centeringPoint.y = pageViewHeight - viewPortHeight;
            } else if (centeringPoint.y < 0) {
                centeringPoint.y = 0;
            }
        }
        this.documentViewScrollPane.getViewport().setViewPosition(centeringPoint);
    }

    @Override
    public boolean setZoomCentered(float zoom, Point centeringPoint, boolean becauseOfValidFitMode) {
        if (this.documentViewModel == null) {
            return false;
        }
        if (this.zoomLevels != null) {
            if (zoom < this.zoomLevels[0]) {
                zoom = this.zoomLevels[0];
            } else if (zoom > this.zoomLevels[this.zoomLevels.length - 1]) {
                zoom = this.zoomLevels[this.zoomLevels.length - 1];
            }
        }
        if (centeringPoint == null) {
            centeringPoint = this.getCenteringPoint();
        }
        float previousZoom = this.getZoom();
        boolean changed = this.documentViewModel.setViewZoom(zoom);
        this.documentViewScrollPane.validate();
        if (changed && centeringPoint != null) {
            centeringPoint.setLocation((float)centeringPoint.x / previousZoom * zoom, (float)centeringPoint.y / previousZoom * zoom);
        }
        this.zoomCenter(centeringPoint);
        if (this.viewerController != null) {
            this.viewerController.doCommonZoomUIUpdates(becauseOfValidFitMode);
        }
        return changed;
    }

    @Override
    public boolean setZoomToViewPort(float zoom, Point zoomPointDelta, int pageIndex, boolean becauseOfValidFitMode) {
        if (this.documentViewModel == null) {
            return false;
        }
        if (this.zoomLevels != null) {
            if (zoom < this.zoomLevels[0]) {
                zoom = this.zoomLevels[0];
            } else if (zoom > this.zoomLevels[this.zoomLevels.length - 1]) {
                zoom = this.zoomLevels[this.zoomLevels.length - 1];
            }
        }
        if (zoomPointDelta == null) {
            zoomPointDelta = new Point();
        }
        float previousZoom = this.getZoom();
        boolean changed = this.documentViewModel.setViewZoom(zoom);
        this.documentViewScrollPane.validate();
        if (changed) {
            Rectangle bounds = this.documentViewModel.getPageBounds(pageIndex);
            zoomPointDelta.setLocation((float)zoomPointDelta.x / previousZoom * zoom, (float)zoomPointDelta.y / previousZoom * zoom);
            zoomPointDelta.setLocation(bounds.x + zoomPointDelta.x, bounds.y + zoomPointDelta.y);
            this.getViewPort().setViewPosition(zoomPointDelta);
        }
        if (this.viewerController != null) {
            this.viewerController.doCommonZoomUIUpdates(becauseOfValidFitMode);
        }
        return changed;
    }

    private Point getCenteringPoint() {
        Point centeringPoint = null;
        if (this.documentViewScrollPane != null) {
            int x = this.documentViewScrollPane.getViewport().getViewPosition().x + this.documentViewScrollPane.getViewport().getWidth() / 2;
            int y = this.documentViewScrollPane.getViewport().getViewPosition().y + this.documentViewScrollPane.getViewport().getHeight() / 2;
            centeringPoint = new Point(x, y);
        }
        return centeringPoint;
    }

    private PageTree getPageTree() {
        if (this.document == null) {
            return null;
        }
        return this.document.getPageTree();
    }

    @Override
    public DocumentViewModel getDocumentViewModel() {
        return this.documentViewModel;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Object src = e.getSource();
        if (src == null) {
            return;
        }
        if (src == this.documentViewScrollPane) {
            this.setFitMode(this.getFitMode());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void firePropertyChange(String event, int oldValue, int newValue) {
        this.changes.firePropertyChange(event, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String event, Object oldValue, Object newValue) {
        this.changes.firePropertyChange(event, oldValue, newValue);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void deleteCurrentAnnotation() {
        AbstractAnnotationComponent annotationComponent = (AbstractAnnotationComponent)this.documentViewModel.getCurrentAnnotation();
        if (!(annotationComponent instanceof PopupAnnotationComponent)) {
            this.deleteAnnotation(annotationComponent);
        }
    }

    @Override
    public void deleteAnnotation(AnnotationComponent annotationComponent) {
        if (this.documentViewModel != null && annotationComponent != null) {
            PageViewComponent pageComponent = annotationComponent.getPageViewComponent();
            if (this.annotationCallback != null) {
                this.annotationCallback.removeAnnotation(pageComponent, annotationComponent);
            }
            this.firePropertyChange("annotationDeleted", this.documentViewModel.getCurrentAnnotation(), null);
            this.assignSelectedAnnotation(null);
            this.documentView.repaint();
        }
    }

    @Override
    public void undo() {
        this.documentViewModel.getAnnotationCareTaker().undo();
        this.documentView.repaint();
    }

    @Override
    public void redo() {
        this.documentViewModel.getAnnotationCareTaker().redo();
        this.documentView.repaint();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    static {
        block2: {
            logger = Logger.getLogger(DocumentViewControllerImpl.class.toString());
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.background.color", "#808080");
                int colorValue = ColorUtil.convertColor(color);
                backgroundColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("808080", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading page shadow colour");
            }
        }
    }
}

