/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class TextMarkupAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_TEXT_MARKUP_TYPE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static ValueLabelItem[] TEXT_MARKUP_TYPE_LIST;
    private JComboBox textMarkupTypes;
    private JButton colorButton;
    private TextMarkupAnnotation annotation;

    public TextMarkupAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(2, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        this.annotation = (TextMarkupAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.textMarkupTypes, this.annotation.getSubType());
        this.colorButton.setBackground(this.annotation.getTextMarkupColor());
        this.safeEnable(this.textMarkupTypes, true);
        this.safeEnable(this.colorButton, true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.textMarkupTypes) {
                this.annotation.setSubtype((Name)item.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        if (e.getSource() == this.colorButton && (chosenColor = JColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorChooserTitle"), this.colorButton.getBackground())) != null) {
            this.colorButton.setBackground(chosenColor);
            this.annotation.setTextMarkupColor(chosenColor);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        if (TEXT_MARKUP_TYPE_LIST == null) {
            TEXT_MARKUP_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_HIGHLIGHT, "Highlight"), new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT, "Strikeout"), new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_UNDERLINE, "Underline")};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.appearance.title"), 1, 0));
        this.textMarkupTypes = new JComboBox<ValueLabelItem>(TEXT_MARKUP_TYPE_LIST);
        this.textMarkupTypes.setSelectedIndex(0);
        this.textMarkupTypes.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.highlightType")));
        this.add(this.textMarkupTypes);
        this.colorButton = new JButton();
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorLabel")));
        this.add(this.colorButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.textMarkupTypes, enabled);
        this.safeEnable(this.colorButton, enabled);
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

