/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class LinkAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener {
    private static final int DEFAULT_HIGHLIGHT_STYLE = 1;
    private static ValueLabelItem[] HIGHLIGHT_STYLE_LIST;
    private JComboBox highlightStyleBox;
    private Name highlightStyle;

    public LinkAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(1, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null || !(newAnnotation.getAnnotation() instanceof LinkAnnotation)) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        LinkAnnotation linkAnnotation = (LinkAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.highlightStyle = linkAnnotation.getHighlightMode();
        this.applySelectedValue(this.highlightStyleBox, this.highlightStyle);
        this.enableAppearanceInputComponents(linkAnnotation.getBorderType());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.highlightStyleBox) {
                this.highlightStyle = (Name)item.getValue();
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        HIGHLIGHT_STYLE_LIST = new ValueLabelItem[]{new ValueLabelItem(LinkAnnotation.HIGHLIGHT_NONE, this.messageBundle.getString("viewer.utilityPane.annotation.link.none")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_INVERT, this.messageBundle.getString("viewer.utilityPane.annotation.link.invert")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_OUTLINE, this.messageBundle.getString("viewer.utilityPane.annotation.link.outline")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_PUSH, this.messageBundle.getString("viewer.utilityPane.annotation.link.push"))};
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.link.appearance.title"), 1, 0));
        this.highlightStyleBox = new JComboBox<ValueLabelItem>(HIGHLIGHT_STYLE_LIST);
        this.highlightStyleBox.setSelectedIndex(1);
        this.highlightStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.link.highlightType")));
        this.add(this.highlightStyleBox);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.highlightStyleBox, enabled);
    }

    private void enableAppearanceInputComponents(int linkType) {
        if (linkType == 0) {
            this.safeEnable(this.highlightStyleBox, true);
        } else {
            this.safeEnable(this.highlightStyleBox, true);
        }
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

