/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class ZoomInPageHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(ZoomInPageHandler.class.toString());
    private Point initialPoint = new Point();

    public ZoomInPageHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
        selectionBoxColour = Color.DARK_GRAY;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(e, this.pageViewComponent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x1F5) != 0 && (e.getModifiers() & 0x10) != 0) {
            Point pageOffset = this.documentViewModel.getPageBounds(this.pageViewComponent.getPageIndex()).getLocation();
            Point mouse = e.getPoint();
            mouse.setLocation(pageOffset.x + mouse.x, pageOffset.y + mouse.y);
            this.documentViewController.setZoomIn(mouse);
        }
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.documentViewController != null) {
            this.resetRectangle(e.getX(), e.getY());
            this.initialPoint.setLocation(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(e, this.pageViewComponent);
            Point pageOffset = this.documentViewModel.getPageBounds(this.pageViewComponent.getPageIndex()).getLocation();
            Rectangle absoluteRectToDraw = new Rectangle(pageOffset.x + this.rectToDraw.x, pageOffset.y + this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            if (this.documentViewController.getViewPort() != null && absoluteRectToDraw.getWidth() > 0.0 && absoluteRectToDraw.getHeight() > 0.0) {
                float zoom = ZoomInPageHandler.calculateZoom(this.documentViewController, absoluteRectToDraw, this.documentViewModel);
                int pageIndex = this.pageViewComponent.getPageIndex();
                Rectangle location = this.documentViewModel.getPageBounds(pageIndex);
                Point delta = new Point(absoluteRectToDraw.x - location.x, absoluteRectToDraw.y - location.y);
                this.documentViewController.setZoomToViewPort(zoom, delta, pageIndex, true);
            }
            this.clearRectangle(this.pageViewComponent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
        this.setSelectionSize(selection, this.pageViewComponent);
    }

    @Override
    public void paintTool(Graphics g) {
        ZoomInPageHandler.paintSelectionBox(g, this.rectToDraw);
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    public static float calculateZoom(DocumentViewController documentViewController, Rectangle rectToDraw, DocumentViewModel documentViewModel) {
        Dimension viewport = documentViewController.getViewPort().getParent().getSize();
        int selectionMax = rectToDraw.width;
        int screenMax = viewport.width;
        if ((double)screenMax < viewport.getHeight()) {
            screenMax = viewport.height;
        }
        if ((double)selectionMax < rectToDraw.getHeight()) {
            selectionMax = rectToDraw.height;
        }
        return (float)screenMax / (float)selectionMax * documentViewModel.getViewZoom();
    }
}

