/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class TextSelectionPageHandler
extends SelectionBoxHandler
implements ToolHandler {
    protected static final Logger logger;
    public static final float selectionAlpha = 0.3f;
    public static Color selectionColor;
    public int selectedCount;
    public static Color highlightColor;

    public TextSelectionPageHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Page currentPage;
        if (e.getClickCount() == 3) {
            currentPage = this.pageViewComponent.getPage();
            Point mouseLocation = (Point)e.getPoint().clone();
            this.lineSelectHandler(currentPage, mouseLocation);
        } else if (e.getClickCount() == 2) {
            currentPage = this.pageViewComponent.getPage();
            Point mouseLocation = (Point)e.getPoint().clone();
            this.wordSelectHandler(currentPage, mouseLocation);
        }
        if (logger.isLoggable(Level.FINE)) {
            currentPage = this.pageViewComponent.getPage();
            logger.fine(currentPage.getViewText().getSelected().toString());
        }
        this.documentViewController.clearSelectedAnnotations();
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.documentViewController.clearSelectedText();
        this.selectedCount = 0;
        int x = e.getX();
        int y = e.getY();
        this.currentRect = new Rectangle(x, y, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        if (logger.isLoggable(Level.FINE)) {
            Page currentPage = this.pageViewComponent.getPage();
            logger.fine(currentPage.getViewText().getSelected().toString());
        }
        if (this.selectedCount > 0) {
            this.documentViewModel.addSelectedPageText(this.pageViewComponent);
            this.documentViewController.firePropertyChange("textSelected", null, null);
        }
        this.clearRectangle(this.pageViewComponent);
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        Page currentPage = this.pageViewComponent.getPage();
        this.multiLineSelectHandler(currentPage, e.getPoint());
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
        this.setSelectionSize(selection, this.pageViewComponent);
        Page currentPage = this.pageViewComponent.getPage();
        this.multiLineSelectHandler(currentPage, cursorLocation);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Page currentPage = this.pageViewComponent.getPage();
        this.selectionMouseCursor(currentPage, e.getPoint());
    }

    private void selectionMouseCursor(Page currentPage, Point mouseLocation) {
        PageText pageText;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            AffineTransform pageTransform = currentPage.getPageTransform(2, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            ArrayList<LineText> pageLines = pageText.getPageLines();
            boolean found = false;
            Point2D.Float pageMouseLocation = this.convertMouseToPageSpace(mouseLocation, pageTransform);
            for (LineText pageLine : pageLines) {
                if (!pageLine.getBounds().contains(pageMouseLocation)) continue;
                found = true;
                this.documentViewController.setViewCursor(10);
                break;
            }
            if (!found) {
                this.documentViewController.setViewCursor(7);
            }
        }
    }

    private Point2D.Float convertMouseToPageSpace(Point mousePoint, AffineTransform pageTransform) {
        Point2D.Float pageMouseLocation = new Point2D.Float();
        try {
            pageTransform.createInverse().transform(mousePoint, pageMouseLocation);
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.SEVERE, "Error converting mouse point to page space.", e);
        }
        return pageMouseLocation;
    }

    private Rectangle2D convertRectangleToPageSpace(Rectangle mouseRect, AffineTransform pageTransform) {
        try {
            AffineTransform tranform = pageTransform.createInverse();
            GeneralPath shapePath = new GeneralPath(mouseRect);
            shapePath.transform(tranform);
            return shapePath.getBounds2D();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.SEVERE, "Error converting mouse point to page space.", e);
            return null;
        }
    }

    private void multiLineSelectHandler(Page currentPage, Point mouseLocation) {
        PageText pageText;
        this.selectedCount = 0;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            currentPage.getViewText().clearSelected();
            AffineTransform pageTransform = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            LineText firstPageLine = null;
            Point2D.Float pageMouseLocation = this.convertMouseToPageSpace(mouseLocation, pageTransform);
            Rectangle2D pageRectToDraw = this.convertRectangleToPageSpace(this.rectToDraw, pageTransform);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            for (LineText pageLine : pageLines) {
                if (!pageLine.intersects(pageRectToDraw)) continue;
                pageLine.setHasSelected(true);
                ++this.selectedCount;
                if (firstPageLine == null) {
                    firstPageLine = pageLine;
                }
                if (pageLine.getBounds().contains(pageMouseLocation)) {
                    List<WordText> lineWords = pageLine.getWords();
                    for (WordText word : lineWords) {
                        if (!word.intersects(pageRectToDraw)) continue;
                        word.setHasHighlight(true);
                        ++this.selectedCount;
                        ArrayList<GlyphText> glyphs = word.getGlyphs();
                        for (GlyphText glyph : glyphs) {
                            if (!glyph.intersects(pageRectToDraw)) continue;
                            glyph.setSelected(true);
                            ++this.selectedCount;
                            this.pageViewComponent.repaint();
                        }
                    }
                    continue;
                }
                if (firstPageLine == pageLine) {
                    this.selectLeftToRight(pageLine, pageTransform);
                    continue;
                }
                pageLine.selectAll();
            }
        }
    }

    private void selectRightToLeft(LineText pageLine, AffineTransform pageTransform) {
    }

    private void selectLeftToRight(LineText pageLine, AffineTransform pageTransform) {
        GlyphText fistGlyph = null;
        Rectangle2D pageRectToDraw = this.convertRectangleToPageSpace(this.rectToDraw, pageTransform);
        List<WordText> lineWords = pageLine.getWords();
        for (WordText word : lineWords) {
            if (word.intersects(pageRectToDraw)) {
                word.setHasHighlight(true);
                ArrayList<GlyphText> glyphs = word.getGlyphs();
                for (GlyphText glyph : glyphs) {
                    if (glyph.intersects(pageRectToDraw)) {
                        if (fistGlyph == null) {
                            fistGlyph = glyph;
                        }
                        glyph.setSelected(true);
                        continue;
                    }
                    if (fistGlyph == null) continue;
                    glyph.setSelected(true);
                }
                continue;
            }
            if (fistGlyph == null) continue;
            word.selectAll();
        }
        this.pageViewComponent.repaint();
    }

    private void rectangleSelectHandler(Page currentPage, Point mouseLocation) {
        PageText pageText;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            currentPage.getViewText().clearSelected();
            AffineTransform pageTransform = currentPage.getPageTransform(2, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            Rectangle2D pageRectToDraw = this.convertRectangleToPageSpace(this.rectToDraw, pageTransform);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            for (LineText pageLine : pageLines) {
                if (!pageLine.intersects(pageRectToDraw)) continue;
                pageLine.setHasSelected(true);
                List<WordText> lineWords = pageLine.getWords();
                for (WordText word : lineWords) {
                    if (!word.intersects(pageRectToDraw)) continue;
                    word.setHasHighlight(true);
                    ArrayList<GlyphText> glyphs = word.getGlyphs();
                    for (GlyphText glyph : glyphs) {
                        if (!glyph.intersects(pageRectToDraw)) continue;
                        glyph.setSelected(true);
                        this.pageViewComponent.repaint();
                    }
                }
            }
        }
    }

    private void wordSelectHandler(Page currentPage, Point mouseLocation) {
        PageText pageText;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            currentPage.getViewText().clearSelected();
            AffineTransform pageTransform = currentPage.getPageTransform(2, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            Point2D.Float pageMouseLocation = this.convertMouseToPageSpace(mouseLocation, pageTransform);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            block0: for (LineText pageLine : pageLines) {
                if (!pageLine.getBounds().contains(pageMouseLocation)) continue;
                pageLine.setHasSelected(true);
                List<WordText> lineWords = pageLine.getWords();
                for (WordText word : lineWords) {
                    if (!word.getBounds().contains(pageMouseLocation)) continue;
                    word.selectAll();
                    this.documentViewModel.addSelectedPageText(this.pageViewComponent);
                    this.documentViewController.firePropertyChange("textSelected", null, null);
                    this.pageViewComponent.repaint();
                    continue block0;
                }
            }
        }
    }

    private void lineSelectHandler(Page currentPage, Point mouseLocation) {
        PageText pageText;
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            currentPage.getViewText().clearSelected();
            AffineTransform pageTransform = currentPage.getPageTransform(2, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            Point2D.Float pageMouseLocation = this.convertMouseToPageSpace(mouseLocation, pageTransform);
            ArrayList<LineText> pageLines = pageText.getPageLines();
            for (LineText pageLine : pageLines) {
                if (!pageLine.getBounds().contains(pageMouseLocation)) continue;
                pageLine.selectAll();
                this.documentViewModel.addSelectedPageText(this.pageViewComponent);
                this.documentViewController.firePropertyChange("textSelected", null, null);
                this.pageViewComponent.repaint();
                break;
            }
        }
    }

    public static void paintSelectedText(Graphics g, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        PageText pageText;
        Graphics2D gg = (Graphics2D)g;
        AffineTransform prePaintTransform = gg.getTransform();
        Color oldColor = gg.getColor();
        Stroke oldStroke = gg.getStroke();
        gg.setComposite(AlphaComposite.getInstance(3, 0.3f));
        gg.setColor(selectionColor);
        gg.setStroke(new BasicStroke(1.0f));
        Page currentPage = pageViewComponent.getPage();
        if (currentPage != null && currentPage.isInitiated() && (pageText = currentPage.getViewText()) != null) {
            AffineTransform pageTransform = currentPage.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            ArrayList<LineText> visiblePageLines = pageText.getPageLines();
            if (visiblePageLines != null) {
                for (LineText lineText : visiblePageLines) {
                    for (WordText wordText : lineText.getWords()) {
                        GeneralPath textPath;
                        if (wordText.isSelected() || wordText.isHighlighted()) {
                            textPath = new GeneralPath(wordText.getBounds());
                            textPath.transform(pageTransform);
                            if (wordText.isSelected()) {
                                gg.setColor(selectionColor);
                                gg.fill(textPath);
                            }
                            if (!wordText.isHighlighted()) continue;
                            gg.setColor(highlightColor);
                            gg.fill(textPath);
                            continue;
                        }
                        for (GlyphText glyph : wordText.getGlyphs()) {
                            if (!glyph.isSelected()) continue;
                            textPath = new GeneralPath(glyph.getBounds());
                            textPath.transform(pageTransform);
                            gg.setColor(selectionColor);
                            gg.fill(textPath);
                        }
                    }
                }
            }
        }
        gg.setComposite(AlphaComposite.getInstance(3, 1.0f));
        gg.setTransform(prePaintTransform);
        gg.setStroke(oldStroke);
        gg.setColor(oldColor);
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    private void paintTextBounds(Graphics g) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform pageTransform = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        Graphics2D gg = (Graphics2D)g;
        Color oldColor = g.getColor();
        g.setColor(Color.red);
        PageText pageText = currentPage.getViewText();
        ArrayList<LineText> pageLines = pageText.getPageLines();
        for (LineText lineText : pageLines) {
            for (WordText wordText : lineText.getWords()) {
                for (GlyphText glyph : wordText.getGlyphs()) {
                    g.setColor(Color.black);
                    GeneralPath glyphSpritePath = new GeneralPath(glyph.getBounds());
                    glyphSpritePath.transform(pageTransform);
                    gg.draw(glyphSpritePath);
                }
            }
            g.setColor(Color.red);
            GeneralPath glyphSpritePath = new GeneralPath(lineText.getBounds());
            glyphSpritePath.transform(pageTransform);
            gg.draw(glyphSpritePath);
        }
        g.setColor(oldColor);
    }

    @Override
    public void paintTool(Graphics g) {
        TextSelectionPageHandler.paintSelectionBox(g, this.rectToDraw);
    }

    static {
        block5: {
            int colorValue;
            String color;
            block4: {
                logger = Logger.getLogger(TextSelectionPageHandler.class.toString());
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.text.selectionColor", "#0077FF");
                    colorValue = ColorUtil.convertColor(color);
                    selectionColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("0077FF", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading text selection colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.text.highlightColor", "#CC00FF");
                colorValue = ColorUtil.convertColor(color);
                highlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("FFF600", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading text highlight colour");
            }
        }
    }
}

