/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomOutPageHandler;
import org.icepdf.ri.common.views.DocumentViewController;

public class DynamicZoomHandler
implements ToolHandler,
MouseWheelListener {
    private static final Logger logger = Logger.getLogger(ZoomOutPageHandler.class.toString());
    private DocumentViewController documentViewController;
    protected JScrollPane documentScrollPane;

    public DynamicZoomHandler(DocumentViewController documentViewController, JScrollPane documentScrollPane) {
        this.documentViewController = documentViewController;
        this.documentScrollPane = documentScrollPane;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        this.documentScrollPane.setWheelScrollingEnabled(false);
        Point offset = this.documentScrollPane.getViewport().getViewPosition();
        int viewWidth = this.documentScrollPane.getViewport().getWidth() / 2;
        int viewHeight = this.documentScrollPane.getViewport().getHeight() / 2;
        offset.setLocation(offset.x + viewWidth, offset.y + viewHeight);
        if (rotation > 0) {
            this.documentViewController.setZoomOut(offset);
        } else {
            this.documentViewController.setZoomIn(offset);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void paintTool(Graphics g) {
    }

    @Override
    public void installTool() {
        this.documentScrollPane.setWheelScrollingEnabled(false);
        this.documentScrollPane.addMouseWheelListener(this);
    }

    @Override
    public void uninstallTool() {
        this.documentScrollPane.setWheelScrollingEnabled(true);
        this.documentScrollPane.removeMouseWheelListener(this);
    }
}

