/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.KeyEventConstants;
import org.icepdf.ri.common.PageNumberTextFieldInputVerifier;
import org.icepdf.ri.common.PageNumberTextFieldKeyListener;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.ToolbarLayout;
import org.icepdf.ri.common.WindowManagementCallback;
import org.icepdf.ri.common.utility.annotation.AnnotationPanel;
import org.icepdf.ri.common.utility.layers.LayersPanel;
import org.icepdf.ri.common.utility.outline.OutlinesTree;
import org.icepdf.ri.common.utility.search.SearchPanel;
import org.icepdf.ri.common.utility.thumbs.ThumbnailsPanel;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.PropertiesManager;

public class SwingViewBuilder {
    private static final Logger logger = Logger.getLogger(SwingViewBuilder.class.toString());
    public static final int TOOL_BAR_STYLE_FLOATING = 1;
    public static final int TOOL_BAR_STYLE_FIXED = 2;
    protected static final float[] DEFAULT_ZOOM_LEVELS = new float[]{0.05f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 8.0f, 16.0f, 24.0f, 32.0f, 64.0f};
    protected SwingController viewerController;
    protected Font buttonFont;
    protected boolean showButtonText;
    protected int toolbarStyle;
    protected float[] zoomLevels;
    protected boolean haveMadeAToolBar;
    protected int documentViewType;
    protected int documentPageFitMode;
    protected ResourceBundle messageBundle;
    protected PropertiesManager propertiesManager;
    public static boolean isMacOs = Defs.sysProperty("mrj.version") != null;
    private static boolean isDemo = Defs.sysPropertyBoolean("org.icepdf.ri.viewer.demo", false);

    public SwingViewBuilder(SwingController c) {
        this(c, null, null, false, 2, null, 1, 3);
    }

    public SwingViewBuilder(SwingController c, PropertiesManager properties) {
        this(c, properties, null, false, 2, null, 1, 3);
    }

    public SwingViewBuilder(SwingController c, int documentViewType, int documentPageFitMode) {
        this(c, null, null, false, 2, null, documentViewType, documentPageFitMode);
    }

    public SwingViewBuilder(SwingController c, Font bf, boolean bt, int ts, float[] zl, int documentViewType, int documentPageFitMode) {
        this(c, null, bf, bt, ts, zl, documentViewType, documentPageFitMode);
    }

    public SwingViewBuilder(SwingController c, PropertiesManager properties, Font bf, boolean bt, int ts, float[] zl, int documentViewType, int documentPageFitMode) {
        this.viewerController = c;
        this.messageBundle = this.viewerController.getMessageBundle();
        if (properties != null) {
            this.viewerController.setPropertiesManager(properties);
            this.propertiesManager = properties;
        }
        this.overrideHighlightColor();
        DocumentViewControllerImpl documentViewController = (DocumentViewControllerImpl)this.viewerController.getDocumentViewController();
        documentViewController.setDocumentViewType(documentViewType, documentPageFitMode);
        this.buttonFont = bf;
        if (this.buttonFont == null) {
            this.buttonFont = this.buildButtonFont();
        }
        this.showButtonText = bt;
        this.toolbarStyle = ts;
        this.zoomLevels = zl;
        if (this.zoomLevels == null) {
            this.zoomLevels = DEFAULT_ZOOM_LEVELS;
        }
        this.documentViewType = documentViewType;
        this.documentPageFitMode = documentPageFitMode;
    }

    public JFrame buildViewerFrame() {
        JFrame viewer = new JFrame();
        viewer.setIconImage(new ImageIcon(Images.get("icepdf-app-icon-64x64.png")).getImage());
        viewer.setTitle(this.messageBundle.getString("viewer.window.title.default"));
        viewer.setDefaultCloseOperation(0);
        JMenuBar menuBar = this.buildCompleteMenuBar();
        if (menuBar != null) {
            viewer.setJMenuBar(menuBar);
        }
        Container contentPane = viewer.getContentPane();
        this.buildContents(contentPane, false);
        if (this.viewerController != null) {
            this.viewerController.setViewerFrame(viewer);
        }
        return viewer;
    }

    public JPanel buildViewerPanel() {
        JPanel panel = new JPanel();
        this.buildContents(panel, true);
        return panel;
    }

    public void buildContents(Container cp, boolean embeddableComponent) {
        JPanel statusPanel;
        JSplitPane utilAndDocSplit;
        cp.setLayout(new BorderLayout());
        JToolBar toolBar = this.buildCompleteToolBar(embeddableComponent);
        if (toolBar != null) {
            cp.add((Component)toolBar, "North");
        }
        if ((utilAndDocSplit = this.buildUtilityAndDocumentSplitPane(embeddableComponent)) != null) {
            cp.add((Component)utilAndDocSplit, "Center");
        }
        if ((statusPanel = this.buildStatusPanel()) != null) {
            cp.add((Component)statusPanel, "South");
        }
    }

    public JMenuBar buildCompleteMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.addToMenuBar(menuBar, this.buildFileMenu());
        this.addToMenuBar(menuBar, this.buildEditMenu());
        this.addToMenuBar(menuBar, this.buildViewMenu());
        this.addToMenuBar(menuBar, this.buildDocumentMenu());
        this.addToMenuBar(menuBar, this.buildWindowMenu());
        this.addToMenuBar(menuBar, this.buildHelpMenu());
        if (isMacOs) {
            try {
                OSXAdapter.setQuitHandler(this.viewerController, this.viewerController.getClass().getDeclaredMethod("exit", null));
                OSXAdapter.setAboutHandler(this.viewerController, this.viewerController.getClass().getDeclaredMethod("showAboutDialog", null));
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error occurred while loading the OSXAdapter:", e);
            }
        }
        return menuBar;
    }

    protected KeyStroke buildKeyStroke(int keyCode, int modifiers) {
        return this.buildKeyStroke(keyCode, modifiers, false);
    }

    protected KeyStroke buildKeyStroke(int keyCode, int modifiers, boolean onRelease) {
        this.doubleCheckPropertiesManager();
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.menuitem.show.keyboard.shortcuts", true)) {
            return KeyStroke.getKeyStroke(keyCode, modifiers, onRelease);
        }
        return null;
    }

    protected int buildMnemonic(char mnemonic) {
        this.doubleCheckPropertiesManager();
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.menuitem.show.keyboard.shortcuts", true)) {
            return mnemonic;
        }
        return -1;
    }

    public JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu(this.messageBundle.getString("viewer.menu.file.label"));
        fileMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.file.mnemonic").charAt(0)));
        JMenuItem openFileMenuItem = this.buildOpenFileMenuItem();
        JMenuItem openURLMenuItem = this.buildOpenURLMenuItem();
        if (openFileMenuItem != null && openURLMenuItem != null) {
            JMenu openSubMenu = new JMenu(this.messageBundle.getString("viewer.menu.open.label"));
            openSubMenu.setIcon(new ImageIcon(Images.get("open_a_24.png")));
            openSubMenu.setDisabledIcon(new ImageIcon(Images.get("open_i_24.png")));
            openSubMenu.setRolloverIcon(new ImageIcon(Images.get("open_r_24.png")));
            this.addToMenu(openSubMenu, openFileMenuItem);
            this.addToMenu(openSubMenu, openURLMenuItem);
            this.addToMenu(fileMenu, openSubMenu);
        } else if (openFileMenuItem != null || openURLMenuItem != null) {
            this.addToMenu(fileMenu, openFileMenuItem);
            this.addToMenu(fileMenu, openURLMenuItem);
        }
        fileMenu.addSeparator();
        this.addToMenu(fileMenu, this.buildCloseMenuItem());
        this.addToMenu(fileMenu, this.buildSaveAsFileMenuItem());
        this.addToMenu(fileMenu, this.buildExportTextMenuItem());
        this.addToMenu(fileMenu, this.buildExportSVGMenuItem());
        fileMenu.addSeparator();
        this.addToMenu(fileMenu, this.buildPermissionsMenuItem());
        this.addToMenu(fileMenu, this.buildInformationMenuItem());
        fileMenu.addSeparator();
        this.addToMenu(fileMenu, this.buildPrintSetupMenuItem());
        this.addToMenu(fileMenu, this.buildPrintMenuItem());
        if (!isMacOs) {
            fileMenu.addSeparator();
            this.addToMenu(fileMenu, this.buildExitMenuItem());
        }
        return fileMenu;
    }

    public JMenuItem buildOpenFileMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.open.file.label"), this.buildKeyStroke(79, KeyEventConstants.MODIFIER_OPEN_FILE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setOpenFileMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildOpenURLMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.open.URL.label"), this.buildKeyStroke(85, KeyEventConstants.MODIFIER_OPEN_URL));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setOpenURLMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildCloseMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.close.label"), null, null, this.buildKeyStroke(87, KeyEventConstants.MODIFIER_CLOSE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setCloseMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildSaveAsFileMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.saveAs.label"), "save", "_24", this.buildKeyStroke(83, KeyEventConstants.MODIFIER_SAVE_AS, false));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setSaveAsFileMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildExportTextMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exportText.label"), null, null, null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setExportTextMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildExportSVGMenuItem() {
        JMenuItem mi = null;
        try {
            Class.forName("org.apache.batik.dom.GenericDOMImplementation");
            mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exportSVG.label"), null, null, null);
            if (this.viewerController != null && mi != null) {
                this.viewerController.setExportSVGMenuItem(mi);
            }
        }
        catch (ClassNotFoundException e) {
            logger.warning("SVG Support Not Found");
        }
        return mi;
    }

    public JMenuItem buildPermissionsMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentPermission.label"), null, null, null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setPermissionsMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildInformationMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.documentInformation.label"), null, null, null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setInformationMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildPrintSetupMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.printSetup.label"), null, null, this.buildKeyStroke(80, KeyEventConstants.MODIFIER_PRINT_SETUP, false));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setPrintSetupMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildPrintMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.print.label"), "print", "_24", this.buildKeyStroke(80, KeyEventConstants.MODIFIER_PRINT));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setPrintMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildExitMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.exit.label"), null, null, this.buildKeyStroke(81, KeyEventConstants.MODIFIER_EXIT));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setExitMenuItem(mi);
        }
        return mi;
    }

    public JMenu buildEditMenu() {
        JMenu viewMenu = new JMenu(this.messageBundle.getString("viewer.menu.edit.label"));
        viewMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.edit.mnemonic").charAt(0)));
        this.addToMenu(viewMenu, this.buildUndoMenuItem());
        this.addToMenu(viewMenu, this.buildRedoMenuItem());
        viewMenu.addSeparator();
        this.addToMenu(viewMenu, this.buildCopyMenuItem());
        this.addToMenu(viewMenu, this.buildDeleteMenuItem());
        viewMenu.addSeparator();
        this.addToMenu(viewMenu, this.buildSelectAllMenuItem());
        this.addToMenu(viewMenu, this.buildDeselectAllMenuItem());
        return viewMenu;
    }

    public JMenuItem buildUndoMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.undo.label"), null, null, this.buildKeyStroke(90, KeyEventConstants.MODIFIER_UNDO));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setUndoMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildRedoMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.redo.label"), null, null, this.buildKeyStroke(90, KeyEventConstants.MODIFIER_REDO));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setReduMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildCopyMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.copy.label"), null, null, this.buildKeyStroke(67, KeyEventConstants.MODIFIER_COPY));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setCopyMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildDeleteMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.delete.label"), null, null, this.buildKeyStroke(68, KeyEventConstants.MODIFIER_DELETE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setDeleteMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildSelectAllMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.selectAll.label"), null, null, this.buildKeyStroke(65, KeyEventConstants.MODIFIER_SELECT_ALL));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setSelectAllMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildDeselectAllMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.edit.deselectAll.label"), null, null, this.buildKeyStroke(65, KeyEventConstants.MODIFIER_DESELECT_ALL));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setDselectAllMenuItem(mi);
        }
        return mi;
    }

    public JMenu buildViewMenu() {
        JMenu viewMenu = new JMenu(this.messageBundle.getString("viewer.menu.view.label"));
        viewMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.view.mnemonic").charAt(0)));
        this.addToMenu(viewMenu, this.buildFitActualSizeMenuItem());
        this.addToMenu(viewMenu, this.buildFitPageMenuItem());
        this.addToMenu(viewMenu, this.buildFitWidthMenuItem());
        viewMenu.addSeparator();
        this.addToMenu(viewMenu, this.buildZoomInMenuItem());
        this.addToMenu(viewMenu, this.buildZoomOutMenuItem());
        viewMenu.addSeparator();
        this.addToMenu(viewMenu, this.buildRotateLeftMenuItem());
        this.addToMenu(viewMenu, this.buildRotateRightMenuItem());
        viewMenu.addSeparator();
        this.addToMenu(viewMenu, this.buildShowHideToolBarMenuItem());
        this.addToMenu(viewMenu, this.buildShowHideUtilityPaneMenuItem());
        return viewMenu;
    }

    public JMenuItem buildFitActualSizeMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.actualSize.label"), "actual_size", "_24", this.buildKeyStroke(49, KeyEventConstants.MODIFIER_FIT_ACTUAL));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setFitActualSizeMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildFitPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.fitInWindow.label"), "fit_window", "_24", this.buildKeyStroke(50, KeyEventConstants.MODIFIER_FIT_PAGE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setFitPageMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildFitWidthMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.fitWidth.label"), null, null, this.buildKeyStroke(51, KeyEventConstants.MODIFIER_FIT_WIDTH));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setFitWidthMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildZoomInMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.zoomIn.label"), "zoom_in", "_24", this.buildKeyStroke(73, KeyEventConstants.MODIFIER_ZOOM_IN, false));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setZoomInMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildZoomOutMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.zoomOut.label"), "zoom_out", "_24", this.buildKeyStroke(79, KeyEventConstants.MODIFIER_ZOOM_OUT, false));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setZoomOutMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildRotateLeftMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.rotateLeft.label"), "rotate_left", "_24", this.buildKeyStroke(76, KeyEventConstants.MODIFIER_ROTATE_LEFT));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setRotateLeftMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildRotateRightMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.view.rotateRight.label"), "rotate_right", "_24", this.buildKeyStroke(82, KeyEventConstants.MODIFIER_ROTATE_RIGHT));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setRotateRightMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildShowHideToolBarMenuItem() {
        JMenuItem mi = this.makeMenuItem("", null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setShowHideToolBarMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildShowHideUtilityPaneMenuItem() {
        JMenuItem mi = this.makeMenuItem("", null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setShowHideUtilityPaneMenuItem(mi);
        }
        return mi;
    }

    public JMenu buildDocumentMenu() {
        JMenu documentMenu = new JMenu(this.messageBundle.getString("viewer.menu.document.label"));
        documentMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.document.mnemonic").charAt(0)));
        this.addToMenu(documentMenu, this.buildFirstPageMenuItem());
        this.addToMenu(documentMenu, this.buildPreviousPageMenuItem());
        this.addToMenu(documentMenu, this.buildNextPageMenuItem());
        this.addToMenu(documentMenu, this.buildLastPageMenuItem());
        documentMenu.addSeparator();
        this.addToMenu(documentMenu, this.buildSearchMenuItem());
        this.addToMenu(documentMenu, this.buildGoToPageMenuItem());
        return documentMenu;
    }

    public JMenuItem buildFirstPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.firstPage.label"), "page_first", "_24", this.buildKeyStroke(38, KeyEventConstants.MODIFIER_FIRST_PAGE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setFirstPageMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildPreviousPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.previousPage.label"), "page_up", "_24", this.buildKeyStroke(37, KeyEventConstants.MODIFIER_PREVIOUS_PAGE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setPreviousPageMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildNextPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.nextPage.label"), "page_down", "_24", this.buildKeyStroke(39, KeyEventConstants.MODIFIER_NEXT_PAGE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setNextPageMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildLastPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.lastPage.label"), "page_last", "_24", this.buildKeyStroke(40, KeyEventConstants.MODIFIER_LAST_PAGE));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setLastPageMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildSearchMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.search.label"), this.buildKeyStroke(83, KeyEventConstants.MODIFIER_SEARCH));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setSearchMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildGoToPageMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.document.gotToPage.label"), this.buildKeyStroke(78, KeyEventConstants.MODIFIER_GOTO));
        if (this.viewerController != null && mi != null) {
            this.viewerController.setGoToPageMenuItem(mi);
        }
        return mi;
    }

    public JMenu buildWindowMenu() {
        final JMenu windowMenu = new JMenu(this.messageBundle.getString("viewer.menu.window.label"));
        windowMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.mnemonic").charAt(0)));
        this.addToMenu(windowMenu, this.buildMinimiseAllMenuItem());
        this.addToMenu(windowMenu, this.buildBringAllToFrontMenuItem());
        windowMenu.addSeparator();
        final int allowedCount = windowMenu.getItemCount();
        windowMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                for (int count = windowMenu.getItemCount(); count > allowedCount; --count) {
                    windowMenu.remove(count - 1);
                }
                SwingViewBuilder.this.buildWindowListMenuItems(windowMenu);
            }
        });
        return windowMenu;
    }

    public JMenuItem buildMinimiseAllMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.window.minAll.label"), null);
        mi.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.minAll.mnemonic").charAt(0)));
        if (this.viewerController != null) {
            this.viewerController.setMinimiseAllMenuItem(mi);
        }
        return mi;
    }

    public JMenuItem buildBringAllToFrontMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.window.frontAll.label"), null);
        mi.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.window.frontAll.mnemonic").charAt(0)));
        if (this.viewerController != null) {
            this.viewerController.setBringAllToFrontMenuItem(mi);
        }
        return mi;
    }

    public void buildWindowListMenuItems(JMenu menu) {
        if (this.viewerController != null && this.viewerController.getWindowManagementCallback() != null) {
            WindowManagementCallback winMgr = this.viewerController.getWindowManagementCallback();
            List windowDocOriginList = winMgr.getWindowDocumentOriginList(this.viewerController);
            int currWindowIndex = -1;
            int count = windowDocOriginList.size();
            if (count > 0 && windowDocOriginList.get(count - 1) instanceof Integer) {
                currWindowIndex = (Integer)windowDocOriginList.remove(--count);
            }
            this.shortenDocumentOrigins(windowDocOriginList);
            ArrayList<JMenuItem> windowListMenuItems = new ArrayList<JMenuItem>(Math.max(count, 1));
            for (int i = 0; i < count; ++i) {
                String number = Integer.toString(i + 1);
                String label = null;
                String mnemonic = null;
                try {
                    label = this.messageBundle.getString("viewer.menu.window." + number + ".label");
                    mnemonic = this.messageBundle.getString("viewer.menu.window." + number + ".mnemonic");
                }
                catch (Exception e) {
                    logger.log(Level.FINER, "Error setting viewer window window title", e);
                }
                String identifier = (String)windowDocOriginList.get(i);
                if (identifier == null) {
                    identifier = "";
                }
                String miText = label != null && label.length() > 0 ? number + "  " + identifier : "    " + identifier;
                JMenuItem mi = new JMenuItem(miText);
                if (mnemonic != null && number.length() == 1) {
                    mi.setMnemonic(this.buildMnemonic(number.charAt(0)));
                }
                if (currWindowIndex == i) {
                    mi.setEnabled(false);
                }
                menu.add(mi);
                windowListMenuItems.add(mi);
            }
            this.viewerController.setWindowListMenuItems(windowListMenuItems);
        }
    }

    protected void shortenDocumentOrigins(List<Object> windowDocOriginList) {
        for (int i = windowDocOriginList.size() - 1; i >= 0; --i) {
            int backwardSlashIndex;
            int forewardSlashIndex;
            int separatorIndex;
            int cutIndex;
            String identifier = (String)windowDocOriginList.get(i);
            if (identifier == null || (cutIndex = Math.max(separatorIndex = identifier.lastIndexOf(File.separator), Math.max(forewardSlashIndex = identifier.lastIndexOf("/"), backwardSlashIndex = identifier.lastIndexOf("\\")))) < 0) continue;
            identifier = identifier.substring(cutIndex);
            windowDocOriginList.set(i, identifier);
        }
    }

    public JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.messageBundle.getString("viewer.menu.help.label"));
        helpMenu.setMnemonic(this.buildMnemonic(this.messageBundle.getString("viewer.menu.help.mnemonic").charAt(0)));
        if (!isMacOs) {
            this.addToMenu(helpMenu, this.buildAboutMenuItem());
        }
        return helpMenu;
    }

    public JMenuItem buildAboutMenuItem() {
        JMenuItem mi = this.makeMenuItem(this.messageBundle.getString("viewer.menu.help.about.label"), null);
        if (this.viewerController != null && mi != null) {
            this.viewerController.setAboutMenuItem(mi);
        }
        return mi;
    }

    public JToolBar buildCompleteToolBar(boolean embeddableComponent) {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new ToolbarLayout(0, 0, 0));
        this.commonToolBarSetup(toolbar, true);
        this.doubleCheckPropertiesManager();
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.utility")) {
            this.addToToolBar(toolbar, this.buildUtilityToolBar(embeddableComponent, this.propertiesManager));
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.pagenav")) {
            this.addToToolBar(toolbar, this.buildPageNavigationToolBar());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.zoom")) {
            this.addToToolBar(toolbar, this.buildZoomToolBar());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.fit")) {
            this.addToToolBar(toolbar, this.buildFitToolBar());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.rotate")) {
            this.addToToolBar(toolbar, this.buildRotateToolBar());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.tool")) {
            this.addToToolBar(toolbar, this.buildToolToolBar());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.toolbar.show.annotation")) {
            this.addToToolBar(toolbar, this.buildAnnotationlToolBar());
        }
        if (isDemo) {
            this.addToToolBar(toolbar, this.buildDemoToolBar());
        }
        if (toolbar.getComponentCount() == 0) {
            toolbar = null;
        }
        if (this.viewerController != null && toolbar != null) {
            this.viewerController.setCompleteToolBar(toolbar);
        }
        return toolbar;
    }

    public JToolBar buildUtilityToolBar(boolean embeddableComponent) {
        return this.buildUtilityToolBar(embeddableComponent, null);
    }

    public JToolBar buildUtilityToolBar(boolean embeddableComponent, PropertiesManager propertiesManager) {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        if (!embeddableComponent && PropertiesManager.checkAndStoreBooleanProperty(propertiesManager, "application.toolbar.show.utility.open")) {
            this.addToToolBar(toolbar, this.buildOpenFileButton());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(propertiesManager, "application.toolbar.show.utility.save")) {
            this.addToToolBar(toolbar, this.buildSaveAsFileButton());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(propertiesManager, "application.toolbar.show.utility.print")) {
            this.addToToolBar(toolbar, this.buildPrintButton());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(propertiesManager, "application.toolbar.show.utility.search")) {
            this.addToToolBar(toolbar, this.buildSearchButton());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(propertiesManager, "application.toolbar.show.utility.upane")) {
            this.addToToolBar(toolbar, this.buildShowHideUtilityPaneButton());
        }
        if (toolbar.getComponentCount() == 0) {
            return null;
        }
        return toolbar;
    }

    public JButton buildOpenFileButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.open.label"), this.messageBundle.getString("viewer.toolbar.open.tooltip"), "open", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setOpenFileButton(btn);
        }
        return btn;
    }

    public JButton buildSaveAsFileButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.saveAs.label"), this.messageBundle.getString("viewer.toolbar.saveAs.tooltip"), "save", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setSaveAsFileButton(btn);
        }
        return btn;
    }

    public JButton buildPrintButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.print.label"), this.messageBundle.getString("viewer.toolbar.print.tooltip"), "print", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPrintButton(btn);
        }
        return btn;
    }

    public JButton buildSearchButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.search.label"), this.messageBundle.getString("viewer.toolbar.search.tooltip"), "search", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setSearchButton(btn);
        }
        return btn;
    }

    public JToggleButton buildShowHideUtilityPaneButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.utilityPane.label"), this.messageBundle.getString("viewer.toolbar.utilityPane.tooltip"), "utility_pane", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setShowHideUtilityPaneButton(btn);
        }
        return btn;
    }

    public JToolBar buildPageNavigationToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildFirstPageButton());
        this.addToToolBar(toolbar, this.buildPreviousPageButton());
        this.addToToolBar(toolbar, this.buildCurrentPageNumberTextField());
        this.addToToolBar(toolbar, this.buildNumberOfPagesLabel());
        this.addToToolBar(toolbar, this.buildNextPageButton());
        this.addToToolBar(toolbar, this.buildLastPageButton());
        return toolbar;
    }

    public JButton buildFirstPageButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.firstPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.firstPage.tooltip"), "first", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFirstPageButton(btn);
        }
        return btn;
    }

    public JButton buildPreviousPageButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.previousPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.previousPage.tooltip"), "back", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPreviousPageButton(btn);
        }
        return btn;
    }

    public JButton buildNextPageButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.nextPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.nextPage.tooltip"), "forward", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setNextPageButton(btn);
        }
        return btn;
    }

    public JButton buildLastPageButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.navigation.lastPage.label"), this.messageBundle.getString("viewer.toolbar.navigation.lastPage.tooltip"), "last", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setLastPageButton(btn);
        }
        return btn;
    }

    public JTextField buildCurrentPageNumberTextField() {
        JTextField pageNumberTextField = new JTextField("", 3);
        pageNumberTextField.setToolTipText(this.messageBundle.getString("viewer.toolbar.navigation.current.tooltip"));
        pageNumberTextField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        pageNumberTextField.addKeyListener(new PageNumberTextFieldKeyListener());
        if (this.viewerController != null) {
            this.viewerController.setCurrentPageNumberTextField(pageNumberTextField);
        }
        return pageNumberTextField;
    }

    public JLabel buildNumberOfPagesLabel() {
        JLabel lbl = new JLabel();
        lbl.setToolTipText(this.messageBundle.getString("viewer.toolbar.navigation.pages.tooltip"));
        if (this.viewerController != null) {
            this.viewerController.setNumberOfPagesLabel(lbl);
        }
        return lbl;
    }

    public JToolBar buildZoomToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildZoomOutButton());
        this.addToToolBar(toolbar, this.buildZoomCombBox());
        this.addToToolBar(toolbar, this.buildZoomInButton());
        return toolbar;
    }

    public JButton buildZoomOutButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.zoom.out.label"), this.messageBundle.getString("viewer.toolbar.zoom.out.tooltip"), "zoom_out", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setZoomOutButton(btn);
        }
        return btn;
    }

    public JComboBox buildZoomCombBox() {
        this.doubleCheckPropertiesManager();
        this.zoomLevels = PropertiesManager.checkAndStoreFloatArrayProperty(this.propertiesManager, "application.zoom.range.default", this.zoomLevels);
        JComboBox<String> tmp = new JComboBox<String>();
        tmp.setToolTipText(this.messageBundle.getString("viewer.toolbar.zoom.tooltip"));
        tmp.setPreferredSize(new Dimension(75, tmp.getHeight()));
        for (float zoomLevel : this.zoomLevels) {
            tmp.addItem(NumberFormat.getPercentInstance().format(zoomLevel));
        }
        tmp.setEditable(true);
        if (this.viewerController != null) {
            this.viewerController.setZoomComboBox(tmp, this.zoomLevels);
        }
        return tmp;
    }

    public JButton buildZoomInButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.zoom.in.label"), this.messageBundle.getString("viewer.toolbar.zoom.in.tooltip"), "zoom_in", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setZoomInButton(btn);
        }
        return btn;
    }

    public JToolBar buildFitToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildFitActualSizeButton());
        this.addToToolBar(toolbar, this.buildFitPageButton());
        this.addToToolBar(toolbar, this.buildFitWidthButton());
        return toolbar;
    }

    public JToggleButton buildFitActualSizeButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.actualsize.label"), this.messageBundle.getString("viewer.toolbar.pageFit.actualsize.tooltip"), "actual_size", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFitActualSizeButton(btn);
        }
        return btn;
    }

    public JToggleButton buildFitPageButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.fitWindow.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fitWindow.tooltip"), "fit_window", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFitHeightButton(btn);
        }
        return btn;
    }

    public JToggleButton buildFontEngineButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.fontEngine.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fontEngine.tooltip"), "font-engine", 118, 25, this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFontEngineButton(btn);
        }
        return btn;
    }

    public JToggleButton buildFitWidthButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageFit.fitWidth.label"), this.messageBundle.getString("viewer.toolbar.pageFit.fitWidth.tooltip"), "fit_width", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFitWidthButton(btn);
        }
        return btn;
    }

    public JToolBar buildRotateToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildRotateRightButton());
        this.addToToolBar(toolbar, this.buildRotateLeftButton());
        return toolbar;
    }

    public JButton buildRotateLeftButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.rotation.left.label"), this.messageBundle.getString("viewer.toolbar.rotation.left.tooltip"), "rotate_left", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setRotateLeftButton(btn);
        }
        return btn;
    }

    public JButton buildRotateRightButton() {
        JButton btn = this.makeToolbarButton(this.messageBundle.getString("viewer.toolbar.rotation.right.label"), this.messageBundle.getString("viewer.toolbar.rotation.right.tooltip"), "rotate_right", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setRotateRightButton(btn);
        }
        return btn;
    }

    public JToolBar buildToolToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildPanToolButton());
        this.addToToolBar(toolbar, this.buildTextSelectToolButton());
        this.addToToolBar(toolbar, this.buildZoomInToolButton());
        this.addToToolBar(toolbar, this.buildZoomOutToolButton());
        return toolbar;
    }

    public JToolBar buildAnnotationlToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildSelectToolButton("_32"));
        this.addToToolBar(toolbar, this.buildHighlightAnnotationToolButton("_32"));
        this.addToToolBar(toolbar, this.buildTextAnnotationToolButton("_32"));
        return toolbar;
    }

    public JToolBar buildAnnotationUtilityToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, true);
        this.addToToolBar(toolbar, this.buildHighlightAnnotationUtilityToolButton("_24"));
        this.addToToolBar(toolbar, this.buildStrikeOutAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildUnderlineAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildLineAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildLinkAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildLineArrowAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildSquareAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildCircleAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildInkAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildFreeTextAnnotationToolButton());
        this.addToToolBar(toolbar, this.buildTextAnnotationUtilityToolButton("_24"));
        return toolbar;
    }

    public JToolBar buildDemoToolBar() {
        JToolBar toolbar = new JToolBar();
        this.commonToolBarSetup(toolbar, false);
        this.addToToolBar(toolbar, this.buildFontEngineButton());
        return toolbar;
    }

    public JToggleButton buildPanToolButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.pan.label"), this.messageBundle.getString("viewer.toolbar.tool.pan.tooltip"), "pan", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPanToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildTextSelectToolButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.text.label"), this.messageBundle.getString("viewer.toolbar.tool.text.tooltip"), "selection_text", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setTextSelectToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildSelectToolButton(String imageSize) {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.select.label"), this.messageBundle.getString("viewer.toolbar.tool.select.tooltip"), "select", imageSize, this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setSelectToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildLinkAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.link.label"), this.messageBundle.getString("viewer.toolbar.tool.link.tooltip"), "link_annot", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setLinkAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildHighlightAnnotationToolButton(String imageSize) {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.highlight.label"), this.messageBundle.getString("viewer.toolbar.tool.highlight.tooltip"), "highlight_annot", imageSize, this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setHighlightAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildHighlightAnnotationUtilityToolButton(String imageSize) {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.highlight.label"), this.messageBundle.getString("viewer.toolbar.tool.highlight.tooltip"), "highlight_annot", imageSize, this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setHighlightAnnotationUtilityToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildStrikeOutAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.strikeOut.label"), this.messageBundle.getString("viewer.toolbar.tool.strikeOut.tooltip"), "strikeout", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setStrikeOutAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildUnderlineAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.underline.label"), this.messageBundle.getString("viewer.toolbar.tool.underline.tooltip"), "underline", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setUnderlineAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildLineAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.line.label"), this.messageBundle.getString("viewer.toolbar.tool.line.tooltip"), "line", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setLineAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildLineArrowAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.lineArrow.label"), this.messageBundle.getString("viewer.toolbar.tool.lineArrow.tooltip"), "arrow", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setLineArrowAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildSquareAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.rectangle.label"), this.messageBundle.getString("viewer.toolbar.tool.rectangle.tooltip"), "square", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setSquareAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildCircleAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.circle.label"), this.messageBundle.getString("viewer.toolbar.tool.circle.tooltip"), "circle", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setCircleAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildInkAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.ink.label"), this.messageBundle.getString("viewer.toolbar.tool.ink.tooltip"), "ink", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setInkAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildFreeTextAnnotationToolButton() {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.freeText.label"), this.messageBundle.getString("viewer.toolbar.tool.freeText.tooltip"), "freetext_annot", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setFreeTextAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildTextAnnotationToolButton(String imageSize) {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.textAnno.label"), this.messageBundle.getString("viewer.toolbar.tool.textAnno.tooltip"), "text_annot", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setTextAnnotationToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildTextAnnotationUtilityToolButton(String imageSize) {
        JToggleButton btn = this.makeToolbarToggleButtonSmall(this.messageBundle.getString("viewer.toolbar.tool.textAnno.label"), this.messageBundle.getString("viewer.toolbar.tool.textAnno.tooltip"), "text_annot", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setTextAnnotationUtilityToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildZoomInToolButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.zoomMarquis.label"), this.messageBundle.getString("viewer.toolbar.tool.zoomMarquis.tooltip"), "zoom_marquis", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setZoomInToolButton(btn);
        }
        return btn;
    }

    public JToggleButton buildZoomOutToolButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.tool.zoomDynamic.label"), this.messageBundle.getString("viewer.toolbar.tool.zoomDynamic.tooltip"), "zoom_dynamic", "_32", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setZoomDynamicToolButton(btn);
        }
        return btn;
    }

    public JSplitPane buildUtilityAndDocumentSplitPane(boolean embeddableComponent) {
        JSplitPane splitpane = new JSplitPane(1);
        splitpane.setOneTouchExpandable(false);
        splitpane.setDividerSize(8);
        splitpane.setContinuousLayout(true);
        splitpane.setLeftComponent(this.buildUtilityTabbedPane());
        DocumentViewController viewController = this.viewerController.getDocumentViewController();
        this.viewerController.setIsEmbeddedComponent(embeddableComponent);
        splitpane.getActionMap().getParent().remove("toggleFocus");
        splitpane.setRightComponent(viewController.getViewContainer());
        int dividerLocation = PropertiesManager.checkAndStoreIntegerProperty(this.propertiesManager, "application.divider.location", 260);
        splitpane.setDividerLocation(dividerLocation);
        if (this.viewerController != null) {
            this.viewerController.setUtilityAndDocumentSplitPane(splitpane);
        }
        return splitpane;
    }

    public JTabbedPane buildUtilityTabbedPane() {
        JTabbedPane utilityTabbedPane = new JTabbedPane();
        utilityTabbedPane.setPreferredSize(new Dimension(250, 400));
        this.doubleCheckPropertiesManager();
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.utilitypane.show.bookmarks")) {
            utilityTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.bookmarks.tab.title"), this.buildOutlineComponents());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.utilitypane.show.search")) {
            utilityTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.search.tab.title"), this.buildSearchPanel());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.utilitypane.show.thumbs")) {
            utilityTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.thumbs.tab.title"), this.buildThumbsPanel());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.utilitypane.show.layers")) {
            utilityTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.layers.tab.title"), this.buildLayersComponents());
        }
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.utilitypane.show.annotation")) {
            utilityTabbedPane.add(this.messageBundle.getString("viewer.utilityPane.annotation.tab.title"), this.buildAnnotationPanel());
        }
        if (utilityTabbedPane.getComponentCount() == 0) {
            utilityTabbedPane = null;
        }
        if (this.viewerController != null) {
            this.viewerController.setUtilityTabbedPane(utilityTabbedPane);
        }
        return utilityTabbedPane;
    }

    public JComponent buildOutlineComponents() {
        OutlinesTree tree = new OutlinesTree();
        JScrollPane scroll = new JScrollPane(tree);
        if (this.viewerController != null) {
            this.viewerController.setOutlineComponents(tree, scroll);
        }
        return scroll;
    }

    public ThumbnailsPanel buildThumbsPanel() {
        ThumbnailsPanel thumbsPanel = new ThumbnailsPanel(this.viewerController, this.propertiesManager);
        if (this.viewerController != null) {
            this.viewerController.setThumbnailsPanel(thumbsPanel);
        }
        return thumbsPanel;
    }

    public LayersPanel buildLayersComponents() {
        LayersPanel layersPanel = new LayersPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setLayersPanel(layersPanel);
        }
        return layersPanel;
    }

    public SearchPanel buildSearchPanel() {
        SearchPanel searchPanel = new SearchPanel(this.viewerController);
        if (this.viewerController != null) {
            this.viewerController.setSearchPanel(searchPanel);
        }
        return searchPanel;
    }

    public AnnotationPanel buildAnnotationPanel() {
        AnnotationPanel annotationPanel = new AnnotationPanel(this.viewerController, this.propertiesManager);
        annotationPanel.setAnnotationUtilityToolbar(this.buildAnnotationUtilityToolBar());
        if (this.viewerController != null) {
            this.viewerController.setAnnotationPanel(annotationPanel);
        }
        return annotationPanel;
    }

    public JPanel buildStatusPanel() {
        if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.statusbar")) {
            JPanel statusPanel = new JPanel(new BorderLayout());
            if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.statusbar.show.statuslabel")) {
                JPanel pgPanel = new JPanel();
                JLabel lbl = new JLabel(" ");
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                pgPanel.add(lbl);
                statusPanel.add((Component)pgPanel, "West");
                if (this.viewerController != null) {
                    this.viewerController.setStatusLabel(lbl);
                }
            }
            JPanel viewPanel = new JPanel();
            if (PropertiesManager.checkAndStoreBooleanProperty(this.propertiesManager, "application.statusbar.show.viewmode")) {
                viewPanel.add(this.buildPageViewSinglePageNonConToggleButton());
                viewPanel.add(this.buildPageViewSinglePageConToggleButton());
                viewPanel.add(this.buildPageViewFacingPageNonConToggleButton());
                viewPanel.add(this.buildPageViewFacingPageConToggleButton());
            }
            statusPanel.add((Component)viewPanel, "Center");
            viewPanel.setLayout(new ToolbarLayout(2, 0, 1));
            JLabel lbl2 = new JLabel(" ");
            lbl2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            statusPanel.add((Component)lbl2, "East");
            return statusPanel;
        }
        return null;
    }

    public JToggleButton buildPageViewSinglePageConToggleButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.continuous.singlePage.label"), this.messageBundle.getString("viewer.toolbar.pageView.continuous.singlePage.tooltip"), "single_page_column", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPageViewSinglePageConButton(btn);
        }
        return btn;
    }

    public JToggleButton buildPageViewFacingPageConToggleButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.continuous.facingPage.label"), this.messageBundle.getString("viewer.toolbar.pageView.continuous.facingPage.tooltip"), "two_page_column", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPageViewFacingPageConButton(btn);
        }
        return btn;
    }

    public JToggleButton buildPageViewSinglePageNonConToggleButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.singlePage.label"), this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.singlePage.tooltip"), "single_page", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPageViewSinglePageNonConButton(btn);
        }
        return btn;
    }

    public JToggleButton buildPageViewFacingPageNonConToggleButton() {
        JToggleButton btn = this.makeToolbarToggleButton(this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.facingPage.label"), this.messageBundle.getString("viewer.toolbar.pageView.nonContinuous.facingPage.tooltip"), "two_page", "_24", this.buttonFont);
        if (this.viewerController != null && btn != null) {
            this.viewerController.setPageViewFacingPageNonConButton(btn);
        }
        return btn;
    }

    protected JButton makeToolbarButton(String title, String toolTip, String imageName, String imageSize, Font font) {
        JButton tmp = new JButton(this.showButtonText ? title : "");
        tmp.setFont(font);
        tmp.setToolTipText(toolTip);
        tmp.setPreferredSize(new Dimension(32, 32));
        try {
            tmp.setIcon(new ImageIcon(Images.get(imageName + "_a" + imageSize + ".png")));
            tmp.setPressedIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
            tmp.setRolloverIcon(new ImageIcon(Images.get(imageName + "_r" + imageSize + ".png")));
            tmp.setDisabledIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        tmp.setRolloverEnabled(true);
        tmp.setBorderPainted(false);
        tmp.setContentAreaFilled(false);
        tmp.setFocusPainted(true);
        return tmp;
    }

    protected JToggleButton makeToolbarToggleButton(String title, String toolTip, String imageName, String imageSize, Font font) {
        JToggleButton tmp = new JToggleButton(this.showButtonText ? title : "");
        tmp.setFont(font);
        tmp.setToolTipText(toolTip);
        tmp.setPreferredSize(new Dimension(32, 32));
        tmp.setRolloverEnabled(true);
        try {
            tmp.setIcon(new ImageIcon(Images.get(imageName + "_a" + imageSize + ".png")));
            tmp.setPressedIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
            tmp.setRolloverIcon(new ImageIcon(Images.get(imageName + "_r" + imageSize + ".png")));
            tmp.setDisabledIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        tmp.setBorder(BorderFactory.createEmptyBorder());
        tmp.setContentAreaFilled(false);
        tmp.setFocusPainted(true);
        return tmp;
    }

    protected JToggleButton makeToolbarToggleButtonSmall(String title, String toolTip, String imageName, String imageSize, Font font) {
        JToggleButton tmp = new JToggleButton(this.showButtonText ? title : "");
        tmp.setFont(font);
        tmp.setToolTipText(toolTip);
        tmp.setPreferredSize(new Dimension(24, 24));
        try {
            tmp.setIcon(new ImageIcon(Images.get(imageName + "_a" + imageSize + ".png")));
            tmp.setPressedIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
            tmp.setRolloverIcon(new ImageIcon(Images.get(imageName + "_r" + imageSize + ".png")));
            tmp.setDisabledIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        tmp.setBorder(BorderFactory.createEmptyBorder());
        tmp.setContentAreaFilled(false);
        tmp.setRolloverEnabled(true);
        tmp.setFocusPainted(true);
        return tmp;
    }

    protected JToggleButton makeToolbarToggleButton(String title, String toolTip, Font font) {
        JToggleButton tmp = new JToggleButton(this.showButtonText ? title : "");
        tmp.setFont(font);
        tmp.setToolTipText(toolTip);
        tmp.setPreferredSize(new Dimension(30, 30));
        tmp.setText(title);
        tmp.setFocusPainted(true);
        return tmp;
    }

    protected JToggleButton makeToolbarToggleButton(String title, String toolTip, String imageName, int imageWidth, int imageHeight, Font font) {
        JToggleButton tmp = new JToggleButton(this.showButtonText ? title : "");
        tmp.setFont(font);
        tmp.setToolTipText(toolTip);
        tmp.setRolloverEnabled(false);
        tmp.setPreferredSize(new Dimension(imageWidth, imageHeight));
        try {
            tmp.setIcon(new ImageIcon(Images.get(imageName + "_d.png")));
            tmp.setPressedIcon(new ImageIcon(Images.get(imageName + "_d.png")));
            tmp.setSelectedIcon(new ImageIcon(Images.get(imageName + "_n.png")));
            tmp.setDisabledIcon(new ImageIcon(Images.get(imageName + "_n.png")));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        tmp.setBorderPainted(false);
        tmp.setBorder(BorderFactory.createEmptyBorder());
        tmp.setContentAreaFilled(false);
        tmp.setFocusPainted(false);
        return tmp;
    }

    protected JMenuItem makeMenuItem(String text, KeyStroke accel) {
        JMenuItem jmi = new JMenuItem(text);
        if (accel != null) {
            jmi.setAccelerator(accel);
        }
        return jmi;
    }

    protected JMenuItem makeMenuItem(String text, String imageName, String imageSize, KeyStroke accel) {
        JMenuItem jmi = new JMenuItem(text);
        if (imageName != null) {
            try {
                jmi.setIcon(new ImageIcon(Images.get(imageName + "_a." + imageSize + "png")));
                jmi.setDisabledIcon(new ImageIcon(Images.get(imageName + "_i" + imageSize + ".png")));
                jmi.setRolloverIcon(new ImageIcon(Images.get(imageName + "_r" + imageSize + ".png")));
            }
            catch (NullPointerException e) {}
        } else {
            jmi.setIcon(new ImageIcon(Images.get("menu_spacer.gif")));
            jmi.setDisabledIcon(new ImageIcon(Images.get("menu_spacer.gif")));
            jmi.setRolloverIcon(new ImageIcon(Images.get("menu_spacer.gif")));
        }
        jmi.setBorder(BorderFactory.createEmptyBorder());
        jmi.setContentAreaFilled(false);
        jmi.setFocusPainted(true);
        if (accel != null) {
            jmi.setAccelerator(accel);
        }
        return jmi;
    }

    protected void commonToolBarSetup(JToolBar toolbar, boolean isMainToolBar) {
        if (!isMainToolBar) {
            toolbar.requestFocus();
            toolbar.setRollover(true);
        }
        if (this.toolbarStyle == 2) {
            toolbar.setFloatable(false);
            if (!isMainToolBar) {
                if (this.haveMadeAToolBar) {
                    toolbar.addSeparator();
                }
                this.haveMadeAToolBar = true;
            }
        }
    }

    protected void doubleCheckPropertiesManager() {
        if (this.propertiesManager == null && this.viewerController != null && this.viewerController.getWindowManagementCallback() != null) {
            this.propertiesManager = this.viewerController.getWindowManagementCallback().getProperties();
        }
    }

    protected void overrideHighlightColor() {
        if (Defs.sysProperty("org.icepdf.core.views.page.text.highlightColor") == null) {
            String newColor;
            this.doubleCheckPropertiesManager();
            if (this.propertiesManager != null && (newColor = this.propertiesManager.getString("org.icepdf.core.views.page.text.highlightColor", null)) != null) {
                Defs.setSystemProperty("org.icepdf.core.views.page.text.highlightColor", newColor);
            }
        }
    }

    protected Font buildButtonFont() {
        return new Font("Helvetica", 0, 9);
    }

    protected void addToToolBar(JToolBar toolbar, JComponent comp) {
        if (comp != null) {
            toolbar.add(comp);
        }
    }

    protected void addToMenu(JMenu menu, JMenuItem mi) {
        if (mi != null) {
            menu.add(mi);
        }
    }

    protected void addToMenuBar(JMenuBar menuBar, JMenu menu) {
        if (menu != null) {
            menuBar.add(menu);
        }
    }
}

