/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.ri.common.PrintJobWatcher;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.DocumentViewController;

public class PrintHelper
implements Printable {
    private static final Logger logger = Logger.getLogger(PrintHelper.class.toString());
    private DocumentViewController viewController;
    private PageTree pageTree;
    private float userRotation;
    private boolean printFitToMargin;
    private int printingCurrentPage;
    private int totalPagesToPrint;
    private boolean paintAnnotation = true;
    private boolean paintSearchHighlight = true;
    private static PrintService[] services;
    private PrintService printService;
    private HashDocAttributeSet docAttributeSet;
    private HashPrintRequestAttributeSet printRequestAttributeSet;
    private static String waterMark;
    private static Rectangle2D waterMarkBounds;
    private static BufferedImage waterMarkRaster;

    public PrintHelper(DocumentViewController viewController, PageTree pageTree) {
        this(viewController, pageTree, MediaSizeName.NA_LETTER, PrintQuality.DRAFT);
    }

    public PrintHelper(DocumentViewController viewController, PageTree pageTree, MediaSizeName paperSizeName, PrintQuality printQuality) {
        this.viewController = viewController;
        this.pageTree = pageTree;
        this.userRotation = this.viewController.getRotation();
        services = this.lookForPrintServices();
        this.printRequestAttributeSet = new HashPrintRequestAttributeSet();
        this.docAttributeSet = new HashDocAttributeSet();
        this.printRequestAttributeSet.add(printQuality);
        this.printRequestAttributeSet.add(paperSizeName);
        this.docAttributeSet.add(paperSizeName);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(paperSizeName);
        float[] size = mediaSize.getSize(25400);
        this.printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, size[0], size[1], 25400));
        this.docAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, size[0], size[1], 25400));
        this.setupPrintService(0, this.pageTree.getNumberOfPages(), 1, true, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Paper Size: " + paperSizeName.getName() + " " + size[0] + " x " + size[1]);
        }
    }

    public PrintHelper(DocumentViewController viewController, PageTree pageTree, HashDocAttributeSet docAttributeSet, HashPrintRequestAttributeSet printRequestAttributeSet) {
        this.viewController = viewController;
        this.pageTree = pageTree;
        this.userRotation = this.viewController.getRotation();
        this.docAttributeSet = docAttributeSet;
        this.printRequestAttributeSet = printRequestAttributeSet;
        services = this.lookForPrintServices();
        this.setupPrintService(0, this.pageTree.getNumberOfPages(), 1, true, false);
    }

    public boolean setupPrintService(int startPage, int endPage, int copies, boolean shrinkToPrintableArea, boolean showPrintDialog) {
        this.printFitToMargin = shrinkToPrintableArea;
        this.printRequestAttributeSet.add(new PageRanges(startPage + 1, endPage + 1));
        this.printRequestAttributeSet.add(new Copies(copies));
        if (showPrintDialog) {
            this.printService = this.getSetupDialog();
            return this.printService != null;
        }
        return true;
    }

    public void setupPrintService(PrintService printService, int startPage, int endPage, int copies, boolean shrinkToPrintableArea) {
        this.printFitToMargin = shrinkToPrintableArea;
        this.printRequestAttributeSet.add(new PageRanges(startPage + 1, endPage + 1));
        this.printRequestAttributeSet.add(new Copies(copies));
        this.printService = printService;
    }

    public void setupPrintService(PrintService printService, HashPrintRequestAttributeSet printRequestAttributeSet, boolean shrinkToPrintableArea) {
        this.printFitToMargin = shrinkToPrintableArea;
        this.printRequestAttributeSet = printRequestAttributeSet;
        this.printService = printService;
    }

    public PrintHelper(SwingController controller) {
        this(controller.getDocumentViewController(), controller.getPageTree());
    }

    public void showPrintSetupDialog() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.printService == null && services != null && services.length > 0 && services[0] != null) {
            this.printService = services[0];
        }
        try {
            pj.setPrintService(this.printService);
            pj.pageDialog(this.printRequestAttributeSet);
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error creating page setup dialog.", e);
        }
    }

    public int getCurrentPage() {
        return this.printingCurrentPage;
    }

    public int getNumberOfPages() {
        return this.totalPagesToPrint;
    }

    public boolean isPrintFitToMargin() {
        return this.printFitToMargin;
    }

    public float getUserRotation() {
        return this.userRotation;
    }

    public HashDocAttributeSet getDocAttributeSet() {
        return this.docAttributeSet;
    }

    public HashPrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    @Override
    public int print(Graphics printGraphics, PageFormat pageFormat, int pageIndex) {
        if (this.printingCurrentPage != pageIndex) {
            this.printingCurrentPage = pageIndex + 1;
        }
        if (pageIndex < 0 || pageIndex >= this.pageTree.getNumberOfPages()) {
            return 1;
        }
        Page currentPage = this.pageTree.getPage(pageIndex);
        currentPage.init();
        PDimension pageDim = currentPage.getSize(this.userRotation);
        float pageWidth = pageDim.getWidth();
        float pageHeight = pageDim.getHeight();
        float zoomFactor = 1.0f;
        Point imageablePrintLocation = new Point();
        float rotation = this.userRotation;
        boolean isDefaultRotation = true;
        if (pageWidth > pageHeight && pageFormat.getOrientation() == 1) {
            isDefaultRotation = false;
            rotation -= 90.0f;
        }
        if (this.printFitToMargin) {
            Dimension imageablePrintSize = isDefaultRotation ? new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()) : new Dimension((int)pageFormat.getImageableHeight(), (int)pageFormat.getImageableWidth());
            float zw = (float)imageablePrintSize.width / pageWidth;
            float zh = (float)imageablePrintSize.height / pageHeight;
            zoomFactor = Math.min(zw, zh);
            imageablePrintLocation.x = (int)pageFormat.getImageableX();
            imageablePrintLocation.y = (int)pageFormat.getImageableY();
        }
        printGraphics.translate(imageablePrintLocation.x, imageablePrintLocation.y);
        currentPage.paint(printGraphics, 2, 2, rotation, zoomFactor, this.paintAnnotation, this.paintSearchHighlight);
        return 0;
    }

    public void print() throws PrintException {
        if (this.printService == null && services != null && services.length > 0 && services[0] != null) {
            this.printService = services[0];
        }
        if (this.printService != null) {
            this.calculateTotalPagesToPrint();
            this.printService.createPrintJob().print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.printRequestAttributeSet);
        } else {
            logger.fine("No print could be found to print to.");
        }
    }

    public CancelablePrintJob cancelablePrint() throws PrintException {
        if (this.printService == null && services != null && services.length > 0 && services[0] != null) {
            this.printService = services[0];
        }
        if (this.printService != null) {
            this.calculateTotalPagesToPrint();
            DocPrintJob printerJob = this.printService.createPrintJob();
            printerJob.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.printRequestAttributeSet);
            return (CancelablePrintJob)printerJob;
        }
        return null;
    }

    public void print(PrintJobWatcher printJobWatcher) throws PrintException {
        if (this.printService == null && services != null && services.length > 0 && services[0] != null) {
            this.printService = services[0];
        }
        if (this.printService != null) {
            this.calculateTotalPagesToPrint();
            DocPrintJob printerJob = this.printService.createPrintJob();
            printJobWatcher.setPrintJob(printerJob);
            printerJob.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.printRequestAttributeSet);
            printJobWatcher.waitForDone();
        } else {
            logger.fine("No print could be found to print to.");
        }
    }

    private void createWatermark(Graphics printGraphics, Page currentPage) {
        Rectangle2D.Double bounds = currentPage.getBoundingBox(this.userRotation);
        Graphics2D g2 = (Graphics2D)printGraphics;
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        AffineTransform at2 = currentPage.getPageTransform(2, this.userRotation, 1.0f);
        g2.transform(at2);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f));
        g2.setFont(new Font("SansSerif", 1, 14));
        g2.drawString(waterMark, (int)bounds.getMinX() + 20, (int)bounds.getMinY() + 20);
        g2.drawString(waterMark, (int)bounds.getMinX() + 20, (int)bounds.getMaxY() - 20);
        g2.drawString(waterMark, (int)bounds.getMaxX() - 140, (int)bounds.getMaxY() - 20);
        g2.drawString(waterMark, (int)bounds.getMaxX() - 140, (int)bounds.getMinY() + 20);
    }

    private PrintService getSetupDialog() {
        int offset = 50;
        Window window = SwingUtilities.getWindowAncestor(this.viewController.getViewContainer());
        GraphicsConfiguration graphicsConfiguration = window == null ? null : window.getGraphicsConfiguration();
        return ServiceUI.printDialog(graphicsConfiguration, this.viewController.getViewContainer().getX() + 50, this.viewController.getViewContainer().getY() + 50, services, services[0], DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.printRequestAttributeSet);
    }

    private void calculateTotalPagesToPrint() {
        PageRanges pageRanges = (PageRanges)this.printRequestAttributeSet.get(PageRanges.class);
        this.totalPagesToPrint = 0;
        for (int[] ranges : pageRanges.getMembers()) {
            int start = ranges[0];
            int end = ranges[1];
            if (start < 1) {
                start = 1;
            }
            if (end > this.pageTree.getNumberOfPages()) {
                end = this.pageTree.getNumberOfPages();
            }
            this.totalPagesToPrint += end - start + 1;
        }
    }

    private PrintService[] lookForPrintServices() {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultService != null && services.length > 1) {
            int max = services.length;
            for (int i = 1; i < max; ++i) {
                PrintService printService = services[i];
                if (!((Object)printService).equals(defaultService)) continue;
                PrintService tmp = services[0];
                services[0] = defaultService;
                services[i] = tmp;
                break;
            }
        }
        return services;
    }

    public boolean isPaintAnnotation() {
        return this.paintAnnotation;
    }

    public void setPaintAnnotation(boolean paintAnnotation) {
        this.paintAnnotation = paintAnnotation;
    }

    public boolean isPaintSearchHighlight() {
        return this.paintSearchHighlight;
    }

    public void setPaintSearchHighlight(boolean paintSearchHighlight) {
        this.paintSearchHighlight = paintSearchHighlight;
    }
}

