/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class PageNumberTextFieldInputVerifier
extends InputVerifier {
    static final int maxLength = 4;

    @Override
    public boolean verify(JComponent comp) {
        boolean returnValue = true;
        JTextField textField = (JTextField)comp;
        String content = textField.getText();
        if (content.length() != 0 && content.length() < 4) {
            try {
                Integer.parseInt(textField.getText());
            }
            catch (NumberFormatException e) {
                returnValue = false;
            }
        } else if (content.length() > 0) {
            textField.setText(content.substring(0, 4));
        } else {
            textField.setText("");
        }
        return returnValue;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean valid = super.shouldYieldFocus(input);
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
        }
        return valid;
    }
}

