/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.functions.Function;

public class Function_0
extends Function {
    private static final Logger logger = Logger.getLogger(Function_0.class.toString());
    public static final Name SIZE_KEY = new Name("Size");
    public static final Name BITSPERSAMPLE_KEY = new Name("BitsPerSample");
    public static final Name ENCODE_KEY = new Name("Encode");
    public static final Name DECODE_KEY = new Name("Decode");
    private int[] size;
    private int bitspersample;
    private int order;
    private float[] encode;
    private float[] decode;
    private byte[] bytes;

    Function_0(Dictionary d) {
        super(d);
        int i;
        List s = (List)d.getObject(SIZE_KEY);
        this.size = new int[s.size()];
        for (int i2 = 0; i2 < s.size(); ++i2) {
            this.size[i2] = (int)((Number)s.get(i2)).floatValue();
        }
        this.bitspersample = d.getInt(BITSPERSAMPLE_KEY);
        List enc = (List)d.getObject(ENCODE_KEY);
        this.encode = new float[this.size.length * 2];
        if (enc != null) {
            for (i = 0; i < this.size.length * 2; ++i) {
                this.encode[i] = ((Number)enc.get(i)).floatValue();
            }
        } else {
            for (i = 0; i < this.size.length; ++i) {
                this.encode[2 * i] = 0.0f;
                this.encode[2 * i + 1] = this.size[i] - 1;
            }
        }
        List dec = (List)d.getObject(DECODE_KEY);
        this.decode = new float[this.range.length];
        if (dec != null) {
            for (int i3 = 0; i3 < this.range.length; ++i3) {
                this.decode[i3] = ((Number)dec.get(i3)).floatValue();
            }
        } else {
            System.arraycopy(this.range, 0, this.decode, 0, this.range.length);
        }
        Stream stream = (Stream)d;
        this.bytes = stream.getDecodedStreamBytes(0);
    }

    @Override
    public float[] calculate(float[] x) {
        int n = this.range.length / 2;
        float[] y = new float[n];
        try {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.min(Math.max(x[i], this.domain[2 * i]), this.domain[2 * i + 1]);
                float e = Function_0.interpolate(x[i], this.domain[2 * i], this.domain[2 * i + 1], this.encode[2 * i], this.encode[2 * i + 1]);
                e = Math.min(Math.max(e, 0.0f), (float)(this.size[i] - 1));
                int e1 = (int)Math.floor(e);
                int e2 = (int)Math.ceil(e);
                for (int j = 0; j < n; ++j) {
                    int b1 = this.bytes[e1 * n + j] & 0xFF;
                    int b2 = this.bytes[e2 * n + j] & 0xFF;
                    float r = ((float)b1 + (float)b2) / 2.0f;
                    r = Function_0.interpolate(r, 0.0f, (float)Math.pow(2.0, this.bitspersample) - 1.0f, this.decode[2 * j], this.decode[2 * j + 1]);
                    r = Math.min(Math.max(r, this.range[2 * j]), this.range[2 * j + 1]);
                    int index = i * n + j;
                    if (index >= y.length) continue;
                    y[index] = r;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error calculating function 0 values", e);
        }
        return y;
    }
}

