/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;

public class ZeroPaddedInputStream
extends InputStream {
    private InputStream in;

    public ZeroPaddedInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r < 0) {
            return 0;
        }
        return r;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int readIn = this.in.read(buffer, offset, length);
        if (readIn < length) {
            if (readIn > 0) {
                while ((buffer[offset + readIn - 1] == 10 || buffer[offset + readIn - 1] == 13 || buffer[offset + readIn - 1] == 32) && readIn > 0) {
                    --readIn;
                }
                return readIn;
            }
            int end = offset + length;
            for (int current = offset + Math.max(0, readIn); current < end; ++current) {
                buffer[current] = 0;
            }
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        int a = this.in.available();
        if (a <= 0) {
            a = 1;
        }
        return a;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long s = this.in.skip(n);
        return s;
    }
}

