/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf.file_network_tracking;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.gui.file_network_tracking.ShowingProgress;
import se.sjobeck.gui.file_network_tracking.ShowingProgressFactory;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.file_network_tracking.EkalkylPDFConfiguration;
import se.sjobeck.util.pdf.file_network_tracking.NetworkCommunicator;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListener;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListenerContainer;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListenerEvent;
import se.sjobeck.util.pdf.file_network_tracking.PDFTrackerListenerEventImpl;

public class PDFTracker {
    private static PDFTracker pdftracker = null;
    private final Object plocka_files_in_downoloadingQue = new Object();
    private transient Map<String, PDFTrackerListenerContainer> filesInDownLoadingQue = Collections.synchronizedMap(new HashMap());
    private final transient Map<String, Long> filesInUploadQue = Collections.synchronizedMap(new HashMap());

    private PDFTracker() {
    }

    public static PDFTracker getPDFTracker() {
        if (pdftracker != null) {
            return pdftracker;
        }
        pdftracker = new PDFTracker();
        return pdftracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tryDownloadPDF(String fileName, String projectName, PDFTrackerListener pdfTL) {
        String pro_fil_path = projectName + File.pathSeparator + fileName;
        Object object = this.plocka_files_in_downoloadingQue;
        synchronized (object) {
            if (!this.filesInDownLoadingQue.containsKey(pro_fil_path)) {
                PDFTrackerListenerContainer l = new PDFTrackerListenerContainer(pdfTL);
                Downloader dl = new Downloader(fileName, projectName, l);
                this.filesInDownLoadingQue.put(pro_fil_path, l);
                new Thread(dl).start();
            } else {
                this.filesInDownLoadingQue.get(pro_fil_path).addListenerButNotMoreThenOneTime(pdfTL);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized File importPDFToProject(String filePath, String projectName) {
        boolean yes;
        boolean mkdirs;
        String string_savepath_project = EkalkylPDFConfiguration.getSavePath() + File.separator + projectName;
        File savepath_project = new File(string_savepath_project);
        if (!savepath_project.exists() && !(mkdirs = savepath_project.mkdirs())) {
            DialogCreator.showError("<html>n\u00e5got gick fel n\u00e4r savepath f\u00f6rs\u00f6kte skapas<br>din pdf importerades inte</html>", "Ett fel uppstod");
            return null;
        }
        File pdfToImport = new File(filePath);
        if (!pdfToImport.exists()) {
            DialogCreator.showError("<html>pdf'en du ville importera finns inte</html>", "Ett fel uppstod");
            return null;
        }
        File pdfInProject = new File(EkalkylPDFConfiguration.getSavePath() + File.separator + projectName + File.separator + pdfToImport.getName());
        if (pdfInProject.exists()) {
            long crcOfpdfInProject;
            long crcOfpdfToImport = StaticHelpers.getCRC(pdfToImport);
            if (crcOfpdfToImport != (crcOfpdfInProject = StaticHelpers.getCRC(pdfInProject))) {
                int nr = 0;
                while (pdfInProject.exists()) {
                    String newFileName = string_savepath_project + File.separator + "_version_" + nr + "_" + pdfToImport.getName();
                    pdfInProject = new File(newFileName);
                    ++nr;
                }
                boolean managedToCopy = this.copyFile(pdfToImport, pdfInProject);
                if (!managedToCopy) return null;
                DialogCreator.showInformation("<html>Filen du vill importera finns redan, men i en annan version, version x+1 av filen skapad</html>", "Filen finns redan");
            }
        } else {
            try {
                pdfInProject.createNewFile();
            }
            catch (IOException ex) {
                Logger.getLogger(PDFTracker.class.getName()).log(Level.SEVERE, null, ex);
                DialogCreator.showError("<html>Kunde inte skapa filen i import katalogen <br><br>" + pdfInProject.getName() + "<br><br> Troligen beror det p\u00e5 att ditt projekt namn slutar p\u00e5 ett mellanslag. <br>D\u00f6p om projektet och f\u00f6rs\u00f6k importera igen", "Ingen ny fil skapad");
                return null;
            }
            boolean managedToCopy = this.copyFile(pdfToImport, pdfInProject);
            if (!managedToCopy) {
                return null;
            }
        }
        NetworkCommunicator nc = NetworkCommunicator.getNetworkCommunicator();
        long cRC_for_file_onServer = nc.getCRC(projectName, pdfInProject.getName());
        long crcOfpdfInProject = StaticHelpers.getCRC(pdfInProject);
        if (crcOfpdfInProject == -1L || crcOfpdfInProject == cRC_for_file_onServer || this.currentlyUploading(pdfInProject, crcOfpdfInProject) || !(yes = DialogCreator.showConfirm("<html>Vill du ladda upp filen till servern s\u00e5 att du kan <br> se p\u00e5 pdf-m\u00e4tningen p\u00e5 andra datorer? <br><br> fil: " + pdfInProject.getName() + "<br><br></html>", "skicka till server"))) return pdfInProject;
        this.startUploading(pdfInProject, crcOfpdfInProject, projectName);
        return pdfInProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(File src, File dst) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PDFTracker.class.getName()).log(Level.SEVERE, null, ex);
            DialogCreator.showError("<html>N\u00e5got gick fel under kopiering av fil</html>", "IOError");
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PDFTracker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PDFTracker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return true;
    }

    private synchronized boolean currentlyUploading(File pdfInProject, long crcOfpdfInProject) {
        return this.filesInUploadQue.containsKey(pdfInProject.getName());
    }

    private synchronized void startUploading(File pdfInProject, long crcOfpdfInProject, String projectName) {
        if (!this.filesInUploadQue.containsKey(pdfInProject.getName())) {
            this.filesInUploadQue.put(pdfInProject.getName(), crcOfpdfInProject);
            Uploader runnable = new Uploader(pdfInProject, projectName);
            new Thread(runnable).start();
        }
    }

    private class Downloader
    implements Runnable {
        private String fileName;
        private String projectName;
        private PDFTrackerListener pdfTL;
        private transient boolean fileIsOnServer = false;
        private transient boolean downloadOk = false;

        Downloader(String fileName, String projectName, PDFTrackerListener pdfTL) {
            this.fileName = fileName;
            this.projectName = projectName;
            this.pdfTL = pdfTL;
        }

        @Override
        public void run() {
            ShowingProgress aOnScreenDevice = ShowingProgressFactory.getShowingProgressFactory().getAOnScreenDevice();
            aOnScreenDevice.setMessage("H\u00e4mtar fil fr\u00e5n server");
            aOnScreenDevice.setTitle(this.fileName);
            aOnScreenDevice.setProgressBoundaries(1, 4);
            aOnScreenDevice.setProgress(1);
            aOnScreenDevice.startShowing();
            this.checkIfFileIsOnServer();
            aOnScreenDevice.setProgress(2);
            this.ifFileIsOnServerDownLoadIt();
            aOnScreenDevice.setProgress(3);
            this.talkWithPDFTrackerListener();
            aOnScreenDevice.setProgress(4);
            PDFTracker.this.filesInDownLoadingQue.remove(this.fileName + File.separator + this.projectName);
            aOnScreenDevice.finishedShowing();
        }

        private void checkIfFileIsOnServer() {
            Vector<String> fudo = NetworkCommunicator.getNetworkCommunicator().getFilesOnServer(this.projectName);
            if (fudo.contains(this.fileName)) {
                this.fileIsOnServer = true;
            }
        }

        private void ifFileIsOnServerDownLoadIt() {
            if (this.fileIsOnServer) {
                this.downloadOk = NetworkCommunicator.getNetworkCommunicator().getFile(this.projectName, this.fileName);
                if (!this.downloadOk) {
                    DialogCreator.showError("<html>Filen finns p\u00e5 servern men n\u00e5got gick fel under nerladdning<br><br>" + this.projectName + File.separator + this.fileName + "<br></html>", "Nedladdningsfel");
                }
            }
        }

        private void talkWithPDFTrackerListener() {
            Runnable IdontWantToDoSomeOtherThreadsWork;
            if (!this.fileIsOnServer) {
                IdontWantToDoSomeOtherThreadsWork = new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.pdfTL.wEEEEESomethingHappenedWithTheFileImInterestedIn(new PDFTrackerListenerEventImpl(Downloader.this.projectName, Downloader.this.fileName, PDFTrackerListenerEvent.State.NO_SUCH_FILE_ON_SERVER));
                    }
                };
                new Thread(IdontWantToDoSomeOtherThreadsWork).start();
            }
            if (this.downloadOk) {
                IdontWantToDoSomeOtherThreadsWork = new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.pdfTL.wEEEEESomethingHappenedWithTheFileImInterestedIn(new PDFTrackerListenerEventImpl(Downloader.this.projectName, Downloader.this.fileName, PDFTrackerListenerEvent.State.FILE_DOWNLOADED));
                    }
                };
                new Thread(IdontWantToDoSomeOtherThreadsWork).start();
            }
        }
    }

    private class Uploader
    implements Runnable {
        private File my_file;
        private String myProjectName;

        Uploader(File file, String projectName) {
            this.my_file = file;
            this.myProjectName = projectName;
        }

        @Override
        public void run() {
            ShowingProgress aOnScreenDevice = ShowingProgressFactory.getShowingProgressFactory().getAOnScreenDevice();
            aOnScreenDevice.setMessage("Skickar fil till server");
            aOnScreenDevice.setTitle(this.my_file.getName());
            aOnScreenDevice.startShowing();
            NetworkCommunicator nc = NetworkCommunicator.getNetworkCommunicator();
            boolean sendFile = nc.sendFile(this.myProjectName, this.my_file.getName(), StaticHelpers.getFileContent(this.my_file));
            if (!sendFile) {
                String filepath = this.my_file.getName();
                try {
                    filepath = this.my_file.getCanonicalPath();
                }
                catch (IOException ex) {
                    Logger.getLogger(PDFTracker.class.getName()).log(Level.SEVERE, null, ex);
                }
                DialogCreator.showError("<html>din fil kunde inte laddas upp <br><br>" + filepath + "<br><br></html>", "Error");
            }
            PDFTracker.this.filesInUploadQue.remove(this.my_file.getName());
            aOnScreenDevice.finishedShowing();
        }
    }
}

