/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf;

import java.util.List;
import java.util.Vector;
import se.sjobeck.util.pdf.PsiTabell;
import se.sjobeck.util.pdf.PsiTabellColumnSpacing;
import se.sjobeck.util.pdf.PsiTabellColumnSpacingImpl;
import se.sjobeck.util.pdf.PsiTabellObject;
import se.sjobeck.util.pdf.PsiTabellObjectImpl;

class PsiTabellImpl
implements PsiTabell {
    private PsiTabellObject tabellHeader;
    private int numberOfColumns;
    private int numberOfRows;
    private PsiTabellColumnSpacing ptcs;
    private List<PsiTabellObject> listPsiTabellObject;

    PsiTabellImpl(String tabellHeader, int numberOfColumns, int numberOfRows, int[] columSpacingWeight) {
        this.tabellHeader = new PsiTabellObjectImpl((Object)tabellHeader, 14, PsiTabellObject.TextSetting.FAT);
        this.numberOfColumns = numberOfColumns;
        this.numberOfRows = numberOfRows;
        this.ptcs = new PsiTabellColumnSpacingImpl(columSpacingWeight);
        this.listPsiTabellObject = new Vector<PsiTabellObject>();
    }

    @Override
    public PsiTabellObject getPsiTabellHeader() {
        return this.tabellHeader;
    }

    @Override
    public int getNumnberOfColums() {
        return this.numberOfColumns;
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public PsiTabellObject getCellObject(int col, int row) {
        int i = col + row * this.getNumnberOfColums();
        assert (i > -1);
        if (i < this.listPsiTabellObject.size()) {
            return this.listPsiTabellObject.get(i);
        }
        return new PsiTabellObjectImpl((Object)"", 12, PsiTabellObject.TextSetting.ORDINARY);
    }

    @Override
    public PsiTabellColumnSpacing getPsiTabellColumnSpacing() {
        return this.ptcs;
    }

    public void addPsiTabellObject(PsiTabellObject pto) {
        this.listPsiTabellObject.add(pto);
    }
}

