/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.network2;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.gui.outlookbar.JOutlookBarTabbed;
import se.sjobeck.network2.NetWorkCommunicator;
import se.sjobeck.util.StaticHelpers;

public class ProjectFolder {
    public void openFile(final KalkylGUI kalkylGUI, ExecutorService loadQueue, final ProjectManager projectManager, final JOutlookBarTabbed outlookBar, final File f) {
        if (f != null && !f.isDirectory()) {
            loadQueue.submit(new Runnable(){
                XStream xstream = new XStream(new DomDriver());

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block27: {
                        Projekt proj = projectManager.getProjectByFile(f);
                        if (proj != null) {
                            outlookBar.setVisibleBar(projectManager.getIndex(proj) + 2);
                        } else {
                            Object o = null;
                            try {
                                Logger.getLogger("se.sjobeck.gui").info("\u00d6ppnar projekt...");
                                o = NetWorkCommunicator.readFile(f.getName());
                            }
                            catch (Exception e) {
                                Logger.getLogger("se.sjobeck").throwing("KalkylGUI", "openAction", e);
                                Logger.getLogger("se.sjobeck.gui").warning("Kunde inte \u00f6ppna projekt!");
                            }
                            if (o != null) {
                                try {
                                    if (o instanceof byte[]) {
                                        ByteArrayInputStream bais = null;
                                        GZIPInputStream gzip = null;
                                        try {
                                            byte[] data = (byte[])o;
                                            bais = new ByteArrayInputStream(data);
                                            gzip = new GZIPInputStream(bais);
                                            Projekt p = (Projekt)this.xstream.fromXML(gzip);
                                            kalkylGUI.addProject(f, p);
                                            Logger.getLogger("se.sjobeck.gui").info("Klar.");
                                            break block27;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            Logger.getLogger("se.sjobeck.gui").warning("Kunde inte \u00f6ppna projekt!");
                                            break block27;
                                        }
                                        finally {
                                            if (bais != null) {
                                                try {
                                                    bais.close();
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(ProjectFolder.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                            if (gzip != null) {
                                                try {
                                                    gzip.close();
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(ProjectFolder.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                        }
                                    }
                                    Logger.getLogger("se.sjobeck.gui").warning("Kunde inte \u00f6ppna projekt!");
                                    throw new IllegalArgumentException();
                                }
                                catch (ClassCastException e) {
                                    StaticHelpers.warn("Kunde inte \u00f6ppna filen.", kalkylGUI);
                                    Logger.getLogger("se.sjobeck.gui").warning("Kunde inte \u00f6ppna projekt!");
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public void saveProject(Projekt p) throws IOException {
        NetWorkCommunicator.writeFile(p.getFileReference().getName(), this.project2bytes(p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] project2bytes(Projekt p) {
        XStream xstream = new XStream(new DomDriver());
        ByteArrayOutputStream baos = null;
        DeflaterOutputStream dos = null;
        try {
            Logger.getLogger("se.sjobeck").fine("Deflating data...");
            String data = xstream.toXML(p);
            byte[] input = data.getBytes("UTF-8");
            baos = new ByteArrayOutputStream();
            dos = new GZIPOutputStream(baos);
            dos.write(input);
            ((GZIPOutputStream)dos).finish();
            byte[] output = baos.toByteArray();
            System.out.println("byte array output stream length: " + output.length);
            Logger.getLogger("se.sjobeck").fine("Data deflated, " + (float)output.length / (float)input.length * 100.0f + " percent of original size");
            byte[] byArray = output;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(KalkylGUI.class.getName()).log(Level.SEVERE, null, ex);
                    System.out.println(ex.getMessage() + " kalklgui dos.close fail");
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(KalkylGUI.class.getName()).log(Level.SEVERE, null, ex);
                    System.out.println(ex.getMessage() + " kalklgui baos.close fail");
                }
            }
        }
        return new byte[0];
    }
}

