/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.PopupEditorPanel;
import se.sjobeck.gui.StopEditingEventListener;

abstract class PopupListEditor
extends JPanel
implements PopupEditorPanel {
    protected JTextField textField = null;
    private StopEditingEventListener stopper = new StopEditingEventListener();
    private AutoDocument autoCompleter = new AutoDocument();
    private List<String> matches = new ArrayList<String>();
    private int selectedCandidate = 0;
    private boolean isStrict;
    private Action selectNext = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            event.setSource(PopupListEditor.this.list);
            PopupListEditor.this.list.getActionMap().get("selectNextRow").actionPerformed(event);
        }
    };
    private Action selectPrevious = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            event.setSource(PopupListEditor.this.list);
            PopupListEditor.this.list.getActionMap().get("selectPreviousRow").actionPerformed(event);
        }
    };
    private Action nextMatch = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PopupListEditor.this.selectedCandidate += 1;
            if (PopupListEditor.this.selectedCandidate >= PopupListEditor.this.matches.size()) {
                PopupListEditor.this.selectedCandidate = PopupListEditor.this.matches.size() - 1;
            }
            try {
                PopupListEditor.this.autoCompleter.replace(PopupListEditor.this.textField.getSelectionStart(), PopupListEditor.this.textField.getSelectionEnd() - PopupListEditor.this.textField.getSelectionStart(), "", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    };
    private Action previousMatch = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PopupListEditor.this.selectedCandidate -= 1;
            if (PopupListEditor.this.selectedCandidate <= 0) {
                PopupListEditor.this.selectedCandidate = 0;
            }
            try {
                PopupListEditor.this.autoCompleter.replace(PopupListEditor.this.textField.getSelectionStart(), PopupListEditor.this.textField.getSelectionEnd() - PopupListEditor.this.textField.getSelectionStart(), "", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    };
    private ListSelectionListener updateTextField = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PopupListEditor.this.textField != null && PopupListEditor.this.list.getSelectedValue() != null) {
                PopupListEditor.this.textField.setText(PopupListEditor.this.formatSelection(PopupListEditor.this.list.getSelectedValue()));
            }
        }
    };
    private JScrollPane jScrollPane1;
    protected JList list;

    private void buildMatches(String s) {
        this.matches.clear();
        this.selectedCandidate = 0;
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            String s1 = this.list.getModel().getElementAt(i).toString();
            if (s1 == null || !s1.toLowerCase().startsWith(s.toLowerCase())) continue;
            this.matches.add(s1);
        }
    }

    public PopupListEditor() {
        this(false);
    }

    public PopupListEditor(boolean strict) {
        this.isStrict = strict;
        this.initComponents();
        this.list.addMouseListener(this.stopper);
        this.list.addKeyListener(this.stopper);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.list);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public abstract ListModel getListModel(RadStruct var1);

    @Override
    public abstract Object getValue(RadStruct var1);

    public String formatSelection(Object value) {
        return value.toString();
    }

    public Object getSelectedValue(RadStruct r) {
        return this.getValue(r);
    }

    @Override
    public void init(RadStruct r, JTextField text, TableCellEditor editor) {
        this.textField = text;
        this.list.setModel(this.getListModel(r));
        Object ob = this.getSelectedValue(r);
        if (ob != null) {
            this.list.setSelectedValue(ob, true);
        } else {
            this.list.setSelectedIndex(-1);
        }
        this.list.addListSelectionListener(this.updateTextField);
        this.stopper.setCellEditor(editor);
        this.textField.setDocument(this.autoCompleter);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "nextMatch");
        this.textField.getActionMap().put("nextMatch", this.nextMatch);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "previousMatch");
        this.textField.getActionMap().put("previousMatch", this.previousMatch);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke("pressed DOWN"), "selectNextRow");
        this.textField.getActionMap().put("selectNextRow", this.selectNext);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke("pressed UP"), "selectPreviousRow");
        this.textField.getActionMap().put("selectPreviousRow", this.selectPrevious);
    }

    @Override
    public void uninit() {
        this.stopper.setCellEditor(null);
        this.list.removeListSelectionListener(this.updateTextField);
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        Logger.getLogger("se.sjobeck.gui.PopupListEditor").finest("return value: " + this.textField.getText());
        return this.textField.getText().trim();
    }

    class AutoDocument
    extends PlainDocument {
        AutoDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attributeSet) throws BadLocationException {
            block5: {
                if (text == null) {
                    return;
                }
                String s1 = PopupListEditor.this.textField.getText(0, offset);
                if (!"".equals(text)) {
                    PopupListEditor.this.buildMatches(s1 + text);
                }
                try {
                    String fullWord = (String)PopupListEditor.this.matches.get(PopupListEditor.this.selectedCandidate);
                    if (!PopupListEditor.this.isStrict) {
                        fullWord = s1 + text + fullWord.substring(s1.length() + text.length());
                    }
                    super.remove(0, this.getLength());
                    super.insertString(0, fullWord, attributeSet);
                    PopupListEditor.this.textField.setSelectionStart(offset + text.length());
                    PopupListEditor.this.textField.setSelectionEnd(this.getLength());
                }
                catch (IndexOutOfBoundsException e) {
                    if (PopupListEditor.this.isStrict) break block5;
                    super.replace(offset, length, text, attributeSet);
                }
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            if (PopupListEditor.this.isStrict) {
                if (offset > 0) {
                    --offset;
                }
                PopupListEditor.this.buildMatches(PopupListEditor.this.textField.getText(0, offset));
                PopupListEditor.this.textField.setSelectionStart(offset);
                PopupListEditor.this.textField.setSelectionEnd(this.getLength());
            } else {
                super.remove(offset, length);
                PopupListEditor.this.buildMatches(PopupListEditor.this.textField.getText());
            }
        }
    }
}

