/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.gui.Ackumulerat;
import se.sjobeck.gui.AntialiasedJLabel;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.gui.NodeTableModel;
import se.sjobeck.gui.SelectingEditor;
import se.sjobeck.gui.SplitPaneFactory;
import se.sjobeck.gui.StatistikPanel;
import se.sjobeck.gui.multilinetable2.MultilineAwareRowHeader;
import se.sjobeck.gui.multilinetable2.RowHeaderDragListener;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;

public class GrenPanel
extends JPanel {
    private KalkylGUI gui;
    protected NodeTableModel model;
    private KalkylNod currentNode;
    private ProjectManager projectManager;
    private Observer treeObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null && arg.equals(GrenPanel.this.currentNode)) {
                GrenPanel.this.titel.setText(GrenPanel.this.currentNode.getBeskrivning());
            }
        }
    };
    private JPanel jPanel1;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    protected JTable nodTabell;
    private JPanel rumPanelTop;
    private JPanel rumRader;
    private JPanel statistik;
    private JLabel titel;

    public GrenPanel(KalkylGUI gui, ProjectManager manager) {
        this.gui = gui;
        this.projectManager = manager;
        this.initComponents();
        this.model = new NodeTableModel(this.projectManager);
        this.nodTabell.setModel(this.model);
        TextAreaRenderer centered = new TextAreaRenderer(1);
        TextAreaRenderer leftAligned = new TextAreaRenderer();
        this.nodTabell.getColumnModel().getColumn(0).setCellRenderer(leftAligned);
        this.nodTabell.getColumnModel().getColumn(1).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(2).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(3).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(4).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(5).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(6).setCellRenderer(centered);
        this.nodTabell.getColumnModel().getColumn(1).setCellEditor(new SelectingEditor(){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                KalkylNod n = (KalkylNod)GrenPanel.this.currentNode.getChildAt(row);
                return super.getTableCellEditorComponent(table, n.getAntalFormel(), isSelected, row, column);
            }
        });
        this.nodTabell.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((StatistikPanel)GrenPanel.this.statistik).updateStatistics();
                ((Ackumulerat)GrenPanel.this.rumRader).repaint();
            }
        });
        MultilineAwareRowHeader rowHead = new MultilineAwareRowHeader(this.nodTabell);
        this.jScrollPane4.setRowHeaderView(rowHead);
        RowHeaderDragListener drag = new RowHeaderDragListener(rowHead){

            @Override
            public void reorder(int dragStart, int dragEnd) {
                GrenPanel.this.model.reorder(dragStart, dragEnd);
            }
        };
        rowHead.addMouseListener(drag);
        rowHead.addMouseMotionListener(drag);
        final Preferences GrenPanel2 = Preferences.userNodeForPackage(this.getClass());
        for (int i = 0; i < this.nodTabell.getColumnCount(); ++i) {
            TableColumn col = this.nodTabell.getColumnModel().getColumn(i);
            col.setPreferredWidth(GrenPanel2.getInt("nodTabellBredd" + i, 100));
        }
        this.nodTabell.getTableHeader().setReorderingAllowed(false);
        this.nodTabell.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                for (int i = 0; i < GrenPanel.this.nodTabell.getColumnCount(); ++i) {
                    TableColumn col = GrenPanel.this.nodTabell.getColumnModel().getColumn(i);
                    GrenPanel2.putInt("nodTabellBredd" + i, col.getWidth());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiersEx() & 0x80) == 128) {
                    GrenPanel.this.model.sortByColumn(-1);
                } else {
                    GrenPanel.this.model.sortByColumn(GrenPanel.this.nodTabell.getColumnModel().getColumnIndexAtX(e.getX()));
                }
                GrenPanel.this.nodTabell.getTableHeader().repaint();
            }
        });
        final TableCellRenderer defaultHeader = this.nodTabell.getTableHeader().getDefaultRenderer();
        this.nodTabell.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel c = (JLabel)defaultHeader.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == GrenPanel.this.model.getSortingColumn()) {
                    c.setFont(c.getFont().deriveFont(1));
                } else {
                    c.setFont(c.getFont().deriveFont(0));
                }
                return c;
            }
        });
        this.jSplitPane1.setDividerLocation(GrenPanel2.getInt("splitPane1", -1));
        this.jSplitPane1.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GrenPanel2.putInt("splitPane1", GrenPanel.this.jSplitPane1.getDividerLocation());
            }
        });
        ((Ackumulerat)this.rumRader).jTable1.setSelectionMode(0);
    }

    public void setKalkylNod(KalkylNod nod) {
        this.currentNode = nod;
        this.titel.setText(nod.getBeskrivning());
        this.currentNode.getProject().setTreeObserver(this.treeObserver);
        this.model.setData(nod);
        ((StatistikPanel)this.statistik).setCurrentNode(nod);
        ((Ackumulerat)this.rumRader).setNode(nod);
    }

    public void updateInformation() {
    }

    private void initComponents() {
        this.titel = new AntialiasedJLabel();
        this.statistik = new StatistikPanel(this.projectManager);
        this.jSplitPane1 = SplitPaneFactory.createSplitPane(this.gui, "grenPanel");
        this.rumPanelTop = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.nodTabell = new JTable();
        this.jPanel1 = new JPanel();
        this.rumRader = new Ackumulerat(this.gui, this.projectManager, false, true);
        this.setLayout(new GridBagLayout());
        this.titel.setFont(new Font("SansSerif", 1, 24));
        this.titel.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/x-directory-normal.png")));
        this.titel.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 24, 20, 5);
        this.add((Component)this.titel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.statistik, gridBagConstraints);
        this.jSplitPane1.setOrientation(0);
        this.rumPanelTop.setPreferredSize(new Dimension(468, 200));
        this.rumPanelTop.setLayout(new GridBagLayout());
        this.jScrollPane4.setBorder(BorderFactory.createTitledBorder(null, "Ing\u00e5ende delar"));
        this.nodTabell.setAutoResizeMode(0);
        this.nodTabell.setIntercellSpacing(new Dimension(0, 0));
        this.nodTabell.setShowHorizontalLines(false);
        this.nodTabell.setShowVerticalLines(false);
        this.jScrollPane4.setViewportView(this.nodTabell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rumPanelTop.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.rumPanelTop);
        this.jPanel1.setLayout(new GridBagLayout());
        this.rumRader.setBorder(BorderFactory.createTitledBorder(null, "Kalkylrader"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.rumRader, gridBagConstraints);
        this.jSplitPane1.setBottomComponent(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }
}

