/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.PolygonDrawing;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.RumNod;
import se.sjobeck.gui.RumPanel;

public class DrawingPanel
extends JPanel {
    private static final Polygon baseArrow = new Polygon(new int[]{0, 10, 10}, new int[]{5, 0, 10}, 3);
    private static final Polygon baseBox = new Polygon(new int[]{0, 10, 10, 0}, new int[]{0, 0, 10, 10}, 4);
    protected Rectangle areaConstraints;
    protected Drawing currentDrawing;
    Area leftArrow;
    Area rightArrow;
    Dimension cachedSize;
    int currentSelection = 0;
    boolean highlightLeft;
    boolean highlightRight;
    private transient ProjectManager projectManager;
    private transient RumPanel rumPanel;

    public DrawingPanel() {
        this.addMouseMotionListener(new HighlightListener());
        this.addMouseListener(new ChangeDrawingListener());
        this.currentDrawing = Drawing.standard[0].copy();
        this.areaConstraints = new Rectangle();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getForeground());
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.updateAreas();
        this.currentDrawing.paintDrawing(g2, this.areaConstraints);
        if (this.highlightLeft) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(this.getForeground());
        }
        g2.fill(this.leftArrow);
        if (this.highlightRight) {
            g2.setColor(Color.red);
        } else {
            g2.setColor(this.getForeground());
        }
        g2.fill(this.rightArrow);
    }

    protected void updateAreas() {
        this.cachedSize = this.getSize();
        Insets insets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        this.leftArrow = new Area(baseArrow);
        this.leftArrow.transform(AffineTransform.getTranslateInstance(insets.left, this.cachedSize.height - insets.bottom - 10));
        this.rightArrow = new Area(baseArrow);
        this.rightArrow.transform(AffineTransform.getRotateInstance(Math.PI, 5.0, 5.0));
        this.rightArrow.transform(AffineTransform.getTranslateInstance(insets.left + 30, this.cachedSize.height - insets.bottom - 10));
        insets.bottom += 20;
        this.areaConstraints.setBounds(insets.left, insets.top, this.cachedSize.width - insets.left - insets.right, this.cachedSize.height - insets.top - insets.bottom);
    }

    public void setDrawing(Drawing d) {
        if (this.getBorder() != null) {
            ((TitledBorder)this.getBorder()).setTitle("Grafik - " + d.getDescription());
        }
        if (this.currentDrawing instanceof MouseListener) {
            this.removeMouseListener((MouseListener)((Object)this.currentDrawing));
        }
        if (this.currentDrawing instanceof MouseMotionListener) {
            this.removeMouseMotionListener((MouseMotionListener)((Object)this.currentDrawing));
        }
        this.currentDrawing = d;
        if (this.currentDrawing instanceof MouseListener) {
            this.addMouseListener((MouseListener)((Object)this.currentDrawing));
        }
        if (this.currentDrawing instanceof MouseMotionListener) {
            this.addMouseMotionListener((MouseMotionListener)((Object)this.currentDrawing));
        }
        this.updateAreas();
        this.repaint();
    }

    void setManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    void setRumPanel(RumPanel rumPanel) {
        this.rumPanel = rumPanel;
    }

    private class ChangeDrawingListener
    extends MouseAdapter {
        private ChangeDrawingListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DrawingPanel.this.leftArrow.contains(e.getPoint())) {
                --DrawingPanel.this.currentSelection;
                if (DrawingPanel.this.currentSelection == -1) {
                    DrawingPanel.this.currentSelection = PolygonDrawing.standard.length - 1;
                }
                DrawingPanel.this.setDrawing(PolygonDrawing.standard[DrawingPanel.this.currentSelection].copy());
            } else if (DrawingPanel.this.rightArrow.contains(e.getPoint())) {
                DrawingPanel.this.currentSelection = (DrawingPanel.this.currentSelection + 1) % PolygonDrawing.standard.length;
                DrawingPanel.this.setDrawing(PolygonDrawing.standard[DrawingPanel.this.currentSelection].copy());
            }
            DrawingPanel.this.repaint();
            this.setNewDrawingInTreeNode();
        }

        private void setNewDrawingInTreeNode() {
            Object currentNod;
            if (DrawingPanel.this.projectManager != null && (currentNod = DrawingPanel.this.projectManager.getCurrentNod()) instanceof RumNod) {
                RumNod rn = (RumNod)currentNod;
                rn.setDrawing(DrawingPanel.this.currentDrawing);
                DrawingPanel.this.rumPanel.updatePanel();
            }
        }
    }

    private class HighlightListener
    extends MouseMotionAdapter {
        private HighlightListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            DrawingPanel.this.highlightLeft = DrawingPanel.this.leftArrow.contains(e.getPoint());
            DrawingPanel.this.highlightRight = DrawingPanel.this.rightArrow.contains(e.getPoint());
            DrawingPanel.this.repaint();
        }
    }
}

