/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.util.Observable;
import java.util.Vector;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.gui.FunctionTableModel;
import se.sjobeck.parser2.Function;
import se.sjobeck.util.StaticHelpers;

public class ConstantTableModel
extends FunctionTableModel {
    private ProjectManager projectManager;
    private static Vector<Function> emptyVector = new Vector();

    public ConstantTableModel(ProjectManager manager) {
        this.projectManager = manager;
    }

    public void update(Observable ob, Object param) {
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.getRows().size();
    }

    private Vector<Function> getRows() {
        try {
            return this.projectManager.getCurrentProject().getKonstanter();
        }
        catch (NullPointerException e) {
            return emptyVector;
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Namn";
            }
            case 1: {
                return "V\u00e4rde";
            }
            case 2: {
                return "Beskrivning";
            }
        }
        return null;
    }

    @Override
    public Function getFunction(int row, int col) {
        return this.getRows().elementAt(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.getRows().size() || row < 0) {
            return "Error.";
        }
        Function v = this.getRows().elementAt(row);
        switch (column) {
            case 0: {
                return v.getIdentifier();
            }
            case 1: {
                try {
                    return StaticHelpers.format2Dec(v.getValue(this.getRows()));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return "#";
                }
            }
            case 2: {
                return v.getDescription();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Function v = this.getRows().elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                v.setValueStr(aValue.toString());
                this.projectManager.getCurrentProject().recalculate(this.projectManager.getCurrentProject().getRader());
                break;
            }
            case 2: {
                v.setDescription(aValue.toString());
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }
}

