/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.multilinetable2.TextAreaRenderer;

public class AckumuleratTableCellRenderer
extends TextAreaRenderer {
    private EditableRadTable radModel;

    public AckumuleratTableCellRenderer(EditableRadTable radModel) {
        this.radModel = radModel;
    }

    public AckumuleratTableCellRenderer(EditableRadTable radModel, int alignment) {
        super(alignment);
        this.radModel = radModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof RadStruct) {
            value = this.radModel.getStringValueAt((RadStruct)value, column);
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        MutableAttributeSet attr = super.getInputAttributes();
        if (!this.radModel.isSumRow(row)) {
            if (this.radModel.hasErrors(row, column)) {
                this.setForeground(Color.red);
            }
            StyleConstants.setUnderline(attr, this.radModel.understrike(row, column));
        } else {
            StyleConstants.setUnderline(attr, false);
        }
        this.getStyledDocument().setCharacterAttributes(0, this.getStyledDocument().getLength(), attr, true);
        if (isSelected && hasFocus) {
            this.setBackground(new Color(240, 255, 240));
        }
        return this;
    }
}

