/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.io.File;
import java.util.List;
import java.util.Vector;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.RumNod;

public class ProjectManager {
    private List<Projekt> openedProjects = new Vector<Projekt>();
    private Projekt currentProject = null;
    private KalkylNod currentNode = null;

    public Projekt getCurrentProject() {
        return this.currentProject;
    }

    public KalkylNod getCurrentKalkylNod() {
        return this.currentNode;
    }

    public RumNod getCurrentRumNod() {
        return (RumNod)this.currentNode;
    }

    public <T extends KalkylNod> T getCurrentNod() {
        return (T)this.currentNode;
    }

    public void setCurrentProject(Projekt currentProject) {
        this.currentProject = currentProject;
        this.currentNode = null;
    }

    public void setCurrentProject(int projectIndex) {
        this.currentNode = null;
        try {
            this.currentProject = this.openedProjects.get(projectIndex);
        }
        catch (IndexOutOfBoundsException e) {
            this.currentProject = null;
        }
    }

    public void setCurrentNode(KalkylNod currentNode) {
        this.currentNode = currentNode;
    }

    public void add(Projekt p) {
        this.openedProjects.add(p);
        this.currentProject = p;
        this.currentNode = null;
    }

    public List<Projekt> getOpenProjects() {
        return this.openedProjects;
    }

    public int getIndex(Projekt p) {
        return this.openedProjects.indexOf(p);
    }

    public Projekt getProjectByFile(File f) {
        for (Projekt p : this.openedProjects) {
            if (!p.getFileReference().equals(f)) continue;
            return p;
        }
        return null;
    }

    public void remove(Projekt p) {
        if (this.openedProjects.remove(p) && p == this.currentProject) {
            this.currentProject = null;
            this.currentNode = null;
        }
    }
}

