/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.datastructures.VertexDrawing;
import se.sjobeck.parser2.Function;

public class Point2DDrawingWithHoleDrawing
extends VertexDrawing {
    private GeneralPath path;
    private Vector<Function> variables;
    private List<Point2D> vertices;
    private List<List<Point2D>> holedrawingVertices;

    public Point2DDrawingWithHoleDrawing() {
    }

    public Point2DDrawingWithHoleDrawing(List<Point2D> vertices, String desc, List<List<Point2D>> holedrawingVerticesList) {
        this.description = desc;
        this.vertices = vertices;
        this.holedrawingVertices = holedrawingVerticesList;
        this.variables = new Vector();
        this.path = new GeneralPath();
        this.path.moveTo((float)vertices.get(0).getX(), (float)vertices.get(0).getY());
        for (int i = 1; i < vertices.size(); ++i) {
            this.path.lineTo((float)vertices.get(i).getX(), (float)vertices.get(i).getY());
        }
        this.makeVariables(this.variables, this.vertices, this.path);
        double area = this.computeArea(vertices);
        if (area < 0.0) {
            area *= -1.0;
        }
        double reduktionsArea = 0.0;
        for (List<Point2D> lp2d : holedrawingVerticesList) {
            double temp = this.computeArea(lp2d);
            if (temp < 0.0) {
                temp *= -1.0;
            }
            reduktionsArea += temp;
        }
        this.variables.add(new Function("T", "" + (area -= reduktionsArea), "Takyta"));
        this.variables.add(new Function("G", "" + area, "Golvyta"));
        this.path.closePath();
    }

    private double computeArea(List<Point2D> vertices) {
        double area = 0.0;
        for (int i = 0; i < vertices.size() - 1; ++i) {
            area += vertices.get(i).getX() * vertices.get(i + 1).getY() - vertices.get(i + 1).getX() * vertices.get(i).getY();
        }
        return (area += vertices.get(vertices.size() - 1).getX() * vertices.get(0).getY() - vertices.get(0).getX() * vertices.get(vertices.size() - 1).getY()) / 2.0;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.path.getBounds2D();
    }

    @Override
    public Vector<Function> getVariables() {
        return this.variables;
    }

    @Override
    public int getLabelCount() {
        return this.vertices.size();
    }

    @Override
    public String getLabel(int which) {
        return "V" + (which + 1);
    }

    @Override
    public Point2D getLabelPosition(int which) {
        Point2D p1 = this.vertices.get(which);
        Point2D p2 = this.vertices.get((which + 1) % this.vertices.size());
        return new Point2D.Double(p1.getX() + (p2.getX() - p1.getX()) / 2.0, p1.getY() + (p2.getY() - p1.getY()) / 2.0);
    }

    @Override
    public Drawing copy() {
        ArrayList<Point2D> verticesCopy = new ArrayList<Point2D>();
        for (Point2D point2D : this.vertices) {
            verticesCopy.add((Point2D)point2D.clone());
        }
        ArrayList<List<Point2D>> holeDrawingVerticesCopy = new ArrayList<List<Point2D>>();
        for (List<Point2D> lp2d : this.holedrawingVertices) {
            ArrayList<Point2D> lp2DCopy = new ArrayList<Point2D>();
            for (Point2D p2d3 : lp2d) {
                lp2DCopy.add((Point2D)p2d3.clone());
            }
            holeDrawingVerticesCopy.add(lp2DCopy);
        }
        Point2DDrawingWithHoleDrawing point2DDrawingWithHoleDrawing = new Point2DDrawingWithHoleDrawing(verticesCopy, this.description, holeDrawingVerticesCopy);
        Vector<Function> var = new Vector<Function>();
        for (Function fu : this.variables) {
            var.add(new Function(fu.getIdentifier(), fu.getValueStr(), fu.getDescription()));
        }
        point2DDrawingWithHoleDrawing.variables = var;
        return point2DDrawingWithHoleDrawing;
    }

    @Override
    protected DrawingLine getLine(Point2D p, AffineTransform transform) {
        DrawingLine line = new DrawingLine();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        if (transform != null) {
            for (int i = 0; i < this.vertices.size(); ++i) {
                p1.setLocation(this.vertices.get(i));
                transform.transform(p1, p1);
                p2.setLocation(this.vertices.get((i + 1) % this.vertices.size()));
                transform.transform(p2, p2);
                line.setLine(p1, p2);
                if (!(line.ptSegDist(p) < 5.0)) continue;
                line.variable = "V" + (i + 1);
                return line;
            }
        }
        return null;
    }
}

